/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeToDatabaseTypeMapping;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class DatabasePlatformJDBCPropertiesPage
extends ScrollablePropertiesPage {
    private ListValueModel databaseTypesHolder;
    private TableModel tableModel;
    static final Icon EMPTY_ICON = new EmptyIcon(5);

    public DatabasePlatformJDBCPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel selectionNodeHolder) {
        super.initialize(selectionNodeHolder);
        this.databaseTypesHolder = this.buildSortedDatabaseTypesAdapter();
        this.tableModel = this.buildTableModel();
    }

    private ListValueModel buildSortedDatabaseTypesAdapter() {
        return new SortedListValueModelAdapter(this.buildDatabaseTypesAdapter());
    }

    private CollectionValueModel buildDatabaseTypesAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "databaseTypes"){

            protected Iterator getValueFromSubject() {
                return ((DatabasePlatform)this.subject).databaseTypes();
            }

            protected int sizeFromSubject() {
                return ((DatabasePlatform)this.subject).databaseTypesSize();
            }
        };
    }

    private TableModel buildTableModel() {
        return new TableModelAdapter(this.buildSortedMappingsAdapter(), this.buildColumnAdapter());
    }

    private ListValueModel buildSortedMappingsAdapter() {
        return new SortedListValueModelAdapter(this.buildMappingsAdapter());
    }

    private CollectionValueModel buildMappingsAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "jdbcTypeToDatabaseTypeMappings"){

            protected Iterator getValueFromSubject() {
                return ((DatabasePlatform)this.subject).jdbcTypeToDatabaseTypeMappings();
            }

            protected int sizeFromSubject() {
                return ((DatabasePlatform)this.subject).jdbcTypeToDatabaseTypeMappingsSize();
            }
        };
    }

    private ColumnAdapter buildColumnAdapter() {
        return new MappingColumnAdapter(this.getApplicationContext());
    }

    protected Component buildPage() {
        return new JScrollPane(this.buildTable());
    }

    private JTable buildTable() {
        JTable table = SwingComponentFactory.buildTable(this.tableModel);
        int rowHeight = 20;
        TableColumn jdbcTypeColumn = table.getColumnModel().getColumn(0);
        jdbcTypeColumn.setCellRenderer(this.buildJDBCTypeRenderer());
        TableColumn dbTypeColumn = table.getColumnModel().getColumn(1);
        ComboBoxTableCellRenderer dbTypeRenderer = this.buildDatabaseTypeComboBoxRenderer();
        dbTypeColumn.setCellRenderer(dbTypeRenderer);
        dbTypeColumn.setCellEditor(new TableCellEditorAdapter(this.buildDatabaseTypeComboBoxRenderer()));
        rowHeight = Math.max(rowHeight, dbTypeRenderer.getPreferredHeight());
        table.setRowHeight(rowHeight);
        return table;
    }

    private TableCellRenderer buildJDBCTypeRenderer() {
        return new AdaptableTableCellRenderer(new AbstractCellRendererAdapter(){

            public String buildText(Object value) {
                return ((JDBCType)value).displayString();
            }

            public Icon buildIcon(Object value) {
                return EMPTY_ICON;
            }
        });
    }

    private ComboBoxTableCellRenderer buildDatabaseTypeComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildReadOnlyDatabaseTypeComboBoxModel(), this.buildDatabaseTypeRenderer());
    }

    private ComboBoxModel buildReadOnlyDatabaseTypeComboBoxModel() {
        return new ComboBoxModelAdapter(this.databaseTypesHolder, (PropertyValueModel)new SimplePropertyValueModel());
    }

    private ListCellRenderer buildDatabaseTypeRenderer() {
        return new AdaptableListCellRenderer(new AbstractCellRendererAdapter(){

            public String buildText(Object value) {
                return value == null ? null : ((DatabaseType)value).displayString();
            }

            public Icon buildIcon(Object value) {
                return EMPTY_ICON;
            }
        });
    }

    private static class MappingColumnAdapter
    implements ColumnAdapter {
        private ApplicationContext context;
        public static final int COLUMN_COUNT = 2;
        public static final int JDBC_TYPE_COLUMN = 0;
        public static final int DATABASE_TYPE_COLUMN = 1;
        private static final String[] COLUMN_NAMES = new String[]{"DATABASE_PLATFORM_JDBC_TYPE_COLUMN", "DATABASE_PLATFORM_DATABASE_TYPE_COLUMN"};
        private static final String[] EMPTY_STRING_ARRAY = new String[0];

        MappingColumnAdapter(ApplicationContext context) {
            this.context = context;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int index) {
            return this.context.getResourceRepository().getString(COLUMN_NAMES[index]);
        }

        public Class getColumnClass(int index) {
            return Object.class;
        }

        public boolean isColumnEditable(int index) {
            return index != 0;
        }

        public PropertyValueModel[] cellModels(Object subject) {
            JDBCTypeToDatabaseTypeMapping mapping = (JDBCTypeToDatabaseTypeMapping)subject;
            PropertyValueModel[] result = new PropertyValueModel[]{this.buildJDBCTypeAdapter(mapping), this.buildDatabaseTypeAdapter(mapping)};
            return result;
        }

        private PropertyValueModel buildJDBCTypeAdapter(JDBCTypeToDatabaseTypeMapping mapping) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter(EMPTY_STRING_ARRAY, (Model)mapping){

                protected Object getValueFromSubject() {
                    return ((JDBCTypeToDatabaseTypeMapping)this.subject).getJDBCType();
                }

                protected void setValueOnSubject(Object value) {
                    throw new UnsupportedOperationException();
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "name");
        }

        private PropertyValueModel buildDatabaseTypeAdapter(JDBCTypeToDatabaseTypeMapping mapping) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("databaseType", (Model)mapping){

                protected Object getValueFromSubject() {
                    return ((JDBCTypeToDatabaseTypeMapping)this.subject).getDatabaseType();
                }

                protected void setValueOnSubject(Object value) {
                    ((JDBCTypeToDatabaseTypeMapping)this.subject).setDatabaseType((DatabaseType)value);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "name");
        }
    }
}

