/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository;

import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository.DatabasePlatformRepositoryNode;

final class RenameDatabasePlatformRepositoryAction
extends AbstractFrameworkAction {
    public RenameDatabasePlatformRepositoryAction(WorkbenchContext context) {
        super(context);
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("RENAME_DATABASE_PLATFORM_REPOSITORY");
        this.initializeIcon("RENAME_DATABASE_PLATFORM_REPOSITORY");
        this.initializeToolTipText("RENAME_DATABASE_PLATFORM_REPOSITORY.TOOL_TIP");
    }

    protected void execute() {
        TreePath[] paths = this.navigatorSelectionModel().getSelectionPaths();
        NewNameDialog.Builder builder = this.buildNewNameDialogBuilder();
        ApplicationNode[] nodes = this.selectedNodes();
        int i = nodes.length;
        while (i-- > 0) {
            this.execute(((DatabasePlatformRepositoryNode)nodes[i]).getDatabasePlatformRepository(), builder);
        }
        this.navigatorSelectionModel().setSelectionPaths(paths);
    }

    private NewNameDialog.Builder buildNewNameDialogBuilder() {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTitle(this.resourceRepository().getString("RENAME_DATABASE_PLATFORM_REPOSITORY_DIALOG_TITLE"));
        builder.setTextFieldDescription(this.resourceRepository().getString("RENAME_DATABASE_PLATFORM_REPOSITORY_DIALOG_DESCRIPTION"));
        builder.setHelpTopicId("dialog.dbPlatformRepositoryRename");
        return builder;
    }

    protected void execute(DatabasePlatformRepository repository, NewNameDialog.Builder builder) {
        builder.setOriginalName(repository.getName());
        NewNameDialog dialog = builder.buildDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasConfirmed()) {
            repository.setName(dialog.getNewName());
        }
    }
}

