/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.PoolsConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ReadConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.WriteConnectionPoolConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ReadConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.WriteConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PoolsAdapter
extends SCAdapter {
    private Collection pools;
    private volatile ReadConnectionPoolAdapter readConnectionPool;
    public static final String READ_CONNECTION_POOL_CONFIG_PROPERTY = "readConnectionPoolConfig";
    private volatile WriteConnectionPoolAdapter writeConnectionPool;
    public static final String WRITE_CONNECTION_POOL_CONFIG_PROPERTY = "writeConnectionPoolConfig";
    private volatile ConnectionPoolAdapter sequenceConnectionPool;
    public static final String SEQUENCE_CONNECTION_POOL_CONFIG_PROPERTY = "sequenceConnectionPoolConfig";

    PoolsAdapter(SCAdapter parent, PoolsConfig scConfig) {
        super(parent, scConfig);
    }

    protected PoolsAdapter(SCAdapter parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.pools;
        synchronized (collection) {
            children.addAll(this.pools);
        }
        if (this.readConnectionPool != null) {
            children.add(this.readConnectionPool);
        }
        if (this.writeConnectionPool != null) {
            children.add(this.writeConnectionPool);
        }
        if (this.sequenceConnectionPool != null) {
            children.add(this.sequenceConnectionPool);
        }
    }

    @Override
    protected Object buildModel() {
        return new PoolsConfig();
    }

    ReadConnectionPoolAdapter addReadConnectionPool() {
        if (this.readConnectionPool == null) {
            this.readConnectionPool = new ReadConnectionPoolAdapter(this);
            this.config().setReadConnectionPoolConfig((ReadConnectionPoolConfig)this.readConnectionPool.getModel());
        }
        return this.readConnectionPool;
    }

    ConnectionPoolAdapter addSequenceConnectionPool() {
        if (this.sequenceConnectionPool == null) {
            this.sequenceConnectionPool = new ConnectionPoolAdapter((SCAdapter)this, "SequenceConnectionPool");
            this.config().setSequenceConnectionPoolConfig((ConnectionPoolConfig)this.sequenceConnectionPool.getModel());
        }
        return this.sequenceConnectionPool;
    }

    WriteConnectionPoolAdapter addWriteConnectionPool() {
        if (this.writeConnectionPool == null) {
            this.writeConnectionPool = new WriteConnectionPoolAdapter(this);
            this.config().setWriteConnectionPoolConfig((WriteConnectionPoolConfig)this.writeConnectionPool.getModel());
        }
        return this.writeConnectionPool;
    }

    ConnectionPoolAdapter addConnectionPoolNamed(String name) {
        ConnectionPoolAdapter namedPool = new ConnectionPoolAdapter((SCAdapter)this, name);
        return this.addPool(namedPool);
    }

    ConnectionPoolAdapter removeConnectionPoolNamed(String name) {
        ConnectionPoolAdapter pool = this.poolNamed(name);
        if (pool != null) {
            if (pool == this.readConnectionPool || pool == this.sequenceConnectionPool) {
                throw new UnsupportedOperationException("Read or Sequence pool cannot be removed.");
            }
            if (pool == this.writeConnectionPool) {
                this.removeWriteConnectionPool();
            } else {
                this.removePool(pool);
            }
        }
        return pool;
    }

    ConnectionPoolAdapter removeWriteConnectionPool() {
        WriteConnectionPoolAdapter writePool = this.writeConnectionPool;
        this.config().setWriteConnectionPoolConfig(null);
        this.writeConnectionPool = null;
        return writePool;
    }

    ConnectionPoolAdapter removeReadConnectionPool() {
        ReadConnectionPoolAdapter readPool = this.readConnectionPool;
        this.config().setReadConnectionPoolConfig(null);
        this.readConnectionPool = null;
        return readPool;
    }

    ConnectionPoolAdapter removeSequenceConnectionPool() {
        ConnectionPoolAdapter sequencePool = this.sequenceConnectionPool;
        this.config().setSequenceConnectionPoolConfig(null);
        this.sequenceConnectionPool = null;
        return sequencePool;
    }

    private ConnectionPoolAdapter addPool(ConnectionPoolAdapter poolAdapter) {
        this.getConnectionPoolConfigs().add(poolAdapter.getModel());
        this.getPools().add(poolAdapter);
        return poolAdapter;
    }

    private void removePool(ConnectionPoolAdapter poolAdapter) {
        this.getConnectionPoolConfigs().remove(poolAdapter.getModel());
        this.getPools().remove(poolAdapter);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setConfigRequired(true);
        this.pools = new Vector();
    }

    @Override
    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
    }

    @Override
    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        if (!this.platformIsXml()) {
            this.readConnectionPool = (ReadConnectionPoolAdapter)this.adapt(this.config().getReadConnectionPoolConfig());
            this.writeConnectionPool = (WriteConnectionPoolAdapter)this.adapt(this.config().getWriteConnectionPoolConfig());
            this.sequenceConnectionPool = (ConnectionPoolAdapter)this.adapt(this.config().getSequenceConnectionPoolConfig());
            this.pools.addAll(this.adaptAll(this.getConnectionPoolConfigs()));
        }
    }

    public boolean platformIsRdbms() {
        return ((SessionAdapter)this.getParent()).platformIsRdbms();
    }

    public boolean platformIsEis() {
        return ((SessionAdapter)this.getParent()).platformIsEis();
    }

    public boolean platformIsXml() {
        return ((SessionAdapter)this.getParent()).platformIsXml();
    }

    private Collection getPools() {
        return this.pools;
    }

    Collection<String> getPoolNames() {
        return CollectionTools.collection((Iterator)new TransformationIterator(this.pools()){

            protected Object transform(Object next) {
                return ((ConnectionPoolAdapter)next).getName();
            }
        });
    }

    Iterator pools() {
        return new CloneIterator(this.pools);
    }

    int poolsSize() {
        return this.pools.size();
    }

    private Collection getConnectionPoolConfigs() {
        return this.config().getConnectionPoolConfigs();
    }

    private ReadConnectionPoolConfig getReadConnectionPoolConfig() {
        return this.config().getReadConnectionPoolConfig();
    }

    ReadConnectionPoolAdapter getReadConnectionPool() {
        return this.readConnectionPool;
    }

    private ConnectionPoolConfig getWriteConnectionPoolConfig() {
        return this.config().getWriteConnectionPoolConfig();
    }

    ConnectionPoolAdapter getWriteConnectionPool() {
        return this.writeConnectionPool;
    }

    private ConnectionPoolConfig getSequenceConnectionPoolConfig() {
        return this.config().getSequenceConnectionPoolConfig();
    }

    ConnectionPoolAdapter getSequenceConnectionPool() {
        return this.sequenceConnectionPool;
    }

    ConnectionPoolAdapter poolNamed(String name) {
        Iterator i = this.pools();
        while (i.hasNext()) {
            ConnectionPoolAdapter pool = (ConnectionPoolAdapter)i.next();
            if (!name.equals(pool.getName())) continue;
            return pool;
        }
        return null;
    }

    private final PoolsConfig config() {
        return (PoolsConfig)this.getModel();
    }
}

