/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool;

import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;

public class DeletePoolAction
extends AbstractEnablableFrameworkAction {
    public DeletePoolAction(WorkbenchContext context) {
        super(context);
    }

    protected void initialize() {
        super.initialize();
        this.initializeText("DELETE_CONNECTION_POOL");
        this.initializeMnemonic("DELETE_CONNECTION_POOL");
        this.initializeIcon("DELETE");
        this.initializeToolTipText("DELETE_CONNECTION_POOL.TOOL_TIP");
    }

    protected void execute(ApplicationNode selectedNode) {
        ConnectionPoolAdapter pool = (ConnectionPoolAdapter)selectedNode.getValue();
        String name = pool.getName();
        if (this.confirmDeletion(name)) {
            ServerSessionAdapter session = (ServerSessionAdapter)selectedNode.getParent().getValue();
            if (pool.isWriteConnectionPool()) {
                session.removeWriteConnectionPool();
            } else if (pool.isReadConnectionPool()) {
                session.removeReadConnectionPool();
            } else if (pool.isSequenceConnectionPool()) {
                session.removeSequenceConnectionPool();
            } else {
                session.removeConnectionPoolNamed(name);
            }
        }
        this.navigatorSelectionModel().setSelectedNode((ApplicationNode)selectedNode.getParent());
    }

    private boolean confirmDeletion(String name) {
        int option = JOptionPane.showConfirmDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("DELETE_CONNECTION_POOL_WARNING", name), this.resourceRepository().getString("DELETE_CONNECTION_POOL_WARNING_TITLE"), 0, 2);
        return option == 0;
    }

    protected boolean shouldBeEnabled(ApplicationNode selectedNode) {
        return true;
    }
}

