/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.login.RdbmsPoolLoginPane;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;

public class RdbmsPoolLoginPropertiesPage
extends ScrollablePropertiesPage {
    public RdbmsPoolLoginPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
        this.addHelpTopicId(this, "connectionPool.login.database");
    }

    private ButtonModel buildExternalConnectionPoolingCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildExternalConnectionPoolingHolder());
    }

    private PropertyValueModel buildExternalConnectionPoolingHolder() {
        return new PropertyAspectAdapter(this.buildLoginHolder(), "externalConnectionPooling"){

            protected Object getValueFromSubject() {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                return adapter.usesExternalConnectionPooling();
            }

            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                adapter.setExternalConnectionPooling((Boolean)value);
            }
        };
    }

    private ButtonModel buildExternalTransactionControllerCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildExternalTransactionControllerHolder());
    }

    private PropertyValueModel buildExternalTransactionControllerHolder() {
        return new PropertyAspectAdapter(this.buildLoginHolder(), "externalTransactionController"){

            protected Boolean getValueFromSubject() {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                return adapter.usesExternalTransactionController();
            }

            protected void setValueOnSubject(Object value) {
                DatabaseLoginAdapter adapter = (DatabaseLoginAdapter)this.subject;
                adapter.setUsesExternalTransactionController((Boolean)value);
            }
        };
    }

    protected PropertyValueModel buildLoginHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "loginConfig"){

            protected Object getValueFromSubject() {
                ConnectionPoolAdapter pool = (ConnectionPoolAdapter)this.subject;
                return pool.getLogin();
            }
        };
    }

    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel container = new JPanel(new GridBagLayout());
        container.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        RdbmsPoolLoginPane loginPane = new RdbmsPoolLoginPane(this.buildLoginHolder(), this.getWorkbenchContextHolder());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)loginPane, constraints);
        JCheckBox externalConnectionPoolingCheckBox = this.buildCheckBox("RDBMS_POOL_LOGIN_PANE_EXTERNAL_CONNECTION_POOLING_CHECKBOX", this.buildExternalConnectionPoolingCheckBoxModel());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        container.add((Component)externalConnectionPoolingCheckBox, constraints);
        JCheckBox externalTransactionControllerCheckBox = this.buildCheckBox("RDBMS_POOL_LOGIN_PANE_EXTERNAL_TRANSACTION_CONTROLLER_CHECKBOX", this.buildExternalTransactionControllerCheckBoxModel());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)externalTransactionControllerCheckBox, constraints);
        return container;
    }
}

