/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DefaultSessionLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.JavaLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NoLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.LoggingOptionsPane;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class SessionLoggingPropertiesPage
extends ScrollablePropertiesPage {
    private PseudoLogginOptionsModel pseudoModel;
    private static final Object LOGGING_TYPE_JAVA_CHOICE = JavaLogAdapter.class;
    private static final Object LOGGING_TYPE_NO_LOGGING_CHOICE = NoLogAdapter.class;
    private static final Object LOGGING_TYPE_SERVER_CHOICE = ServerLogAdapter.class;
    private static final Object LOGGING_TYPE_STANDARD_CHOICE = DefaultSessionLogAdapter.class;

    public SessionLoggingPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    private PropertyValueModel buildLogAdapterHolder() {
        return new PropertyAspectAdapter("logOptions", (Model)this.pseudoModel){

            protected Object getValueFromSubject() {
                PseudoLogginOptionsModel model = (PseudoLogginOptionsModel)((Object)this.subject);
                return model.getLogOptions();
            }
        };
    }

    private PropertyValueModel buildLoggingOptionsCheckBoxEnablerHolder() {
        return new TransformationPropertyValueModel(this.buildLoggingTypeSelectionHolder()){

            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return value == LOGGING_TYPE_STANDARD_CHOICE || value == LOGGING_TYPE_JAVA_CHOICE;
            }
        };
    }

    private PropertyValueModel buildLoggingOptionsPaneEnablerHolder() {
        return new TransformationPropertyValueModel(this.buildLogAdapterHolder()){

            protected Object transform(Object value) {
                return value != null;
            }
        };
    }

    private PropertyValueModel buildLoggingTypeHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "log"){

            protected Object getValueFromSubject() {
                SessionAdapter session = (SessionAdapter)this.subject;
                return session.getLog();
            }

            protected void setValueOnSubject(Object value) {
                SessionAdapter session = (SessionAdapter)this.subject;
                LogAdapter log = session.getLog();
                if (value == LOGGING_TYPE_JAVA_CHOICE && !(log instanceof JavaLogAdapter)) {
                    session.setJavaLogging();
                } else if (value == LOGGING_TYPE_SERVER_CHOICE && !(log instanceof ServerLogAdapter)) {
                    session.setServerLogging();
                } else if (value == LOGGING_TYPE_STANDARD_CHOICE && !(log instanceof DefaultSessionLogAdapter)) {
                    session.setDefaultLogging();
                }
            }
        };
    }

    private PropertyValueModel buildLoggingTypeSelectionHolder() {
        return new TransformationPropertyValueModel(this.buildLoggingTypeHolder()){

            protected Object transform(Object value) {
                return value != null ? value.getClass() : null;
            }
        };
    }

    private PropertyValueModel buildLogHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "log"){

            protected Object getValueFromSubject() {
                SessionAdapter session = (SessionAdapter)this.subject;
                return session.getLog();
            }
        };
    }

    private ButtonModel buildOptionsCheckBoxModelAdapter() {
        return new CheckBoxModelAdapter(this.buildOptionsHolder());
    }

    private PropertyValueModel buildOptionsHolder() {
        PropertyAspectAdapter adapter = new PropertyAspectAdapter(this.buildLogHolder(), "logOptions"){

            protected Object getValueFromSubject() {
                LogAdapter log = (LogAdapter)((Object)this.subject);
                if (log.optionsIsEnable()) {
                    return Boolean.TRUE;
                }
                return null;
            }

            protected void setValueOnSubject(Object value) {
                LogAdapter log = (LogAdapter)((Object)this.subject);
                if (Boolean.TRUE.equals(value) && !log.optionsIsEnable()) {
                    log.enableOptions();
                } else if (Boolean.FALSE.equals(value) && log.optionsIsEnable()) {
                    log.disableOptions();
                }
            }
        };
        return new TransformationPropertyValueModel(adapter){

            protected Object transform(Object value) {
                return value != null;
            }
        };
    }

    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        PropertyValueModel loggingTypeHolder = this.buildLoggingTypeSelectionHolder();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JRadioButton serverLoggingRadioButton = this.buildRadioButton("DATABASE_SESSION_LOGGING_TYPE_SERVER", new RadioButtonModelAdapter(loggingTypeHolder, LOGGING_TYPE_SERVER_CHOICE));
        this.addHelpTopicId(serverLoggingRadioButton, "session.logging.server");
        JRadioButton javaLoggingRadioButton = this.buildRadioButton("DATABASE_SESSION_LOGGING_TYPE_JAVA", new RadioButtonModelAdapter(loggingTypeHolder, LOGGING_TYPE_JAVA_CHOICE));
        this.addHelpTopicId(javaLoggingRadioButton, "session.logging.java");
        JRadioButton standardLoggingRadioButton = this.buildRadioButton("DATABASE_SESSION_LOGGING_TYPE_STANDARD", new RadioButtonModelAdapter(loggingTypeHolder, LOGGING_TYPE_STANDARD_CHOICE));
        this.addHelpTopicId(standardLoggingRadioButton, "session.logging.standard");
        StandardPane standardPane = new StandardPane(this.buildStandardLogHolder());
        this.addPaneForAlignment(standardPane);
        new ComponentEnabler((ValueModel)this.buildStandardPaneEnableStateHolder(), standardPane.getComponents());
        this.addHelpTopicId(standardPane, "session.logging.standard");
        GroupBox groupBox = new GroupBox(new AbstractButton[]{serverLoggingRadioButton, javaLoggingRadioButton, standardLoggingRadioButton}, (JComponent)standardPane);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)groupBox, constraints);
        JCheckBox optionsCheckBox = this.buildCheckBox("LOGGING_OPTIONS_CHECK_BOX", this.buildOptionsCheckBoxModelAdapter());
        LoggingOptionsPane loggingOptionsPane = new LoggingOptionsPane((ValueModel)this.buildLogAdapterHolder(), this.getApplicationContext());
        groupBox = new GroupBox(optionsCheckBox, (JComponent)loggingOptionsPane);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)groupBox, constraints);
        new ComponentEnabler((ValueModel)this.buildLoggingOptionsCheckBoxEnablerHolder(), optionsCheckBox);
        new ComponentEnabler((ValueModel)this.buildLoggingOptionsPaneEnablerHolder(), loggingOptionsPane.getComponents());
        this.addHelpTopicId(groupBox, "session.logging.options");
        this.addHelpTopicId(this, "session.logging");
        return panel;
    }

    private PropertyChangeListener buildSelectionHolderListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                SessionLoggingPropertiesPage.this.pseudoModel.setParentNode((Node)((AbstractNodeModel)e.getNewValue()));
            }
        };
    }

    private PropertyValueModel buildStandardLogHolder() {
        return new TransformationPropertyValueModel(this.buildLogHolder()){

            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                if (value instanceof DefaultSessionLogAdapter) {
                    return value;
                }
                return null;
            }
        };
    }

    private PropertyValueModel buildStandardPaneEnableStateHolder() {
        return new TransformationPropertyValueModel(this.buildLoggingTypeSelectionHolder()){

            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                return value == LOGGING_TYPE_STANDARD_CHOICE;
            }
        };
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.getSelectionHolder().addPropertyChangeListener("value", this.buildSelectionHolderListener());
        this.pseudoModel = new PseudoLogginOptionsModel();
        this.pseudoModel.setParentNode((Node)((AbstractNodeModel)this.selection()));
    }

    private class StandardPane
    extends AbstractSubjectPanel {
        private StandardPane(PropertyValueModel subjectHolder) {
            super((ValueModel)subjectHolder, SessionLoggingPropertiesPage.this.getApplicationContext());
            this.addHelpTopicId(this, "session.logging.standard");
        }

        private PropertyValueModel buildDestinationSelectionHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "filename"){

                protected Object getValueFromSubject() {
                    DefaultSessionLogAdapter log = (DefaultSessionLogAdapter)((Object)this.subject);
                    String fileName = log.getFileName();
                    return "standard output".equals(fileName);
                }

                protected void setValueOnSubject(Object value) {
                    DefaultSessionLogAdapter log = (DefaultSessionLogAdapter)((Object)this.subject);
                    String currentFileName = log.getFileName();
                    if (Boolean.TRUE.equals(value) && !"standard output".equals(currentFileName)) {
                        log.setFileName("standard output");
                    } else if (Boolean.FALSE.equals(value) && "standard output".equals(currentFileName)) {
                        log.setFileName("");
                    }
                }
            };
        }

        private void buildLocationWidgetsEnabler(JComponent components) {
            new ComponentEnabler((ValueModel)this.buildLocationWidgetsEnablerHolder(), Collections.singleton(components), true);
        }

        private PropertyValueModel buildLocationWidgetsEnablerHolder() {
            return new TransformationPropertyValueModel(this.buildLogFileHolder()){

                protected Object transform(Object value) {
                    if (value == null) {
                        return null;
                    }
                    return !"standard output".equals(value);
                }
            };
        }

        private PropertyValueModel buildLogFileHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "filename"){

                protected Object getValueFromSubject() {
                    DefaultSessionLogAdapter log = (DefaultSessionLogAdapter)((Object)this.subject);
                    String fileName = log.getFileName();
                    if ("standard output".equals(fileName)) {
                        fileName = StandardPane.this.resourceRepository().getString("SESSIONS_LOGGING_PROPERTIES_PAGE_DEFAULT_LOG_FILENAME");
                    }
                    return fileName;
                }

                protected void setValueOnSubject(Object value) {
                    DefaultSessionLogAdapter log = (DefaultSessionLogAdapter)((Object)this.subject);
                    String fileName = (String)value;
                    if (fileName != null) {
                        fileName = fileName.trim();
                    }
                    log.setFileName(fileName);
                    if (!StringTools.stringIsEmpty((String)fileName)) {
                        File fileLocation = new File(fileName);
                        if ((fileLocation = fileLocation.getParentFile()) != null) {
                            StandardPane.this.preferences().get("location", fileLocation.getPath());
                        }
                    }
                }
            };
        }

        private ComboBoxModel buildLogLevelComboAdapter() {
            return new ComboBoxModelAdapter(this.buildLogLevelListHolder(), this.buildLogLevelSelectionHolder());
        }

        private ListValueModel buildLogLevelListHolder() {
            return new SimpleListValueModel(CollectionTools.list((Object[])DefaultSessionLogAdapter.VALID_LOG_LEVEL));
        }

        private PropertyValueModel buildLogLevelSelectionHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "logLevel"){

                protected Object getValueFromSubject() {
                    DefaultSessionLogAdapter log = (DefaultSessionLogAdapter)((Object)this.subject);
                    return log.getLogLevel();
                }

                protected void setValueOnSubject(Object value) {
                    DefaultSessionLogAdapter log = (DefaultSessionLogAdapter)((Object)this.subject);
                    log.setLogLevel((String)value);
                }
            };
        }

        protected void initializeLayout() {
            GridBagConstraints constraints = new GridBagConstraints();
            JComboBox<String> comboBox = new JComboBox<String>(this.buildLogLevelComboAdapter());
            comboBox.setPrototypeDisplayValue("warningmmm");
            JComponent logLevelWidgets = this.buildLabeledComponent("DATABASE_SESSION_LOGGING_LEVEL_COMBO_BOX", comboBox);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)logLevelWidgets, constraints);
            JRadioButton consoleRadioButton = this.buildRadioButton("DATABASE_SESSION_DESTINATION_CONSOLE", new RadioButtonModelAdapter(this.buildDestinationSelectionHolder(), Boolean.TRUE));
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(8, 0, 0, 0);
            this.add((Component)consoleRadioButton, constraints);
            JRadioButton fileRadioButton = this.buildRadioButton("DATABASE_SESSION_DESTINATION_FILE", new RadioButtonModelAdapter(this.buildDestinationSelectionHolder(), Boolean.FALSE));
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)fileRadioButton, constraints);
            CustomizedFileChooserPanel logFileChooser = new CustomizedFileChooserPanel();
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)logFileChooser, constraints);
            this.addPaneForAlignment(logFileChooser);
            this.buildLocationWidgetsEnabler(logFileChooser);
        }

        private class CustomizedFileChooserPanel
        extends FileChooserPanel {
            private CustomizedFileChooserPanel() {
                super(StandardPane.this.getApplicationContext(), StandardPane.this.buildLogFileHolder(), "DATABASE_SESSION_LOG_FILE_LOCATION_FIELD", "SESSION_LOGGING_BROWSE_BUTTON", 0);
            }

            protected File getFileChooserDefaultDirectory() {
                DefaultSessionLogAdapter log = (DefaultSessionLogAdapter)((Object)StandardPane.this.subject());
                String fileName = log.getFileName();
                if (!StringTools.stringIsEmpty((String)fileName)) {
                    File fileLocation = new File(fileName);
                    if (fileLocation.isFile()) {
                        fileLocation = fileLocation.getParentFile();
                    }
                    return fileLocation;
                }
                SessionAdapter session = (SessionAdapter)log.getParent();
                TopLinkSessionsAdapter topLinkSessions = (TopLinkSessionsAdapter)session.getParent();
                File saveDirectory = topLinkSessions.getSaveDirectory();
                if (saveDirectory == null) {
                    saveDirectory = FileTools.userHomeDirectory();
                }
                return new File(this.preferences().get("location", saveDirectory.getPath()));
            }

            public void setEnabled(boolean enabled) {
                DefaultSessionLogAdapter log = (DefaultSessionLogAdapter)((Object)StandardPane.this.subject());
                if (enabled) {
                    enabled = log != null ? (enabled &= !"standard output".equals(log.getFileName())) : false;
                }
                super.setEnabled(enabled);
            }
        }
    }

    private class PseudoLogginOptionsModel
    extends AbstractNodeModel {
        private ChangeNotifier changeNotifier;
        private PropertyChangeListener listener;
        private LogAdapter logOptions;
        private Node parentNode;
        private Node.Validator validator;
        public static final String LOG_OPTIONS_PROPERTY = "logOptions";

        private PseudoLogginOptionsModel() {
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if ("log".equals(e.getPropertyName())) {
                        LogAdapter oldAdapter = (LogAdapter)((Object)e.getOldValue());
                        oldAdapter.removePropertyChangeListener(PseudoLogginOptionsModel.LOG_OPTIONS_PROPERTY, this);
                        LogAdapter newAdapter = (LogAdapter)((Object)e.getNewValue());
                        newAdapter.addPropertyChangeListener(PseudoLogginOptionsModel.LOG_OPTIONS_PROPERTY, this);
                    }
                    PseudoLogginOptionsModel.this.updateLogOptions();
                }
            };
        }

        protected void checkParent(Node parent) {
        }

        private void disengageListeners() {
            SessionAdapter session = (SessionAdapter)this.parentNode;
            session.removePropertyChangeListener("log", this.listener);
            session.getLog().removePropertyChangeListener(LOG_OPTIONS_PROPERTY, this.listener);
        }

        public String displayString() {
            return null;
        }

        private void engageListeners() {
            SessionAdapter session = (SessionAdapter)this.parentNode;
            session.addPropertyChangeListener("log", this.listener);
            session.getLog().addPropertyChangeListener(LOG_OPTIONS_PROPERTY, this.listener);
        }

        public ChangeNotifier getChangeNotifier() {
            return this.changeNotifier;
        }

        public LogAdapter getLogOptions() {
            return this.logOptions;
        }

        public Node.Validator getValidator() {
            return this.validator;
        }

        protected void initialize() {
            super.initialize();
            this.listener = this.buildPropertyChangeListener();
        }

        private void setLogOptions(LogAdapter logOptions) {
            LogAdapter oldLogOptions = this.getLogOptions();
            this.logOptions = logOptions;
            this.firePropertyChanged(LOG_OPTIONS_PROPERTY, (Object)oldLogOptions, (Object)logOptions);
        }

        public void setParentNode(Node parentNode) {
            if (this.parentNode != null) {
                this.disengageListeners();
                this.setLogOptions(null);
                this.validator = null;
                this.changeNotifier = null;
            }
            this.parentNode = parentNode;
            if (parentNode != null) {
                this.validator = parentNode.getValidator();
                this.changeNotifier = parentNode.getChangeNotifier();
                this.engageListeners();
                this.updateLogOptions();
            }
        }

        private void updateLogOptions() {
            SessionAdapter session = (SessionAdapter)this.parentNode;
            LogAdapter log = session.getLog();
            if (!log.optionsIsEnable()) {
                log = null;
            }
            this.setLogOptions(log);
        }
    }
}

