/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.text.Document;
import org.eclipse.persistence.platform.server.CustomServerPlatform;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.scplugin.model.ServerPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.CustomServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.ComponentVisibilityEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class SessionServerPlatformPropertiesPage
extends ScrollablePropertiesPage {
    public SessionServerPlatformPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel container = new JPanel(new GridBagLayout());
        container.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JCheckBox useServerPlatformCheckBox = this.buildCheckBox("SERVER_PLATFORM_CHECK_BOX", this.buildUseServerPlatformButtonModel());
        useServerPlatformCheckBox.addActionListener(this.buildServerPlatformAction());
        ServerPlatformPane subPane = new ServerPlatformPane(this.buildServerPlatformPaneSubjectHolder());
        new ComponentEnabler((ValueModel)this.buildServerPlatformBooleanHolder(), subPane.getComponents());
        GroupBox groupBox = new GroupBox(useServerPlatformCheckBox, (JComponent)subPane);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)groupBox, constraints);
        this.addHelpTopicId(container, "session.serverPlatform");
        return container;
    }

    private ActionListener buildServerPlatformAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String serverClassName;
                SessionAdapter session = (SessionAdapter)SessionServerPlatformPropertiesPage.this.selection();
                boolean checked = ((JCheckBox)e.getSource()).isSelected();
                String noServerPlatformClassName = NullServerPlatformAdapter.instance().getServerClassName();
                noServerPlatformClassName = ClassTools.shortNameForClassNamed((String)noServerPlatformClassName);
                if (!checked) {
                    serverClassName = noServerPlatformClassName;
                } else {
                    serverClassName = SessionServerPlatformPropertiesPage.this.preferences().get("platform.server", "WebLogic_10_Platform");
                    if (noServerPlatformClassName.equals(serverClassName)) {
                        serverClassName = "WebLogic_10_Platform";
                    }
                }
                session.setServerPlatform(new ServerPlatform(serverClassName));
            }
        };
    }

    private PropertyValueModel buildServerPlatformBooleanHolder() {
        return new TransformationPropertyValueModel(this.buildServerPlatformHolder()){

            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                ServerPlatformAdapter serverPlatform = (ServerPlatformAdapter)((Object)value);
                return !serverPlatform.isNull();
            }
        };
    }

    private PropertyValueModel buildServerPlatformHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "serverPlatform"){

            protected Object getValueFromSubject() {
                SessionAdapter session = (SessionAdapter)this.subject;
                return session.getServerPlatform();
            }

            protected void setValueOnSubject(Object value) {
            }
        };
    }

    private PropertyValueModel buildServerPlatformPaneSubjectHolder() {
        return new TransformationPropertyValueModel(this.buildServerPlatformHolder()){

            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                ServerPlatformAdapter serverPlatform = (ServerPlatformAdapter)((Object)value);
                return serverPlatform.isNull() ? null : value;
            }
        };
    }

    private ButtonModel buildUseServerPlatformButtonModel() {
        return new CheckBoxModelAdapter(this.buildUseServerPlatformHolder());
    }

    private PropertyValueModel buildUseServerPlatformHolder() {
        return new TransformationPropertyValueModel(this.buildServerPlatformHolder()){

            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                ServerPlatformAdapter serverPlatform = (ServerPlatformAdapter)((Object)value);
                return !serverPlatform.isNull();
            }
        };
    }

    private class ServerPlatformPane
    extends AbstractSubjectPanel {
        private ServerPlatformPane(PropertyValueModel subjectHolder) {
            super((ValueModel)subjectHolder, SessionServerPlatformPropertiesPage.this.getWorkbenchContextHolder());
        }

        private ComponentVisibilityEnabler buildCustomServerPlatformComponentVisibilityUpdater(Component channelWidget) {
            return new ComponentVisibilityEnabler((ValueModel)this.buildCustomServerPlatformVisibilityHolder(), Collections.singleton(channelWidget));
        }

        private PropertyValueModel buildCustomServerPlatformHolder() {
            return new TransformationPropertyValueModel(SessionServerPlatformPropertiesPage.this.buildServerPlatformHolder()){

                protected Object transform(Object value) {
                    if (value == null) {
                        return null;
                    }
                    ServerPlatformAdapter serverPlatform = (ServerPlatformAdapter)((Object)value);
                    return serverPlatform.isCustom() ? value : null;
                }
            };
        }

        private JComponent buildCustomServerPlatformSubPane() {
            return new CustomServerPlatformSubPane(this.buildCustomServerPlatformHolder());
        }

        private PropertyValueModel buildCustomServerPlatformVisibilityHolder() {
            return new TransformationPropertyValueModel(SessionServerPlatformPropertiesPage.this.buildServerPlatformHolder()){

                protected Object transform(Object value) {
                    if (value == null) {
                        return null;
                    }
                    ServerPlatformAdapter serverPlatform = (ServerPlatformAdapter)((Object)value);
                    return serverPlatform.isCustom();
                }
            };
        }

        private ButtonModel buildEnableExternalTransactionControllerButtonModel() {
            return new CheckBoxModelAdapter(this.buildEnableExternalTransactionControllerHolder());
        }

        private PropertyValueModel buildEnableExternalTransactionControllerHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "enableJTA"){

                protected Object getValueFromSubject() {
                    ServerPlatformAdapter serverPlatform = (ServerPlatformAdapter)((Object)this.subject);
                    return serverPlatform.getEnableJTA();
                }

                protected void setValueOnSubject(Object value) {
                    ServerPlatformAdapter serverPlatform = (ServerPlatformAdapter)((Object)this.subject);
                    serverPlatform.setEnableJTA(Boolean.TRUE.equals(value));
                }
            };
        }

        private ButtonModel buildEnableRuntimeServicesButtonModel() {
            return new CheckBoxModelAdapter(this.buildEnableRuntimeServicesHolder());
        }

        private PropertyValueModel buildEnableRuntimeServicesHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "enableRuntimeServices"){

                protected Object getValueFromSubject() {
                    ServerPlatformAdapter serverPlatform = (ServerPlatformAdapter)((Object)this.subject);
                    return serverPlatform.getEnableRuntimeServices();
                }

                protected void setValueOnSubject(Object value) {
                    ServerPlatformAdapter serverPlatform = (ServerPlatformAdapter)((Object)this.subject);
                    serverPlatform.setEnableRuntimeServices(Boolean.TRUE.equals(value));
                }
            };
        }

        private CollectionValueModel buildServerPlatformCollectionHolder() {
            return new SimpleCollectionValueModel(this.buildServerPlatformNames());
        }

        private ComboBoxModel buildServerPlatformComboBoxModel() {
            return new ComboBoxModelAdapter(this.buildServerPlatformCollectionHolder(), this.buildServerPlatformSelectionHolder());
        }

        private Collection buildServerPlatformNames() {
            SortedSet servers = CollectionTools.sortedSet((Iterator)ServerPlatformManager.instance().platformShortNames());
            String serverClassName = NullServerPlatformAdapter.instance().getServerClassName();
            servers.remove(ClassTools.shortNameForClassNamed((String)serverClassName));
            return servers;
        }

        private ListCellRenderer buildServerPlatformRenderer() {
            return new SimpleListCellRenderer(){

                protected String buildText(Object value) {
                    if (value == null) {
                        return "";
                    }
                    return ServerPlatformPane.this.resourceRepository().getString((String)value);
                }
            };
        }

        private PropertyValueModel buildServerPlatformSelectionHolder() {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter(SessionServerPlatformPropertiesPage.this.getSelectionHolder(), "serverPlatform"){

                protected Object getValueFromSubject() {
                    SessionAdapter session = (SessionAdapter)this.subject;
                    return session.getServerPlatform();
                }

                protected void setValueOnSubject(Object value) {
                    SessionAdapter session = (SessionAdapter)this.subject;
                    ServerPlatformAdapter serverPlatform = session.getServerPlatform();
                    String shortClassName = (String)value;
                    String serverClassName = serverPlatform.isCustom() ? NullServerPlatformAdapter.instance().getServerClassName() : serverPlatform.getServerClassName();
                    if (!(serverClassName = ClassTools.shortNameForClassNamed((String)serverClassName)).equals(shortClassName)) {
                        session.setServerPlatform(new ServerPlatform(shortClassName));
                    }
                }
            };
            return new TransformationPropertyValueModel(adapter){

                protected Object transform(Object value) {
                    if (value == null) {
                        return null;
                    }
                    ServerPlatformAdapter serverPlatform = (ServerPlatformAdapter)((Object)value);
                    String serverClassName = serverPlatform.getServerClassName();
                    if (serverPlatform.isCustom()) {
                        serverClassName = CustomServerPlatform.class.getName();
                    }
                    if (serverPlatform.isNull()) {
                        return null;
                    }
                    return ClassTools.shortNameForClassNamed((String)serverClassName);
                }
            };
        }

        protected void initializeLayout() {
            GridBagConstraints constraints = new GridBagConstraints();
            JComponent serverPlatformComboBox = this.buildLabeledComboBox("SERVER_PLATFORM_COMBO_BOX", this.buildServerPlatformComboBoxModel(), this.buildServerPlatformRenderer());
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)serverPlatformComboBox, constraints);
            JCheckBox enableRuntimeServicesCheckBox = this.buildCheckBox("SERVER_PLATFORM_ENABLE_RUNTIME_SERVICES_CHECK_BOX", this.buildEnableRuntimeServicesButtonModel());
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)enableRuntimeServicesCheckBox, constraints);
            JCheckBox enableExternalTransactionControllerCheckBox = this.buildCheckBox("SERVER_PLATFORM_ENABLE_EXTERNAL_TRANSACTION_CONTROLLER_CHECK_BOX", this.buildEnableExternalTransactionControllerButtonModel());
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)enableExternalTransactionControllerCheckBox, constraints);
            JComponent customServerPlatformSubPane = this.buildCustomServerPlatformSubPane();
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 1.0;
            constraints.fill = 2;
            constraints.anchor = 19;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)customServerPlatformSubPane, constraints);
            this.buildCustomServerPlatformComponentVisibilityUpdater(customServerPlatformSubPane);
        }
    }

    private class CustomServerPlatformSubPane
    extends AbstractSubjectPanel {
        private CustomServerPlatformSubPane(PropertyValueModel subjectHolder) {
            super((ValueModel)subjectHolder, SessionServerPlatformPropertiesPage.this.getWorkbenchContextHolder());
        }

        private ValueModel buildClassRepositoryHolder() {
            return new PropertyAspectAdapter(SessionServerPlatformPropertiesPage.this.getSelectionHolder()){

                protected Object getValueFromSubject() {
                    SCAdapter adapter = (SCAdapter)((Object)this.subject);
                    return adapter.getClassRepository();
                }
            };
        }

        private JButton buildExternalTransactionControllerBrowseButton() {
            return ClassChooserTools.buildBrowseButton(this.getWorkbenchContextHolder(), "SERVER_PLATFORM_CUSTOM_EXTERNAL_TRANSACTION_CONTROLLER_BROWSE_BUTTON", this.buildClassRepositoryHolder(), this.buildExternalTransactionControllerHolder());
        }

        private Document buildExternalTransactionControllerDocument() {
            return new DocumentAdapter(this.buildExternalTransactionControllerHolder());
        }

        private PropertyValueModel buildExternalTransactionControllerHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "externalTransactionControllerClass"){

                protected Object getValueFromSubject() {
                    CustomServerPlatformAdapter customServerPlatform = (CustomServerPlatformAdapter)((Object)this.subject);
                    return customServerPlatform.getExternalTransactionControllerClass();
                }

                protected void setValueOnSubject(Object value) {
                    CustomServerPlatformAdapter customServerPlatform = (CustomServerPlatformAdapter)((Object)this.subject);
                    customServerPlatform.setExternalTransactionControllerClass((String)value);
                }
            };
        }

        private JButton buildServerClassBrowseButton() {
            return ClassChooserTools.buildBrowseButton(this.getWorkbenchContextHolder(), "SERVER_PLATFORM_CUSTOM_SERVER_CLASS_BROWSE_BUTTON", this.buildClassRepositoryHolder(), this.buildServerClassHolder());
        }

        private Document buildServerClassDocument() {
            return new DocumentAdapter(this.buildServerClassHolder());
        }

        private PropertyValueModel buildServerClassHolder() {
            return new PropertyAspectAdapter(this.getSubjectHolder(), "serverClassName"){

                protected Object getValueFromSubject() {
                    CustomServerPlatformAdapter customServerPlatform = (CustomServerPlatformAdapter)((Object)this.subject);
                    return customServerPlatform.getServerClassName();
                }

                protected void setValueOnSubject(Object value) {
                    CustomServerPlatformAdapter customServerPlatform = (CustomServerPlatformAdapter)((Object)this.subject);
                    customServerPlatform.setServerClassName((String)value);
                }
            };
        }

        protected void initializeLayout() {
            GridBagConstraints constraints = new GridBagConstraints();
            JComponent serverPlatformWidgets = this.buildLabeledTextField("SERVER_PLATFORM_CUSTOM_SERVER_CLASS_CHOOSER", this.buildServerClassDocument(), this.buildServerClassBrowseButton());
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)serverPlatformWidgets, constraints);
            JComponent externalTransactionControllerWidgets = this.buildLabeledTextField("SERVER_PLATFORM_CUSTOM_EXTERNAL_TRANSACTION_CONTROLLER_CHOOSER", this.buildExternalTransactionControllerDocument(), this.buildExternalTransactionControllerBrowseButton());
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)externalTransactionControllerWidgets, constraints);
        }
    }
}

