/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.login;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.SequenceType;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

final class NewSequenceDialog
extends NewNameDialog {
    private JCheckBox defaultSequenceCheckBox;
    private PropertyValueModel sequenceTypeHolder;
    private NewNameDialog.Builder builder;

    private NewSequenceDialog(WorkbenchContext workbenchContext, NewNameDialog.Builder builder) {
        super(workbenchContext, builder);
        this.builder = builder;
    }

    public static Insets groupBoxMargin() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder("m");
        Insets offset = titledBorder.getBorderInsets(new JPanel());
        offset.left += 5;
        offset.right += 5;
        offset.bottom += 5;
        return offset;
    }

    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel container = new JPanel(new GridBagLayout());
        JLabel descriptionPanel = new JLabel(this.resourceRepository().getString("NEW_SEQUENCE_DIALOG_DESCRIPTION"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)descriptionPanel, constraints);
        JComponent newNameWidget = this.buildNewNameWidgets();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)newNameWidget, constraints);
        Component customPane = this.buildCustomPane();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add(customPane, constraints);
        return container;
    }

    protected JComponent buildNewNameWidgets() {
        Document document = this.buildDocumentWithStateObject();
        document.addDocumentListener(this.buildDocumentListener());
        this.textField = new JTextField(20);
        JComponent component = this.buildLabeledTextField("NEW_SEQUENCE_DIALOG_NAME_LABEL", document, this.textField);
        component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return component;
    }

    protected void editName() {
        String text = this.textField.getText();
        if (this.builder.emptyNameIsIllegal() && text.length() == 0) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.EMPTY_VALUE");
            return;
        }
        boolean nameIsSameAsOriginal = this.namesMatch(text, this.builder.getOriginalName());
        if (this.builder.originalNameIsIllegal() && nameIsSameAsOriginal) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.ORIGINAL_VALUE");
            return;
        }
        if (this.nameIsAlreadyTaken(text, nameIsSameAsOriginal)) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.DUPLICATE_VALUE");
            return;
        }
        if (this.nameIsIllegal(text)) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.ILLEGAL_VALUE");
            return;
        }
        this.clearErrorMessage();
    }

    protected Component buildCustomPane() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel container = new JPanel(new GridBagLayout());
        Insets groupBoxMargin = NewSequenceDialog.groupBoxMargin();
        this.sequenceTypeHolder = this.buildSequenceTypeHolder();
        this.defaultSequenceCheckBox = SwingComponentFactory.buildCheckBox("NEW_SEQUENCE_DIALOG_DEFAULT_SEQUENCE_CHECK_BOX", this.buildDefaultSequenceCheckBoxModel(), this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, groupBoxMargin.left, 0, groupBoxMargin.right);
        container.add((Component)this.defaultSequenceCheckBox, constraints);
        JPanel sequenceTypeContainer = new JPanel(new GridBagLayout());
        sequenceTypeContainer.setBorder(SwingComponentFactory.buildPaneTitledBorder("NEW_SEQUENCE_DIALOG_SEQUENCE_TYPE_GROUP_BOX", this.resourceRepository()));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 0, 0, 0);
        container.add((Component)sequenceTypeContainer, constraints);
        JRadioButton defaultRadioButton = SwingComponentFactory.buildRadioButton("NEW_SEQUENCE_DIALOG_DEFAULT_RADIO_BUTTON", this.buildDefaultRadioButtonModel(this.sequenceTypeHolder), this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 20);
        sequenceTypeContainer.add((Component)defaultRadioButton, constraints);
        JRadioButton nativeRadioButton = SwingComponentFactory.buildRadioButton("NEW_SEQUENCE_DIALOG_NATIVE_RADIO_BUTTON", this.buildNativeRadioButtonModel(this.sequenceTypeHolder), this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 20);
        sequenceTypeContainer.add((Component)nativeRadioButton, constraints);
        JRadioButton tableRadioButton = SwingComponentFactory.buildRadioButton("NEW_SEQUENCE_DIALOG_TABLE_RADIO_BUTTON", this.buildTableRadioButtonModel(this.sequenceTypeHolder), this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 20);
        sequenceTypeContainer.add((Component)tableRadioButton, constraints);
        JRadioButton unaryTableRadioButton = SwingComponentFactory.buildRadioButton("NEW_SEQUENCE_DIALOG_UNARY_TABLE_RADIO_BUTTON", this.buildUnaryTableRadioButtonModel(this.sequenceTypeHolder), this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 20);
        sequenceTypeContainer.add((Component)unaryTableRadioButton, constraints);
        return container;
    }

    private ButtonModel buildDefaultRadioButtonModel(PropertyValueModel sequenceTypeHolder) {
        return new RadioButtonModelAdapter(sequenceTypeHolder, (Object)SequenceType.DEFAULT);
    }

    private ButtonModel buildDefaultSequenceCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildDefaultSequenceHolder());
    }

    private PropertyValueModel buildDefaultSequenceHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "defaultSequence"){

            protected Object getValueFromSubject() {
                SequenceStateObject subject = (SequenceStateObject)((Object)this.subject);
                return subject.isDefaultSequence();
            }

            protected void setValueOnSubject(Object value) {
                SequenceStateObject subject = (SequenceStateObject)((Object)this.subject);
                subject.setDefaultSequence((Boolean)value);
            }
        };
    }

    private ButtonModel buildNativeRadioButtonModel(PropertyValueModel sequenceTypeHolder) {
        return new RadioButtonModelAdapter(sequenceTypeHolder, (Object)SequenceType.NATIVE);
    }

    private PropertyValueModel buildSequenceTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "sequenceType"){

            protected Object getValueFromSubject() {
                SequenceStateObject stateObject = (SequenceStateObject)((Object)this.subject);
                return stateObject.getSequenceType();
            }

            protected void setValueOnSubject(Object value) {
                SequenceStateObject stateObject = (SequenceStateObject)((Object)this.subject);
                stateObject.setSequenceType((SequenceType)((Object)value));
            }
        };
    }

    private ButtonModel buildTableRadioButtonModel(PropertyValueModel sequenceTypeHolder) {
        return new RadioButtonModelAdapter(sequenceTypeHolder, (Object)SequenceType.TABLE);
    }

    private ButtonModel buildUnaryTableRadioButtonModel(PropertyValueModel sequenceTypeHolder) {
        return new RadioButtonModelAdapter(sequenceTypeHolder, (Object)SequenceType.UNARY_TABLE);
    }

    private ButtonModel buildXMLFileRadioButtonModel(PropertyValueModel sequenceTypeHolder) {
        return new RadioButtonModelAdapter(sequenceTypeHolder, (Object)SequenceType.XML_FILE);
    }

    protected String helpTopicId() {
        return "dialog.newSequence";
    }

    protected void initialize() {
        super.initialize();
        this.setResizable(false);
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.getOKAction().setEnabled(false);
    }

    protected NewNameDialog.StateObject buildStateObject() {
        return new SequenceStateObject(this.getBuilder());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SequenceStateObject
    extends NewNameDialog.StateObject {
        private boolean defaultSequence;
        private SequenceType sequenceType;
        static final String DEFAULT_SEQUENCE_PROPERTY = "defaultSequence";
        static final String SEQUENCE_TYPE_PROPERTY = "sequenceType";

        SequenceStateObject(NewNameDialog.Builder builder) {
            super(builder);
        }

        @Override
        protected void editName(List<Problem> currentProblems) {
            if (!this.defaultSequence) {
                super.editName(currentProblems);
            }
        }

        SequenceType getSequenceType() {
            return this.sequenceType;
        }

        protected void initialize() {
            super.initialize();
            this.sequenceType = SequenceType.DEFAULT;
        }

        boolean isDefaultSequence() {
            return this.defaultSequence;
        }

        void setDefaultSequence(boolean defaultSequence) {
            boolean oldDefaultSequence = this.defaultSequence;
            this.defaultSequence = defaultSequence;
            this.firePropertyChanged(DEFAULT_SEQUENCE_PROPERTY, oldDefaultSequence, defaultSequence);
        }

        void setSequenceType(SequenceType sequenceType) {
            SequenceType oldSequenceType = this.sequenceType;
            this.sequenceType = sequenceType;
            this.firePropertyChanged(SEQUENCE_TYPE_PROPERTY, (Object)oldSequenceType, (Object)sequenceType);
        }
    }

    static final class NewSequenceBuilder
    extends NewNameDialog.Builder {
        NewSequenceBuilder(ResourceRepository resourceRepository) {
            this.setTitle(resourceRepository.getString("NEW_SEQUENCE_DIALOG_TITLE"));
            this.setTextFieldDescription(resourceRepository.getString("NEW_SEQUENCE_DIALOG_DESCRIPTION"));
        }

        public NewSequenceDialog buildDialog(WorkbenchContext context) {
            return (NewSequenceDialog)super.buildDialog(context);
        }

        protected NewSequenceDialog buildDialog(WorkbenchContext workbenchContext, NewNameDialog.Builder builder) {
            return new NewSequenceDialog(workbenchContext, builder);
        }
    }
}

