/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class ComponentEnabler {
    private PropertyChangeListener booleanChangeListener;
    ValueModel booleanHolder;
    private Collection components;
    private boolean defaultValue;

    private ComponentEnabler() {
        this.initialize();
    }

    public ComponentEnabler(ValueModel booleanHolder, Component component) {
        this(booleanHolder, component, false);
    }

    public ComponentEnabler(ValueModel booleanHolder, Component component, boolean defaultValue) {
        this(booleanHolder, new Component[]{component}, false);
    }

    public ComponentEnabler(ValueModel booleanHolder, Collection components) {
        this(booleanHolder, components, false);
    }

    public ComponentEnabler(ValueModel booleanHolder, Collection components, boolean defaultValue) {
        this();
        this.initialize(booleanHolder, components, defaultValue);
    }

    public ComponentEnabler(ValueModel booleanHolder, Component[] components) {
        this(booleanHolder, CollectionTools.collection((Object[])components), false);
    }

    public ComponentEnabler(ValueModel booleanHolder, Component[] components, boolean defaultValue) {
        this();
        this.initialize(booleanHolder, CollectionTools.collection((Object[])components), defaultValue);
    }

    public ComponentEnabler(ValueModel booleanHolder, Iterator components) {
        this(booleanHolder, CollectionTools.collection((Iterator)components), false);
    }

    public ComponentEnabler(ValueModel booleanHolder, Iterator components, boolean defaultValue) {
        this();
        this.initialize(booleanHolder, CollectionTools.collection((Iterator)components), defaultValue);
    }

    protected boolean booleanValue(Boolean value) {
        return value == null ? this.defaultValue : value;
    }

    protected PropertyChangeListener buildBooleanChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ComponentEnabler.this.updateEnableState(ComponentEnabler.this.booleanValue((Boolean)ComponentEnabler.this.booleanHolder.getValue()));
            }

            public String toString() {
                return "boolean change listener";
            }
        };
    }

    protected Iterator components() {
        return this.components.iterator();
    }

    protected void initialize() {
        this.booleanChangeListener = this.buildBooleanChangeListener();
    }

    protected void initialize(ValueModel booleanVM, Collection comps, boolean defaultVal) {
        if (booleanVM == null || comps == null) {
            throw new NullPointerException();
        }
        this.components = comps;
        this.defaultValue = defaultVal;
        this.booleanHolder = booleanVM;
        booleanVM.addPropertyChangeListener("value", this.booleanChangeListener);
        this.updateEnableState(this.booleanValue((Boolean)booleanVM.getValue()));
    }

    protected void updateEnableState(boolean enabled) {
        Iterator iter = this.components();
        while (iter.hasNext()) {
            ((Component)iter.next()).setEnabled(enabled);
        }
    }
}

