/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.Transformer;

public class SwitcherPanel
extends JPanel {
    private PropertyValueModel valueHolder;
    private Transformer transformer;
    private PropertyChangeListener listener;

    private SwitcherPanel() {
        super(new BorderLayout());
        this.initialize();
    }

    public SwitcherPanel(PropertyValueModel valueHolder, Transformer transformer) {
        this();
        this.initialize(valueHolder, transformer);
    }

    public SwitcherPanel(PropertyValueModel componentHolder) {
        this(componentHolder, Transformer.NULL_INSTANCE);
    }

    protected void initialize() {
        this.listener = this.buildListener();
    }

    protected PropertyChangeListener buildListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                SwitcherPanel.this.valueChanged(e.getNewValue());
            }

            public String toString() {
                return "value listener";
            }
        };
    }

    protected void initialize(PropertyValueModel pvm, Transformer t) {
        if (pvm == null) {
            throw new NullPointerException();
        }
        this.valueHolder = pvm;
        this.valueHolder.addPropertyChangeListener("value", this.listener);
        this.transformer = t;
        this.valueChanged(pvm.getValue());
    }

    protected void valueChanged(Object value) {
        Component oldComponent = null;
        Component newComponent = (Component)this.transformer.transform(value);
        if (this.getComponentCount() > 0) {
            oldComponent = this.getComponent(0);
            if (oldComponent == newComponent) {
                return;
            }
            this.remove(0);
        }
        if (oldComponent == null && newComponent == null) {
            return;
        }
        if (newComponent != null) {
            this.add(newComponent, "Center");
        }
        if (this.isShowing()) {
            this.revalidate();
            this.repaint();
        }
    }
}

