/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

public class BufferedPropertyValueModel
extends PropertyValueModelWrapper {
    protected Object bufferedValue;
    protected boolean accepting;
    protected ValueModel triggerHolder;
    protected PropertyChangeListener triggerChangeListener;
    protected static final Object UNASSIGNED = new Object();

    public BufferedPropertyValueModel(PropertyValueModel valueHolder, ValueModel triggerHolder) {
        super(valueHolder);
        this.initializeTriggerHolder(triggerHolder);
    }

    protected void initialize() {
        super.initialize();
        this.bufferedValue = UNASSIGNED;
        this.accepting = false;
        this.triggerChangeListener = this.buildTriggerChangeListener();
    }

    protected PropertyChangeListener buildTriggerChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                BufferedPropertyValueModel.this.triggerChanged(e);
            }

            public String toString() {
                return "trigger change listener";
            }
        };
    }

    protected void initializeTriggerHolder(ValueModel triggerVM) {
        if (triggerVM == null) {
            throw new NullPointerException();
        }
        this.triggerHolder = triggerVM;
    }

    public Object getValue() {
        return this.bufferedValue == UNASSIGNED ? this.valueHolder.getValue() : this.bufferedValue;
    }

    public void setValue(Object value) {
        Object old = this.getValue();
        this.bufferedValue = value;
        this.firePropertyChanged("value", old, this.bufferedValue);
    }

    protected void engageValueHolder() {
        super.engageValueHolder();
        this.triggerHolder.addPropertyChangeListener("value", this.triggerChangeListener);
    }

    protected void disengageValueHolder() {
        this.triggerHolder.removePropertyChangeListener("value", this.triggerChangeListener);
        super.disengageValueHolder();
    }

    protected void valueChanged(PropertyChangeEvent e) {
        if (this.accepting) {
            return;
        }
        if (this.bufferedValue == UNASSIGNED) {
            this.firePropertyChanged(e.getPropertyName(), e.getOldValue(), e.getNewValue());
        } else {
            this.handleChangeConflict(e);
        }
    }

    protected void handleChangeConflict(PropertyChangeEvent e) {
    }

    protected void triggerChanged(PropertyChangeEvent e) {
        if (this.bufferedValue == UNASSIGNED) {
            return;
        }
        if (((Boolean)e.getNewValue()).booleanValue()) {
            this.accepting = true;
            this.valueHolder.setValue(this.bufferedValue);
            this.bufferedValue = UNASSIGNED;
            this.accepting = false;
        } else {
            Object old = this.bufferedValue;
            this.bufferedValue = UNASSIGNED;
            this.firePropertyChanged("value", old, this.valueHolder.getValue());
        }
    }

    public void toString(StringBuffer sb) {
        sb.append(this.getValue());
    }

    public boolean isBuffering() {
        return this.bufferedValue != UNASSIGNED;
    }

    public static class Trigger
    extends SimplePropertyValueModel {
        public Object getValue() {
            if (this.value == null) {
                throw new IllegalStateException("The method Trigger.getValue() may only be called during change notification.");
            }
            return this.value;
        }

        public void setValue(Object value) {
            super.setValue(value);
            this.value = null;
        }

        public void setValue(boolean value) {
            this.setValue((Object)value);
        }

        public boolean booleanValue() {
            return (Boolean)this.getValue();
        }

        public void accept() {
            this.setValue(true);
        }

        public boolean isAccepted() {
            return this.booleanValue();
        }

        public void reset() {
            this.setValue(false);
        }

        public boolean isReset() {
            return !this.booleanValue();
        }
    }
}

