/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;

public abstract class CollectionValueModelWrapper
extends AbstractModel
implements CollectionValueModel {
    protected CollectionValueModel collectionHolder;
    protected CollectionChangeListener collectionChangeListener;

    protected CollectionValueModelWrapper(CollectionValueModel collectionHolder) {
        this.collectionHolder = collectionHolder;
    }

    protected void initialize() {
        super.initialize();
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                CollectionValueModelWrapper.this.itemsAdded(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                CollectionValueModelWrapper.this.itemsRemoved(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                CollectionValueModelWrapper.this.collectionChanged(e);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    public synchronized void addCollectionChangeListener(CollectionChangeListener listener) {
        if (this.hasNoCollectionChangeListeners("value")) {
            this.engageModel();
        }
        super.addCollectionChangeListener(listener);
    }

    public synchronized void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        if (collectionName == "value" && this.hasNoCollectionChangeListeners("value")) {
            this.engageModel();
        }
        super.addCollectionChangeListener(collectionName, listener);
    }

    public synchronized void removeCollectionChangeListener(CollectionChangeListener listener) {
        super.removeCollectionChangeListener(listener);
        if (this.hasNoCollectionChangeListeners("value")) {
            this.disengageModel();
        }
    }

    public synchronized void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        super.removeCollectionChangeListener(collectionName, listener);
        if (collectionName == "value" && this.hasNoCollectionChangeListeners("value")) {
            this.disengageModel();
        }
    }

    public void addItem(Object item) {
        throw new UnsupportedOperationException();
    }

    public void addItems(Collection items) {
        Iterator stream = items.iterator();
        while (stream.hasNext()) {
            this.addItem(stream.next());
        }
    }

    public void removeItem(Object item) {
        throw new UnsupportedOperationException();
    }

    public void removeItems(Collection items) {
        Iterator stream = items.iterator();
        while (stream.hasNext()) {
            this.removeItem(stream.next());
        }
    }

    protected void engageModel() {
        this.collectionHolder.addCollectionChangeListener("value", this.collectionChangeListener);
    }

    protected void disengageModel() {
        this.collectionHolder.removeCollectionChangeListener("value", this.collectionChangeListener);
    }

    public void toString(StringBuffer sb) {
        sb.append(this.collectionHolder);
    }

    protected abstract void itemsAdded(CollectionChangeEvent var1);

    protected abstract void itemsRemoved(CollectionChangeEvent var1);

    protected abstract void collectionChanged(CollectionChangeEvent var1);
}

