/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DocumentAdapter
implements Document,
Serializable {
    protected Document delegate;
    protected CombinedListener delegateListener;
    protected PropertyValueModel stringHolder;
    protected PropertyChangeListener stringListener;
    protected EventListenerList listenerList = new EventListenerList();

    private DocumentAdapter() {
        this.initialize();
    }

    public DocumentAdapter(PropertyValueModel stringHolder, Document delegate) {
        this();
        if (stringHolder == null || delegate == null) {
            throw new NullPointerException();
        }
        this.stringHolder = stringHolder;
        this.delegate = delegate;
    }

    public DocumentAdapter(PropertyValueModel stringHolder) {
        this(stringHolder, new PlainDocument());
    }

    protected void initialize() {
        this.stringListener = this.buildStringListener();
        this.delegateListener = this.buildDelegateListener();
    }

    protected PropertyChangeListener buildStringListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                DocumentAdapter.this.stringChanged(e);
            }

            public String toString() {
                return "string listener";
            }
        };
    }

    protected CombinedListener buildDelegateListener() {
        return new InternalListener();
    }

    public int getLength() {
        return this.delegate.getLength();
    }

    public void addDocumentListener(DocumentListener listener) {
        if (this.listenerList.getListenerCount(DocumentListener.class) == 0) {
            this.delegate.addDocumentListener(this.delegateListener);
            this.engageStringHolder();
        }
        this.listenerList.add(DocumentListener.class, listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.listenerList.remove(DocumentListener.class, listener);
        if (this.listenerList.getListenerCount(DocumentListener.class) == 0) {
            this.disengageStringHolder();
            this.delegate.removeDocumentListener(this.delegateListener);
        }
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        if (this.listenerList.getListenerCount(UndoableEditListener.class) == 0) {
            this.delegate.addUndoableEditListener(this.delegateListener);
        }
        this.listenerList.add(UndoableEditListener.class, listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.listenerList.remove(UndoableEditListener.class, listener);
        if (this.listenerList.getListenerCount(UndoableEditListener.class) == 0) {
            this.delegate.removeUndoableEditListener(this.delegateListener);
        }
    }

    public Object getProperty(Object key) {
        return this.delegate.getProperty(key);
    }

    public void putProperty(Object key, Object value) {
        this.delegate.putProperty(key, value);
    }

    public void remove(int offset, int len) throws BadLocationException {
        this.delegate.remove(offset, len);
        this.stringHolder.setValue(this.delegate.getText(0, this.delegate.getLength()));
    }

    public void insertString(int offset, String insertedString, AttributeSet a) throws BadLocationException {
        this.delegate.insertString(offset, insertedString, a);
        this.stringHolder.setValue(this.delegate.getText(0, this.delegate.getLength()));
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.delegate.getText(offset, length);
    }

    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        this.delegate.getText(offset, length, txt);
    }

    public Position getStartPosition() {
        return this.delegate.getStartPosition();
    }

    public Position getEndPosition() {
        return this.delegate.getEndPosition();
    }

    public Position createPosition(int offs) throws BadLocationException {
        return this.delegate.createPosition(offs);
    }

    public Element[] getRootElements() {
        return this.delegate.getRootElements();
    }

    public Element getDefaultRootElement() {
        return this.delegate.getDefaultRootElement();
    }

    public void render(Runnable r) {
        this.delegate.render(r);
    }

    public DocumentListener[] getDocumentListeners() {
        return (DocumentListener[])this.listenerList.getListeners(DocumentListener.class);
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        return (UndoableEditListener[])this.listenerList.getListeners(UndoableEditListener.class);
    }

    protected void stringChanged(PropertyChangeEvent e) {
        this.synchronizeDelegate((String)e.getNewValue());
    }

    protected void synchronizeDelegate(String s) {
        try {
            int len = this.delegate.getLength();
            if (!this.delegate.getText(0, len).equals(s)) {
                this.delegate.remove(0, len);
                this.delegate.insertString(0, s, null);
            }
        }
        catch (BadLocationException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    protected void engageStringHolder() {
        this.stringHolder.addPropertyChangeListener("value", this.stringListener);
        this.synchronizeDelegate((String)this.stringHolder.getValue());
    }

    protected void disengageStringHolder() {
        this.stringHolder.removePropertyChangeListener("value", this.stringListener);
    }

    protected void delegateChangedUpdate(DocumentEvent e) {
        InternalDocumentEvent ee = new InternalDocumentEvent(this, e);
        DocumentListener[] listeners = this.getDocumentListeners();
        int i = listeners.length;
        while (i-- > 0) {
            listeners[i].changedUpdate(ee);
        }
    }

    protected void delegateInsertUpdate(DocumentEvent e) {
        InternalDocumentEvent ee = new InternalDocumentEvent(this, e);
        DocumentListener[] listeners = this.getDocumentListeners();
        int i = listeners.length;
        while (i-- > 0) {
            listeners[i].insertUpdate(ee);
        }
    }

    protected void delegateRemoveUpdate(DocumentEvent e) {
        InternalDocumentEvent ee = new InternalDocumentEvent(this, e);
        DocumentListener[] listeners = this.getDocumentListeners();
        int i = listeners.length;
        while (i-- > 0) {
            listeners[i].removeUpdate(ee);
        }
    }

    protected void delegateUndoableEditHappened(UndoableEditEvent e) {
        UndoableEditEvent ee = new UndoableEditEvent(this, e.getEdit());
        UndoableEditListener[] listeners = this.getUndoableEditListeners();
        int i = listeners.length;
        while (i-- > 0) {
            listeners[i].undoableEditHappened(ee);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.stringHolder);
    }

    protected static class InternalDocumentEvent
    extends EventObject
    implements DocumentEvent {
        protected DocumentEvent delegate;

        protected InternalDocumentEvent(Document document, DocumentEvent delegate) {
            super(document);
            this.delegate = delegate;
        }

        public DocumentEvent.ElementChange getChange(Element elem) {
            return this.delegate.getChange(elem);
        }

        public Document getDocument() {
            return (Document)this.source;
        }

        public int getLength() {
            return this.delegate.getLength();
        }

        public int getOffset() {
            return this.delegate.getOffset();
        }

        public DocumentEvent.EventType getType() {
            return this.delegate.getType();
        }
    }

    protected class InternalListener
    implements CombinedListener {
        protected InternalListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            DocumentAdapter.this.delegateChangedUpdate(e);
        }

        public void insertUpdate(DocumentEvent e) {
            DocumentAdapter.this.delegateInsertUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            DocumentAdapter.this.delegateRemoveUpdate(e);
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            DocumentAdapter.this.delegateUndoableEditHappened(e);
        }
    }

    protected static interface CombinedListener
    extends DocumentListener,
    UndoableEditListener {
    }
}

