/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import javax.swing.AbstractListModel;
import javax.swing.event.ListDataListener;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ListModelAdapter
extends AbstractListModel {
    protected ListValueModel listHolder;
    protected int listSize;
    protected ListChangeListener listChangeListener;

    private ListModelAdapter() {
        this.initialize();
    }

    public ListModelAdapter(ListValueModel listHolder) {
        this();
        this.setModel(listHolder);
    }

    public ListModelAdapter(CollectionValueModel collectionHolder) {
        this();
        this.setModel(collectionHolder);
    }

    protected void initialize() {
        this.listSize = 0;
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ListModelAdapter.this.itemsAdded(e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                ListModelAdapter.this.itemsRemoved(e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                ListModelAdapter.this.itemsReplaced(e);
            }

            public void listChanged(ListChangeEvent e) {
                ListModelAdapter.this.listChanged();
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    public int getSize() {
        return this.listHolder.size();
    }

    public Object getElementAt(int index) {
        return this.listHolder.getItem(index);
    }

    public void addListDataListener(ListDataListener l) {
        if (this.hasNoListDataListeners()) {
            this.engageModel();
            this.listSize = this.listHolder.size();
        }
        super.addListDataListener(l);
    }

    public void removeListDataListener(ListDataListener l) {
        super.removeListDataListener(l);
        if (this.hasNoListDataListeners()) {
            this.disengageModel();
            this.listSize = 0;
        }
    }

    public ListValueModel getModel() {
        return this.listHolder;
    }

    public void setModel(ListValueModel listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        boolean hasListeners = this.hasListDataListeners();
        if (hasListeners) {
            this.disengageModel();
        }
        this.listHolder = listHolder;
        if (hasListeners) {
            this.engageModel();
            this.listChanged();
        }
    }

    public void setModel(CollectionValueModel collectionHolder) {
        this.setModel(new CollectionListValueModelAdapter(collectionHolder));
    }

    protected boolean hasNoListDataListeners() {
        return this.getListDataListeners().length == 0;
    }

    protected boolean hasListDataListeners() {
        return !this.hasNoListDataListeners();
    }

    protected void engageModel() {
        this.listHolder.addListChangeListener("value", this.listChangeListener);
    }

    protected void disengageModel() {
        this.listHolder.removeListChangeListener("value", this.listChangeListener);
    }

    protected void itemsAdded(ListChangeEvent e) {
        int start = e.getIndex();
        int end = start + e.size() - 1;
        this.fireIntervalAdded(this, start, end);
        this.listSize += e.size();
    }

    protected void itemsRemoved(ListChangeEvent e) {
        int start = e.getIndex();
        int end = start + e.size() - 1;
        this.fireIntervalRemoved(this, start, end);
        this.listSize -= e.size();
    }

    protected void itemsReplaced(ListChangeEvent e) {
        int start = e.getIndex();
        int end = start + e.size() - 1;
        this.fireContentsChanged(this, start, end);
    }

    protected void listChanged() {
        if (this.listSize != 0) {
            this.fireIntervalRemoved(this, 0, this.listSize - 1);
        }
        this.listSize = this.listHolder.size();
        if (this.listSize != 0) {
            this.fireIntervalAdded(this, 0, this.listSize - 1);
        } else {
            this.fireContentsChanged(this, 0, -1);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.listHolder);
    }
}

