/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.SpinnerListModel;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ListSpinnerModelAdapter
extends SpinnerListModel {
    private Object defaultValue;
    private PropertyValueModel valueHolder;
    private PropertyChangeListener valueChangeListener;

    public ListSpinnerModelAdapter(PropertyValueModel valueHolder) {
        this(valueHolder, valueHolder.getValue());
    }

    public ListSpinnerModelAdapter(PropertyValueModel valueHolder, Object defaultValue) {
        this(valueHolder, new Object[]{defaultValue}, defaultValue);
    }

    public ListSpinnerModelAdapter(PropertyValueModel valueHolder, Object[] values) {
        this(valueHolder, values, values[0]);
    }

    public ListSpinnerModelAdapter(PropertyValueModel valueHolder, Object[] values, Object defaultValue) {
        this(valueHolder, Arrays.asList(values), defaultValue);
    }

    public ListSpinnerModelAdapter(PropertyValueModel valueHolder, List values) {
        this(valueHolder, values, values.get(0));
    }

    public ListSpinnerModelAdapter(PropertyValueModel valueHolder, List values, Object defaultValue) {
        super(values);
        this.valueHolder = valueHolder;
        this.valueChangeListener = this.buildValueChangeListener();
        this.defaultValue = defaultValue;
    }

    private PropertyChangeListener buildValueChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ListSpinnerModelAdapter.this.synchronize(e.getNewValue());
            }

            public String toString() {
                return "value listener";
            }
        };
    }

    public Object getValue() {
        if (this.getChangeListeners().length == 0) {
            super.setValue(this.spinnerValueOf(this.valueHolder.getValue()));
        }
        return super.getValue();
    }

    public void setValue(Object value) {
        super.setValue(value);
        this.valueHolder.setValue(value);
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.getChangeListeners().length == 0) {
            this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
            this.synchronize(this.valueHolder.getValue());
        }
        super.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        super.removeChangeListener(listener);
        if (this.getChangeListeners().length == 0) {
            this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
        }
    }

    protected Object getDefaultValue() {
        return this.defaultValue;
    }

    protected Object spinnerValueOf(Object value) {
        return value == null ? this.getDefaultValue() : value;
    }

    void synchronize(Object value) {
        Object newValue = this.spinnerValueOf(value);
        if (!this.getValue().equals(newValue)) {
            this.setValue(newValue);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.valueHolder);
    }
}

