/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;

public class ArrowIcon
implements Icon,
Accessible {
    private int width;
    private int height;
    private int orientation;
    private Dimension arrowDimension;
    private Color color;
    private boolean opaque;
    private AccessibleContext accessibleContext;
    private String description;

    public ArrowIcon(int orientation) {
        this();
        this.orientation = orientation;
    }

    public ArrowIcon() {
        this(10, 10);
    }

    public ArrowIcon(int width, int height) {
        this(width, height, 3);
    }

    public ArrowIcon(int width, int height, int orientation) {
        this(width, height, orientation, Color.black);
    }

    public ArrowIcon(int width, int height, int orientation, Color color) {
        this.width = width;
        this.height = height;
        this.orientation = orientation;
        this.color = color;
        this.opaque = color != null;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void setIconWidth(int width) {
        if (width != this.width) {
            this.width = width;
            this.arrowDimension = null;
        }
    }

    public int getIconHeight() {
        return this.height;
    }

    public void setIconHeight(int height) {
        if (height != this.height) {
            this.height = height;
            this.arrowDimension = null;
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != this.orientation) {
            this.orientation = orientation;
            this.arrowDimension = null;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleArrowIcon();
        }
        return this.accessibleContext;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void paintIcon(Component component, Graphics g, int x, int y) {
        Color oldColor = g.getColor();
        if (y < 0) {
            y = 0;
        }
        Dimension arrowDim = this.getArrowDimension();
        int deltaX = (this.width - arrowDim.width) / 2;
        int deltaY = (this.height - arrowDim.height) / 2;
        g.translate(x + deltaX, y + deltaY);
        if (this.opaque) {
            if (component.isEnabled()) {
                g.setColor(this.color != null ? this.color : component.getBackground().darker());
            } else {
                Color bgColor = component.getBackground();
                g.translate(1, 1);
                g.setColor(bgColor.brighter());
                this.paintOpaqueTriangle(g, arrowDim.width, arrowDim.height);
                g.translate(-1, -1);
                g.setColor(bgColor.darker());
            }
            this.paintOpaqueTriangle(g, arrowDim.width, arrowDim.height);
        } else {
            this.paintTransparentTriangle(g, arrowDim.width, arrowDim.height, component.getBackground());
        }
        g.translate(-x - deltaX, -y - deltaY);
        g.setColor(oldColor);
    }

    private Dimension getArrowDimension() {
        if (this.arrowDimension == null) {
            this.arrowDimension = this.buildArrowDimension();
        }
        return this.arrowDimension;
    }

    private Dimension buildArrowDimension() {
        int w = 0;
        int h = 0;
        int iconWidth = this.width;
        int iconHeight = this.height;
        int arrowOrientation = this.orientation;
        if (iconWidth == iconHeight) {
            if (arrowOrientation == 3 || arrowOrientation == 7) {
                h = iconHeight;
                if (h % 2 == 0) {
                    --h;
                }
                w = (h + 1) / 2;
            } else {
                w = iconWidth;
                if (w % 2 == 0) {
                    --w;
                }
                h = (w + 1) / 2;
            }
        } else if (iconWidth < iconHeight) {
            w = iconWidth;
            if (arrowOrientation == 1 || arrowOrientation == 5) {
                if (w % 2 == 0) {
                    --w;
                }
                h = (w + 1) / 2;
            } else {
                h = w * 2 - 1;
            }
        } else {
            h = iconHeight;
            if (arrowOrientation == 3 || arrowOrientation == 7) {
                if (h % 2 == 0) {
                    --h;
                }
                w = (h + 1) / 2;
            } else {
                w = h * 2 - 1;
            }
        }
        return new Dimension(w, h);
    }

    private void paintTransparentTriangle(Graphics g, int triangleWidth, int triangleHeight, Color triangleColor) {
        Color brighter = triangleColor.brighter();
        Color darker = triangleColor.darker();
        int arrowOrientation = this.orientation;
        --triangleWidth;
        --triangleHeight;
        if (arrowOrientation == 3) {
            g.setColor(brighter);
            g.drawLine(0, triangleHeight, triangleWidth, triangleHeight / 2);
            g.setColor(darker);
            g.drawLine(0, 0, triangleWidth, triangleHeight / 2);
            g.drawLine(0, 0, 0, triangleHeight);
        } else if (arrowOrientation == 7) {
            g.setColor(brighter);
            g.drawLine(0, triangleHeight / 2, triangleWidth, triangleHeight);
            g.drawLine(triangleWidth, 0, triangleWidth, triangleHeight);
            g.setColor(darker);
            g.drawLine(triangleWidth, 0, 0, triangleHeight / 2);
        } else if (arrowOrientation == 1) {
            g.setColor(darker);
            g.drawLine(0, triangleHeight, triangleWidth / 2, 0);
            g.drawLine(0, triangleHeight, triangleWidth, triangleHeight);
            g.setColor(brighter);
            g.drawLine(triangleWidth / 2, 0, triangleWidth, triangleHeight);
        } else if (arrowOrientation == 5) {
            g.setColor(brighter);
            g.drawLine(triangleWidth / 2, triangleHeight, triangleWidth, 0);
            g.setColor(darker);
            g.drawLine(0, 0, triangleWidth, 0);
            g.drawLine(0, 0, triangleWidth / 2, triangleHeight);
        }
    }

    private void paintOpaqueTriangle(Graphics g, int triangleWidth, int triangleHeight) {
        block5: {
            int arrowOrientation;
            block7: {
                block6: {
                    block4: {
                        arrowOrientation = this.orientation;
                        if (arrowOrientation != 3) break block4;
                        int maxY = triangleHeight - 1;
                        for (int i = 0; i < triangleWidth; ++i) {
                            g.drawLine(i, i, i, maxY - i);
                        }
                        break block5;
                    }
                    if (arrowOrientation != 7) break block6;
                    int maxY = triangleWidth - 1;
                    --triangleHeight;
                    int i = triangleWidth;
                    while (i-- > 0) {
                        int y = maxY - i;
                        g.drawLine(i, y, i, triangleHeight - y);
                    }
                    break block5;
                }
                if (arrowOrientation != 1) break block7;
                int maxX = triangleHeight - 1;
                --triangleWidth;
                int i = triangleHeight;
                while (i-- > 0) {
                    int x = maxX - i;
                    g.drawLine(x, i, triangleWidth - x, i);
                }
                break block5;
            }
            if (arrowOrientation != 5) break block5;
            int maxX = triangleWidth - 1;
            for (int i = 0; i < triangleHeight; ++i) {
                g.drawLine(i, i, maxX - i, i);
            }
        }
    }

    private class AccessibleArrowIcon
    extends AccessibleContext
    implements AccessibleIcon,
    Serializable {
        private AccessibleArrowIcon() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int index) {
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return null;
        }

        public String getAccessibleIconDescription() {
            return ArrowIcon.this.getDescription();
        }

        public void setAccessibleIconDescription(String description) {
            ArrowIcon.this.setDescription(description);
        }

        public int getAccessibleIconHeight() {
            return ArrowIcon.this.getIconHeight();
        }

        public int getAccessibleIconWidth() {
            return ArrowIcon.this.getIconWidth();
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
        }
    }
}

