/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataClass
extends MetadataAnnotatedElement {
    protected boolean m_isLazy;
    protected boolean m_isAccessible;
    protected boolean m_isPrimitive;
    protected boolean m_isJDK;
    protected int m_modifiers;
    protected List<String> m_interfaces;
    protected List<MetadataClass> m_enclosedClasses;
    protected Map<String, MetadataField> m_fields;
    protected Map<String, MetadataMethod> m_methods;
    protected MetadataClass m_superclass;
    protected String m_superclassName;

    public MetadataClass(MetadataFactory factory, String name, boolean isLazy) {
        super(factory);
        this.setName(name);
        this.setType(name);
        this.m_isAccessible = true;
        this.m_isLazy = isLazy;
    }

    public MetadataClass(MetadataFactory factory, String name) {
        this(factory, name, false);
    }

    public MetadataClass(MetadataFactory factory, Class cls) {
        this(factory, cls.getName(), false);
        this.m_isPrimitive = cls.isPrimitive();
    }

    public void addEnclosedClass(MetadataClass enclosedClass) {
        if (this.m_enclosedClasses == null) {
            this.m_enclosedClasses = new ArrayList<MetadataClass>();
        }
        this.m_enclosedClasses.add(enclosedClass);
    }

    public void addField(MetadataField field) {
        if (this.m_fields == null) {
            this.m_fields = new HashMap<String, MetadataField>();
        }
        this.m_fields.put(field.getName(), field);
    }

    public void addInterface(String interfaceName) {
        if (this.m_interfaces == null) {
            this.m_interfaces = new ArrayList<String>();
        }
        this.m_interfaces.add(interfaceName);
    }

    public void addMethod(MetadataMethod method) {
        if (this.m_methods == null) {
            this.m_methods = new HashMap<String, MetadataMethod>();
        }
        this.m_methods.put(method.getName(), method);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Class) {
            if (this.getName() == null) {
                return ((Class)object).getName() == null;
            }
            return this.getName().equals(((Class)object).getName());
        }
        return super.equals(object);
    }

    public boolean extendsClass(Class javaClass) {
        return this.extendsClass(javaClass.getName());
    }

    public boolean extendsClass(String className) {
        if (this.getName() == null) {
            return className == null;
        }
        if (this.getName().equals(className)) {
            return true;
        }
        if (this.getSuperclassName() == null) {
            return false;
        }
        if (this.getSuperclassName().equals(className)) {
            return true;
        }
        return this.getSuperclass().extendsClass(className);
    }

    public boolean extendsInterface(Class javaClass) {
        return this.extendsInterface(javaClass.getName());
    }

    public boolean extendsInterface(String className) {
        if (this.getName() == null) {
            return false;
        }
        if (this.getName().equals(className)) {
            return true;
        }
        if (this.getInterfaces().contains(className)) {
            return true;
        }
        for (String interfaceName : this.getInterfaces()) {
            if (!this.getMetadataClass(interfaceName).extendsInterface(className)) continue;
            return true;
        }
        if (this.getSuperclassName() == null) {
            return false;
        }
        return this.getSuperclass().extendsInterface(className);
    }

    public List<MetadataClass> getEnclosedClasses() {
        if (this.m_enclosedClasses == null) {
            this.m_enclosedClasses = new ArrayList<MetadataClass>();
        }
        return this.m_enclosedClasses;
    }

    public MetadataField getField(String name) {
        return this.getField(name, true);
    }

    public MetadataField getField(String name, boolean checkSuperClass) {
        MetadataField field = this.getFields().get(name);
        if (checkSuperClass && field == null && this.getSuperclassName() != null) {
            return this.getSuperclass().getField(name);
        }
        return field;
    }

    public Map<String, MetadataField> getFields() {
        if (this.m_fields == null) {
            this.m_fields = new HashMap<String, MetadataField>();
            if (this.m_isLazy) {
                this.m_factory.getMetadataClass(this.getName(), false);
            }
        }
        return this.m_fields;
    }

    public List<String> getInterfaces() {
        if (this.m_interfaces == null) {
            this.m_interfaces = new ArrayList<String>();
        }
        return this.m_interfaces;
    }

    protected MetadataMethod getMethod(String name) {
        return this.getMethods().get(name);
    }

    public MetadataMethod getMethod(String name, Class[] arguments) {
        ArrayList<String> argumentNames = new ArrayList<String>(arguments.length);
        for (int index = 0; index < arguments.length; ++index) {
            argumentNames.add(arguments[index].getName());
        }
        return this.getMethod(name, argumentNames);
    }

    public MetadataMethod getMethod(String name, List<String> arguments) {
        return this.getMethod(name, arguments, true);
    }

    public MetadataMethod getMethod(String name, List<String> arguments, boolean checkSuperClass) {
        MetadataMethod method;
        for (method = this.getMethods().get(name); method != null && !((Object)method.getParameters()).equals(arguments); method = method.getNext()) {
        }
        if (checkSuperClass && method == null && this.getSuperclassName() != null) {
            return this.getSuperclass().getMethod(name, arguments);
        }
        return method;
    }

    public MetadataMethod getMethod(String name, String[] arguments) {
        return this.getMethod(name, Arrays.asList(arguments));
    }

    public MetadataMethod getMethodForPropertyName(String propertyName) {
        String leadingChar = String.valueOf(propertyName.charAt(0)).toUpperCase();
        String restOfName = propertyName.substring(1);
        MetadataMethod method = this.getMethod("get".concat(leadingChar).concat(restOfName), new String[0]);
        if (method == null) {
            method = this.getMethod("is".concat(leadingChar).concat(restOfName), new String[0]);
        }
        if (method != null) {
            method.setSetMethod(method.getSetMethod(this));
        }
        return method;
    }

    public Map<String, MetadataMethod> getMethods() {
        if (this.m_methods == null) {
            this.m_methods = new HashMap<String, MetadataMethod>();
            if (this.m_isLazy) {
                this.m_factory.getMetadataClass(this.getName(), false);
            }
        }
        return this.m_methods;
    }

    @Override
    public int getModifiers() {
        return this.m_modifiers;
    }

    public MetadataClass getSuperclass() {
        if (this.m_superclass == null) {
            this.m_superclass = this.getMetadataClass(this.m_superclassName);
        }
        return this.m_superclass;
    }

    public String getSuperclassName() {
        return this.m_superclassName;
    }

    public String getTypeName() {
        if (this.isArray()) {
            return this.getName().replace('.', '/');
        }
        if (this.isPrimitive()) {
            if (this.getName().equals("int")) {
                return "I";
            }
            if (this.getName().equals("long")) {
                return "J";
            }
            if (this.getName().equals("short")) {
                return "S";
            }
            if (this.getName().equals("boolean")) {
                return "Z";
            }
            if (this.getName().equals("float")) {
                return "F";
            }
            if (this.getName().equals("double")) {
                return "D";
            }
            if (this.getName().equals("char")) {
                return "C";
            }
            if (this.getName().equals("byte")) {
                return "B";
            }
        }
        return "L" + this.getName().replace('.', '/') + ";";
    }

    public boolean isAccessible() {
        return this.m_isAccessible;
    }

    public boolean isArray() {
        return this.getName() != null && this.getName().charAt(0) == '[';
    }

    public boolean isCollection() {
        return this.extendsInterface(Collection.class);
    }

    public boolean isEnum() {
        return this.extendsClass(Enum.class);
    }

    public boolean isInterface() {
        return (0x200 & this.m_modifiers) != 0;
    }

    public boolean isJDK() {
        return this.m_isJDK;
    }

    public boolean isList() {
        return this.extendsInterface(List.class);
    }

    public boolean isMap() {
        return this.extendsInterface(Map.class);
    }

    public boolean isObject() {
        return this.getName().equals(Object.class.getName());
    }

    public boolean isPrimitive() {
        return this.m_isPrimitive;
    }

    public boolean isSerializable() {
        if (this.isArray()) {
            return true;
        }
        return this.extendsInterface(Serializable.class);
    }

    public boolean isSerializableInterface() {
        return this.getName().equals(Serializable.class.getName());
    }

    public boolean isSet() {
        return this.extendsInterface(Set.class);
    }

    public boolean isVoid() {
        return this.getName().equals(Void.TYPE.getName()) || this.getName().equals(Void.class.getName());
    }

    public void setIsAccessible(boolean isAccessible) {
        this.m_isAccessible = isAccessible;
    }

    public void setIsJDK(boolean isJDK) {
        this.m_isJDK = isJDK;
    }

    @Override
    public void setModifiers(int modifiers) {
        this.m_modifiers = modifiers;
    }

    public void setSuperclass(MetadataClass superclass) {
        this.m_superclass = superclass;
    }

    public void setSuperclassName(String superclass) {
        this.m_superclassName = superclass;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (!MetadataFactory.ALLOW_JDK && (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("org.eclipse.persistence.internal."))) {
            this.setIsJDK(true);
        }
    }

    public boolean isLazy() {
        return this.m_isLazy;
    }

    public void setIsLazy(boolean isLazy) {
        this.m_isLazy = isLazy;
    }
}

