/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshallerHandler;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRootRecord;
import org.eclipse.persistence.platform.xml.DefaultErrorHandler;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAXUnmarshaller
implements PlatformUnmarshaller {
    private static final String VALIDATING = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private int validationMode = 0;
    private Schema schema;
    private Object[] schemas;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler = new DefaultErrorHandler();
    private SAXParser saxParser;
    private XMLReader xmlReader;
    private XMLUnmarshaller xmlUnmarshaller;
    private XMLParser xmlParser;
    private boolean isResultAlwaysXMLRoot;
    private boolean isWhitespacePreserving;
    private SAXParserFactory saxParserFactory;
    private Map<String, Boolean> parserFeatures;

    public SAXUnmarshaller(XMLUnmarshaller xmlUnmarshaller, Map<String, Boolean> parserFeatures) throws XMLMarshalException {
        this.parserFeatures = parserFeatures;
        try {
            this.xmlUnmarshaller = xmlUnmarshaller;
        }
        catch (Exception e) {
            throw XMLMarshalException.errorInstantiatingSchemaPlatform(e);
        }
    }

    private SAXParserFactory getSAXParserFactory() throws XMLMarshalException {
        if (null == this.saxParserFactory) {
            try {
                this.saxParserFactory = SAXParserFactory.newInstance();
                this.saxParserFactory.setNamespaceAware(true);
                this.saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                try {
                    this.saxParserFactory.setFeature("http://java.sun.com/xml/schema/features/report-ignored-element-content-whitespace", true);
                }
                catch (SAXNotRecognizedException ex) {
                }
                catch (SAXNotSupportedException ex) {
                    // empty catch block
                }
                if (null != this.parserFeatures) {
                    for (Map.Entry<String, Boolean> parserFeature : this.parserFeatures.entrySet()) {
                        try {
                            this.saxParserFactory.setFeature(parserFeature.getKey(), parserFeature.getValue());
                        }
                        catch (SAXNotRecognizedException ex) {
                        }
                        catch (SAXNotSupportedException sAXNotSupportedException) {}
                    }
                }
                return this.saxParserFactory;
            }
            catch (Exception e) {
                throw XMLMarshalException.errorInstantiatingSchemaPlatform(e);
            }
        }
        return this.saxParserFactory;
    }

    private SAXParser getSAXParser() {
        if (null == this.saxParser) {
            try {
                this.saxParser = this.getSAXParserFactory().newSAXParser();
            }
            catch (Exception e) {
                throw XMLMarshalException.errorInstantiatingSchemaPlatform(e);
            }
        }
        return this.saxParser;
    }

    private XMLParser getXMLParser() {
        this.xmlParser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
        this.xmlParser.setNamespaceAware(true);
        if (null != this.errorHandler) {
            this.xmlParser.setErrorHandler(this.errorHandler);
        }
        if (null != this.entityResolver) {
            this.xmlParser.setEntityResolver(this.entityResolver);
        }
        this.xmlParser.setValidationMode(this.validationMode);
        this.xmlParser.setWhitespacePreserving(this.isWhitespacePreserving);
        return this.xmlParser;
    }

    private XMLReader getXMLReader() {
        if (null == this.xmlReader) {
            try {
                this.xmlReader = new XMLReader(this.getSAXParser().getXMLReader());
                if (null != this.errorHandler) {
                    this.xmlReader.setErrorHandler(this.errorHandler);
                }
                if (null != this.entityResolver) {
                    this.xmlReader.setEntityResolver(this.entityResolver);
                }
                this.setValidationMode(this.getValidationMode());
                if (null != this.getSchema()) {
                    this.xmlReader.setFeature(VALIDATING, this.xmlReader.getFeature(VALIDATING));
                }
                return this.xmlReader;
            }
            catch (Exception e) {
                throw XMLMarshalException.errorInstantiatingSchemaPlatform(e);
            }
        }
        return this.xmlReader;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        if (null != this.xmlReader) {
            this.xmlReader.setEntityResolver(entityResolver);
        }
        if (null != this.xmlParser) {
            this.xmlParser.setEntityResolver(entityResolver);
        }
        this.entityResolver = entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        if (null != this.xmlReader) {
            this.xmlReader.setErrorHandler(errorHandler);
        }
        if (null != this.xmlParser) {
            this.xmlParser.setErrorHandler(errorHandler);
        }
        this.errorHandler = errorHandler;
    }

    @Override
    public int getValidationMode() {
        return this.validationMode;
    }

    @Override
    public void setValidationMode(int validationMode) {
        try {
            this.validationMode = validationMode;
            if (null != this.xmlParser) {
                this.xmlParser.setValidationMode(validationMode);
            }
            if (null == this.xmlReader) {
                return;
            }
            switch (validationMode) {
                case 0: {
                    this.xmlReader.setFeature(VALIDATING, false);
                    break;
                }
                case 2: {
                    this.xmlReader.setFeature(VALIDATING, true);
                    break;
                }
                case 3: {
                    try {
                        this.xmlReader.setFeature(VALIDATING, true);
                        this.saxParser.setProperty(SCHEMA_LANGUAGE, XML_SCHEMA);
                        this.saxParser.setProperty(SCHEMA_SOURCE, this.schemas);
                        break;
                    }
                    catch (Exception e) {
                        this.xmlReader.setFeature(VALIDATING, false);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        this.isWhitespacePreserving = isWhitespacePreserving;
        if (null != this.xmlParser) {
            this.xmlParser.setWhitespacePreserving(isWhitespacePreserving);
        }
    }

    @Override
    public void setSchemas(Object[] schemas) {
        this.schemas = schemas;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
        if (null != this.xmlParser) {
            this.xmlParser.setXMLSchema(schema);
        }
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object unmarshal(File file) {
        Object object;
        try {
            try {
                if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
                    Element domElement = this.getXMLParser().parse(file).getDocumentElement();
                    Object object2 = this.unmarshal(domElement);
                    Object var7_8 = null;
                    this.xmlUnmarshaller.getStringBuffer().reset();
                    return object2;
                }
                FileInputStream inputStream = new FileInputStream(file);
                try {
                    object = this.unmarshal(inputStream);
                    Object var5_11 = null;
                }
                catch (Throwable throwable) {
                    Object var5_12 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
            }
            catch (FileNotFoundException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            throw throwable;
        }
        Object var7_9 = null;
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object unmarshal(File file, Class clazz) {
        Object object;
        try {
            try {
                if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
                    Element domElement = this.getXMLParser().parse(file).getDocumentElement();
                    Object object2 = this.unmarshal(domElement, clazz);
                    Object var8_9 = null;
                    this.xmlUnmarshaller.getStringBuffer().reset();
                    return object2;
                }
                FileInputStream inputStream = new FileInputStream(file);
                try {
                    object = this.unmarshal(inputStream, clazz);
                    Object var6_12 = null;
                }
                catch (Throwable throwable) {
                    Object var6_13 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
            }
            catch (FileNotFoundException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            throw throwable;
        }
        Object var8_10 = null;
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(InputStream inputStream) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.getXMLParser().parse(inputStream).getDocumentElement();
            return this.unmarshal(domElement);
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource);
    }

    @Override
    public Object unmarshal(InputStream inputStream, Class clazz) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.getXMLParser().parse(inputStream).getDocumentElement();
            return this.unmarshal(domElement, clazz);
        }
        InputSource inputSource = new InputSource(inputStream);
        return this.unmarshal(inputSource, clazz);
    }

    @Override
    public Object unmarshal(InputSource inputSource) {
        return this.unmarshal(this.getXMLReader(), inputSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object unmarshal(InputSource inputSource, XMLReader xmlReader) {
        try {
            try {
                SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
                saxUnmarshallerHandler.setXMLReader(xmlReader);
                saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                this.setContentHandler(xmlReader, saxUnmarshallerHandler);
                xmlReader.parse(inputSource);
                saxUnmarshallerHandler.resolveReferences();
                Object object = saxUnmarshallerHandler.getObject();
                Object var6_7 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                return object;
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (SAXException e) {
                throw this.convertSAXException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            throw throwable;
        }
    }

    @Override
    public Object unmarshal(InputSource inputSource, Class clazz) {
        return this.unmarshal(this.getXMLReader(), inputSource, clazz);
    }

    public Object unmarshal(InputSource inputSource, Class clazz, XMLReader xmlReader) {
        UnmarshalRecord unmarshalRecord = null;
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        boolean isPrimitiveWrapper = false;
        if (clazz == ClassConstants.OBJECT) {
            try {
                SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
                saxUnmarshallerHandler.setXMLReader(xmlReader);
                saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                saxUnmarshallerHandler.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                this.setContentHandler(xmlReader, saxUnmarshallerHandler);
                xmlReader.parse(inputSource);
                saxUnmarshallerHandler.resolveReferences();
                return saxUnmarshallerHandler.getObject();
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (SAXException e) {
                throw this.convertSAXException(e);
            }
        }
        try {
            session = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
        }
        catch (XMLMarshalException xme) {
            if (xme.getErrorCode() == 25007) {
                isPrimitiveWrapper = this.isPrimitiveWrapper(clazz);
                if (isPrimitiveWrapper) {
                    unmarshalRecord = new XMLRootRecord(clazz);
                    unmarshalRecord.setSession((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0)));
                }
                throw xme;
            }
            throw xme;
        }
        try {
            try {
                unmarshalRecord.setXMLReader(xmlReader);
                unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
                this.setContentHandler(xmlReader, unmarshalRecord);
                xmlReader.setLexicalHandler(unmarshalRecord);
                xmlReader.parse(inputSource);
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (SAXException e) {
                throw this.convertSAXException(e);
            }
            Object var10_14 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            throw throwable;
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    @Override
    public Object unmarshal(Node node) {
        DOMReader reader = new DOMReader(this.xmlUnmarshaller);
        return this.unmarshal(reader, node);
    }

    public Object unmarshal(DOMReader reader, Node node) {
        try {
            SAXUnmarshallerHandler handler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            this.setContentHandler(reader, handler);
            handler.setXMLReader(reader);
            handler.setUnmarshaller(this.xmlUnmarshaller);
            reader.parse(node);
            handler.resolveReferences();
            Object object = handler.getObject();
            Object var6_6 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            return object;
        }
        catch (SAXException e) {
            try {
                throw this.convertSAXException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
    }

    @Override
    public Object unmarshal(Node node, Class clazz) {
        DOMReader reader = new DOMReader(this.xmlUnmarshaller);
        return this.unmarshal(reader, node, clazz);
    }

    public Object unmarshal(DOMReader domReader, Node node, Class clazz) {
        UnmarshalRecord unmarshalRecord = null;
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        boolean isPrimitiveWrapper = false;
        if (clazz == ClassConstants.OBJECT) {
            SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            saxUnmarshallerHandler.setXMLReader(domReader);
            saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
            saxUnmarshallerHandler.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
            this.setContentHandler(domReader, saxUnmarshallerHandler);
            try {
                domReader.parse(node);
            }
            catch (SAXException e) {
                throw this.convertSAXException(e);
            }
            saxUnmarshallerHandler.resolveReferences();
            return saxUnmarshallerHandler.getObject();
        }
        try {
            session = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
        }
        catch (XMLMarshalException xme) {
            if (xme.getErrorCode() == 25007) {
                isPrimitiveWrapper = this.isPrimitiveWrapper(clazz);
                if (isPrimitiveWrapper) {
                    unmarshalRecord = new XMLRootRecord(clazz);
                    unmarshalRecord.setSession((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0)));
                }
                throw xme;
            }
            throw xme;
        }
        try {
            try {
                unmarshalRecord.setXMLReader(domReader);
                unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
                this.setContentHandler(domReader, unmarshalRecord);
                domReader.setLexicalHandler(unmarshalRecord);
                domReader.parse(node);
            }
            catch (SAXException e) {
                throw this.convertSAXException(e);
            }
            Object var11_12 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            throw throwable;
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    @Override
    public Object unmarshal(Reader reader) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.getXMLParser().parse(reader).getDocumentElement();
            return this.unmarshal(domElement);
        }
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource);
    }

    @Override
    public Object unmarshal(Reader reader, Class clazz) {
        if (this.xmlUnmarshaller.getXMLContext().hasDocumentPreservation()) {
            Element domElement = this.getXMLParser().parse(reader).getDocumentElement();
            return this.unmarshal(domElement, clazz);
        }
        InputSource inputSource = new InputSource(reader);
        return this.unmarshal(inputSource, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(Source source) {
        block12: {
            StreamSource streamSource;
            block14: {
                block13: {
                    block11: {
                        block9: {
                            XMLReader xmlReader;
                            SAXSource saxSource;
                            block10: {
                                try {
                                    if (!(source instanceof SAXSource)) break block9;
                                    saxSource = (SAXSource)source;
                                    xmlReader = null;
                                    if (saxSource.getXMLReader() != null) {
                                        xmlReader = saxSource.getXMLReader() instanceof XMLReader ? (XMLReader)saxSource.getXMLReader() : new XMLReader(saxSource.getXMLReader());
                                        this.setValidatorHandler(xmlReader);
                                    }
                                    if (null != xmlReader) break block10;
                                    Object object = this.unmarshal(saxSource.getInputSource());
                                    Object var7_15 = null;
                                    this.xmlUnmarshaller.getStringBuffer().reset();
                                    return object;
                                }
                                catch (Throwable throwable) {
                                    Object var7_22 = null;
                                    this.xmlUnmarshaller.getStringBuffer().reset();
                                    throw throwable;
                                }
                            }
                            Object object = this.unmarshal(saxSource.getInputSource(), xmlReader);
                            Object var7_16 = null;
                            this.xmlUnmarshaller.getStringBuffer().reset();
                            return object;
                        }
                        if (!(source instanceof DOMSource)) break block11;
                        DOMSource domSource = (DOMSource)source;
                        Object xmlReader = this.unmarshal(domSource.getNode());
                        Object var7_17 = null;
                        this.xmlUnmarshaller.getStringBuffer().reset();
                        return xmlReader;
                    }
                    if (!(source instanceof StreamSource)) break block12;
                    streamSource = (StreamSource)source;
                    if (null == streamSource.getReader()) break block13;
                    Object xmlReader = this.unmarshal(streamSource.getReader());
                    Object var7_18 = null;
                    this.xmlUnmarshaller.getStringBuffer().reset();
                    return xmlReader;
                }
                if (null == streamSource.getInputStream()) break block14;
                Object xmlReader = this.unmarshal(streamSource.getInputStream());
                Object var7_19 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                return xmlReader;
            }
            Object xmlReader = this.unmarshal(streamSource.getSystemId());
            Object var7_20 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            return xmlReader;
        }
        XMLUnmarshallerHandler handler = this.xmlUnmarshaller.getUnmarshallerHandler();
        XMLTransformer transformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        SAXResult result = new SAXResult(handler);
        transformer.transform(source, (Result)result);
        Object object = handler.getResult();
        Object var7_21 = null;
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(Source source, Class clazz) {
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            XMLReader xmlReader = null;
            if (saxSource.getXMLReader() != null) {
                xmlReader = saxSource.getXMLReader() instanceof XMLReader ? (XMLReader)saxSource.getXMLReader() : new XMLReader(saxSource.getXMLReader());
                this.setValidatorHandler(xmlReader);
            }
            if (null == saxSource.getXMLReader()) {
                return this.unmarshal(saxSource.getInputSource(), clazz);
            }
            return this.unmarshal(saxSource.getInputSource(), clazz, xmlReader);
        }
        if (source instanceof DOMSource) {
            DOMSource domSource = (DOMSource)source;
            return this.unmarshal(domSource.getNode(), clazz);
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            if (null != streamSource.getReader()) {
                return this.unmarshal(streamSource.getReader(), clazz);
            }
            if (null != streamSource.getInputStream()) {
                return this.unmarshal(streamSource.getInputStream(), clazz);
            }
            return this.unmarshal(streamSource.getSystemId(), clazz);
        }
        DOMResult result = new DOMResult();
        XMLTransformer transformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
        transformer.transform(source, (Result)result);
        return this.unmarshal(result.getNode(), clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object unmarshal(URL url) {
        Object object;
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
        }
        catch (Exception e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        boolean hasThrownException = false;
        try {
            try {
                object = this.unmarshal(inputStream);
                Object var6_7 = null;
            }
            catch (RuntimeException runtimeException) {
                hasThrownException = true;
                throw runtimeException;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                inputStream.close();
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
            catch (IOException e) {
                if (hasThrownException) throw throwable;
                throw XMLMarshalException.unmarshalException(e);
            }
        }
        try {}
        catch (IOException e) {
            if (hasThrownException) return object;
            throw XMLMarshalException.unmarshalException(e);
        }
        inputStream.close();
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    @Override
    public Object unmarshal(URL url, Class clazz) {
        try {
            InputStream inputStream = url.openStream();
            Object result = this.unmarshal(inputStream, clazz);
            inputStream.close();
            Object object = result;
            Object var7_7 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            return object;
        }
        catch (IOException e) {
            try {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object unmarshal(String systemId) {
        try {
            try {
                XMLReader xmlReader = this.getXMLReader();
                SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
                saxUnmarshallerHandler.setXMLReader(xmlReader);
                saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                this.setContentHandler(xmlReader, saxUnmarshallerHandler);
                xmlReader.parse(systemId);
                saxUnmarshallerHandler.resolveReferences();
                Object object = saxUnmarshallerHandler.getObject();
                Object var6_7 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                return object;
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (SAXException e) {
                throw this.convertSAXException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            throw throwable;
        }
    }

    public Object unmarshal(String systemId, Class clazz) {
        UnmarshalRecord unmarshalRecord = null;
        boolean isPrimitiveWrapper = false;
        XMLDescriptor xmlDescriptor = null;
        AbstractSession session = null;
        if (clazz == ClassConstants.OBJECT) {
            SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
            try {
                try {
                    XMLReader xmlReader = this.getXMLReader();
                    saxUnmarshallerHandler.setXMLReader(xmlReader);
                    saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                    saxUnmarshallerHandler.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                    this.setContentHandler(xmlReader, saxUnmarshallerHandler);
                    xmlReader.parse(systemId);
                }
                catch (IOException e) {
                    throw XMLMarshalException.unmarshalException(e);
                }
                catch (SAXException e) {
                    throw this.convertSAXException(e);
                }
                Object var10_15 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                throw throwable;
            }
            saxUnmarshallerHandler.resolveReferences();
            return saxUnmarshallerHandler.getObject();
        }
        try {
            session = this.xmlUnmarshaller.getXMLContext().getReadSession(clazz);
            xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
        }
        catch (XMLMarshalException xme) {
            if (xme.getErrorCode() == 25007) {
                isPrimitiveWrapper = this.isPrimitiveWrapper(clazz);
                if (isPrimitiveWrapper) {
                    unmarshalRecord = new XMLRootRecord(clazz);
                    unmarshalRecord.setSession((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0)));
                }
                throw xme;
            }
            throw xme;
        }
        try {
            try {
                XMLReader xmlReader = this.getXMLReader();
                unmarshalRecord.setXMLReader(xmlReader);
                unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
                this.setContentHandler(xmlReader, unmarshalRecord);
                xmlReader.setLexicalHandler(unmarshalRecord);
                xmlReader.parse(systemId);
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (SAXException e) {
                throw this.convertSAXException(e);
            }
            Object var12_18 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            throw throwable;
        }
        this.xmlUnmarshaller.resolveReferences(session);
        if (isPrimitiveWrapper) {
            return unmarshalRecord.getCurrentObject();
        }
        return xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object unmarshal(org.xml.sax.XMLReader xmlReader, InputSource inputSource) {
        Object object;
        try {
            try {
                XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
                if (xmlContext.hasDocumentPreservation()) {
                    SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
                    xmlReader.setContentHandler(saxDocumentBuilder);
                    xmlReader.parse(inputSource);
                    Object object2 = this.unmarshal(saxDocumentBuilder.getDocument().getDocumentElement());
                    Object var8_10 = null;
                    this.xmlUnmarshaller.getStringBuffer().reset();
                    return object2;
                }
                XMLReader extendedXMLReader = xmlReader instanceof XMLReader ? (XMLReader)xmlReader : new XMLReader(xmlReader);
                SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(xmlContext);
                saxUnmarshallerHandler.setXMLReader(extendedXMLReader);
                saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                this.setContentHandler(extendedXMLReader, saxUnmarshallerHandler);
                extendedXMLReader.parse(inputSource);
                saxUnmarshallerHandler.resolveReferences();
                object = saxUnmarshallerHandler.getObject();
            }
            catch (IOException e) {
                throw XMLMarshalException.unmarshalException(e);
            }
            catch (SAXException e) {
                throw this.convertSAXException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            throw throwable;
        }
        Object var8_11 = null;
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object unmarshal(org.xml.sax.XMLReader xmlReader, InputSource inputSource, Class clazz) {
        Object object;
        block13: {
            Object object2;
            block12: {
                Object object3;
                block11: {
                    try {
                        try {
                            XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
                            if (xmlContext.hasDocumentPreservation()) {
                                SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
                                xmlReader.setContentHandler(saxDocumentBuilder);
                                xmlReader.parse(inputSource);
                                Object object4 = this.unmarshal(saxDocumentBuilder.getDocument().getDocumentElement(), clazz);
                                Object var12_11 = null;
                                this.xmlUnmarshaller.getStringBuffer().reset();
                                return object4;
                            }
                            UnmarshalRecord unmarshalRecord = null;
                            XMLDescriptor xmlDescriptor = null;
                            AbstractSession session = null;
                            boolean isPrimitiveWrapper = false;
                            if (clazz == ClassConstants.OBJECT) {
                                SAXUnmarshallerHandler saxUnmarshallerHandler = new SAXUnmarshallerHandler(this.xmlUnmarshaller.getXMLContext());
                                saxUnmarshallerHandler.setXMLReader((XMLReader)xmlReader);
                                saxUnmarshallerHandler.setUnmarshaller(this.xmlUnmarshaller);
                                saxUnmarshallerHandler.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
                                xmlReader.setContentHandler(saxUnmarshallerHandler);
                                xmlReader.parse(inputSource);
                                saxUnmarshallerHandler.resolveReferences();
                                object3 = saxUnmarshallerHandler.getObject();
                                break block11;
                            }
                            try {
                                session = xmlContext.getReadSession(clazz);
                                xmlDescriptor = (XMLDescriptor)session.getDescriptor(clazz);
                                unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(session);
                            }
                            catch (XMLMarshalException xme) {
                                if (xme.getErrorCode() != 25007) throw xme;
                                isPrimitiveWrapper = this.isPrimitiveWrapper(clazz);
                                if (!isPrimitiveWrapper) throw xme;
                                unmarshalRecord = new XMLRootRecord(clazz);
                                unmarshalRecord.setSession((AbstractSession)((Object)this.xmlUnmarshaller.getXMLContext().getSession(0)));
                            }
                            XMLReader extendedXMLReader = xmlReader instanceof XMLReader ? (XMLReader)xmlReader : new XMLReader(xmlReader);
                            unmarshalRecord.setXMLReader(extendedXMLReader);
                            unmarshalRecord.setUnmarshaller(this.xmlUnmarshaller);
                            this.setContentHandler(extendedXMLReader, unmarshalRecord);
                            extendedXMLReader.setLexicalHandler(unmarshalRecord);
                            extendedXMLReader.parse(inputSource);
                            this.xmlUnmarshaller.resolveReferences(session);
                            if (isPrimitiveWrapper || clazz == ClassConstants.OBJECT) {
                                object2 = unmarshalRecord.getCurrentObject();
                                break block12;
                            }
                            object = xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.isResultAlwaysXMLRoot);
                            break block13;
                        }
                        catch (IOException e) {
                            throw XMLMarshalException.unmarshalException(e);
                        }
                        catch (SAXException e) {
                            throw this.convertSAXException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        this.xmlUnmarshaller.getStringBuffer().reset();
                        throw throwable;
                    }
                }
                Object var12_12 = null;
                this.xmlUnmarshaller.getStringBuffer().reset();
                return object3;
            }
            Object var12_13 = null;
            this.xmlUnmarshaller.getStringBuffer().reset();
            return object2;
        }
        Object var12_14 = null;
        this.xmlUnmarshaller.getStringBuffer().reset();
        return object;
    }

    private EclipseLinkException convertSAXException(SAXException saxException) {
        Exception internalException = saxException.getException();
        if (internalException != null) {
            if (EclipseLinkException.class.isAssignableFrom(internalException.getClass())) {
                return (EclipseLinkException)internalException;
            }
            return XMLMarshalException.unmarshalException(internalException);
        }
        return XMLMarshalException.unmarshalException(saxException);
    }

    @Override
    public boolean isResultAlwaysXMLRoot() {
        return this.isResultAlwaysXMLRoot;
    }

    @Override
    public void setResultAlwaysXMLRoot(boolean alwaysReturnRoot) {
        this.isResultAlwaysXMLRoot = alwaysReturnRoot;
    }

    private boolean isPrimitiveWrapper(Class clazz) {
        return XMLConversionManager.getDefaultJavaTypes().get(clazz) != null || ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(clazz) || ClassConstants.DURATION.isAssignableFrom(clazz);
    }

    private void setContentHandler(XMLReader xmlReader, ContentHandler contentHandler) {
        this.setValidatorHandler(xmlReader);
        xmlReader.setContentHandler(contentHandler);
    }

    private void setValidatorHandler(XMLReader xmlReader) {
        Schema schema = this.getSchema();
        if (null != schema) {
            ValidatorHandler validatorHandler = schema.newValidatorHandler();
            xmlReader.setValidatorHandler(validatorHandler);
            validatorHandler.setErrorHandler(this.getErrorHandler());
        }
    }
}

