/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ClientSessionIdentityMapAccessor;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSession
extends AbstractSession {
    protected ServerSession parent;
    protected ConnectionPolicy connectionPolicy;
    protected Map<String, Accessor> writeConnections;
    protected boolean isActive;
    protected Sequencing sequencing;

    public ClientSession(ServerSession parent, ConnectionPolicy connectionPolicy) {
        this(parent, connectionPolicy, null);
    }

    public ClientSession(ServerSession parent, ConnectionPolicy connectionPolicy, Map properties) {
        this.project = parent.getProject();
        if (connectionPolicy.isUserDefinedConnection()) {
            this.setProject(this.getProject().clone());
            this.setLogin(connectionPolicy.getLogin());
        }
        this.isLoggingOff = parent.isLoggingOff();
        this.isActive = true;
        this.externalTransactionController = parent.getExternalTransactionController();
        this.parent = parent;
        this.connectionPolicy = connectionPolicy;
        this.name = parent.getName();
        this.profiler = parent.getProfiler();
        this.isInProfile = parent.isInProfile();
        this.commitManager = parent.getCommitManager();
        this.partitioningPolicy = parent.getPartitioningPolicy();
        this.sessionLog = parent.getSessionLog();
        if (parent.hasEventManager()) {
            this.eventManager = parent.getEventManager().clone(this);
        }
        this.exceptionHandler = parent.getExceptionHandler();
        this.pessimisticLockTimeoutDefault = parent.getPessimisticLockTimeoutDefault();
        this.queryTimeoutDefault = parent.getQueryTimeoutDefault();
        this.properties = properties;
        if (this.eventManager != null) {
            this.eventManager.postAcquireClientSession();
        }
        this.descriptors = parent.getDescriptors();
        this.incrementProfile("Counter:ClientSessionCreates");
    }

    protected ClientSession(Project project) {
        super(project);
    }

    @Override
    public void releaseJTSConnection() {
        if (this.hasWriteConnection()) {
            for (Accessor accessor : this.getWriteConnections().values()) {
                accessor.closeJTSConnection();
            }
            this.releaseWriteConnection();
        }
    }

    @Override
    public void basicCommitTransaction() {
        super.basicCommitTransaction();
        if (this.hasExternalTransactionController()) {
            if (!this.isSynchronized()) {
                this.releaseJTSConnection();
            }
        } else {
            this.releaseWriteConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void basicRollbackTransaction() {
        try {
            if (this.hasWriteConnection()) {
                super.basicRollbackTransaction();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.hasExternalTransactionController()) {
                if (this.isSynchronized()) throw throwable;
                this.releaseJTSConnection();
                throw throwable;
            } else {
                this.releaseWriteConnection();
            }
            throw throwable;
        }
        if (this.hasExternalTransactionController()) {
            if (this.isSynchronized()) return;
            this.releaseJTSConnection();
            return;
        }
        this.releaseWriteConnection();
    }

    public void connect(Accessor accessor) throws DatabaseException {
        accessor.connect(this.getDatasourceLogin(), this);
    }

    @Override
    public boolean containsQuery(String queryName) {
        boolean containsQuery = this.getQueries().containsKey(queryName);
        if (!containsQuery) {
            containsQuery = this.parent.containsQuery(queryName);
        }
        return containsQuery;
    }

    public void disconnect(Accessor accessor) throws DatabaseException {
        accessor.disconnect(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        Object object;
        block14: {
            Collection<Accessor> accessors;
            if (!this.isInTransaction() && !this.isExclusiveIsolatedClientSession()) {
                return this.parent.executeCall(call, translationRow, query);
            }
            boolean shouldReleaseConnection = false;
            if (!(query.getAccessors() != null || this.hasWriteConnection() && this.isExclusiveIsolatedClientSession() || (accessors = this.getAccessors(call, translationRow, query)) == null || accessors.isEmpty())) {
                query.setAccessors(accessors);
                boolean bl = shouldReleaseConnection = !this.isActive;
            }
            if (query.getAccessors() == null) {
                if (!this.hasWriteConnection()) {
                    this.parent.acquireClientConnection(this);
                    shouldReleaseConnection = !this.isActive;
                    query.setAccessors(this.getAccessors());
                } else if (!this.isExclusiveIsolatedClientSession() && this.connectionPolicy.isPooled()) {
                    Accessor defaultWriteConnection = this.writeConnections.get(this.connectionPolicy.getPoolName());
                    if (defaultWriteConnection == null) {
                        this.parent.acquireClientConnection(this);
                    }
                    if (this.writeConnections.size() == 1) {
                        query.setAccessors(this.getAccessors());
                    } else {
                        ArrayList<Accessor> accessors2 = new ArrayList<Accessor>(1);
                        accessors2.add(defaultWriteConnection);
                        query.setAccessors(accessors2);
                    }
                } else {
                    query.setAccessors(this.getAccessors());
                }
            }
            try {
                object = this.basicExecuteCall(call, translationRow, query);
                Object var8_7 = null;
                if (call.isFinished()) {
                    query.setAccessors(null);
                }
                if (!shouldReleaseConnection || !this.hasWriteConnection()) break block14;
            }
            catch (Throwable throwable) {
                block15: {
                    Object var8_8 = null;
                    if (call.isFinished()) {
                        query.setAccessors(null);
                    }
                    if (!shouldReleaseConnection || !this.hasWriteConnection()) break block15;
                    this.parent.releaseClientSession(this);
                }
                throw throwable;
            }
            this.parent.releaseClientSession(this);
        }
        return object;
    }

    @Override
    public Collection<Accessor> getAccessors() {
        if (this.isInTransaction()) {
            if (this.writeConnections == null) {
                return null;
            }
            return this.writeConnections.values();
        }
        return this.accessors;
    }

    @Override
    public Accessor getAccessor() {
        Collection<Accessor> accessors = this.getAccessors();
        if (accessors == null || accessors.isEmpty()) {
            if (this.isInTransaction()) {
                this.parent.acquireClientConnection(this);
                accessors = this.getAccessors();
            } else {
                return this.parent.getAccessor();
            }
        }
        if (accessors instanceof List) {
            return (Accessor)((List)accessors).get(0);
        }
        return accessors.iterator().next();
    }

    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    @Override
    public AbstractSession getParentIdentityMapSession(ClassDescriptor descriptor, boolean canReturnSelf, boolean terminalOnly) {
        return this.parent.getParentIdentityMapSession(descriptor, canReturnSelf, terminalOnly);
    }

    @Override
    public Object getProperty(String name) {
        Object propertyValue = super.getProperty(name);
        if (propertyValue == null) {
            propertyValue = this.parent.getProperty(name);
        }
        return propertyValue;
    }

    @Override
    public AbstractSession getExecutionSession(DatabaseQuery query) {
        if (this.isInTransaction()) {
            return this;
        }
        return this.parent.getExecutionSession(query);
    }

    @Override
    public ServerSession getParent() {
        return this.parent;
    }

    @Override
    public DatabaseQuery getQuery(String name) {
        DatabaseQuery query = super.getQuery(name);
        if (query == null) {
            query = this.parent.getQuery(name);
        }
        return query;
    }

    @Override
    public DatabaseQuery getQuery(String name, Vector args) {
        DatabaseQuery query = super.getQuery(name, args);
        if (query == null) {
            query = this.parent.getQuery(name, args);
        }
        return query;
    }

    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }

    @Override
    public Sequencing getSequencing() {
        if (this.sequencing == null) {
            this.initializeSequencing();
        }
        return this.sequencing;
    }

    @Override
    public ServerPlatform getServerPlatform() {
        return this.parent.getServerPlatform();
    }

    @Override
    public String getSessionTypeString() {
        return "ClientSession";
    }

    public Map<String, Accessor> getWriteConnections() {
        if (this.writeConnections == null) {
            this.writeConnections = new HashMap<String, Accessor>(4);
        }
        return this.writeConnections;
    }

    public Accessor getWriteConnection() {
        if (this.writeConnections == null || this.writeConnections.isEmpty()) {
            return null;
        }
        return this.writeConnections.values().iterator().next();
    }

    public boolean hasWriteConnection() {
        if (this.writeConnections == null) {
            return false;
        }
        return !this.writeConnections.isEmpty();
    }

    @Override
    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new ClientSessionIdentityMapAccessor(this);
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean isClientSession() {
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.parent.isConnected();
    }

    @Override
    public void release() throws DatabaseException {
        if (!this.isActive) {
            return;
        }
        if (this.eventManager != null) {
            this.eventManager.preReleaseClientSession();
        }
        if (this.hasWriteConnection()) {
            this.parent.releaseClientSession(this);
        }
        this.isActive = false;
        this.log(2, "connection", "client_released");
        if (this.eventManager != null) {
            this.eventManager.postReleaseClientSession();
        }
    }

    @Override
    public Object retryQuery(DatabaseQuery query, AbstractRecord row, DatabaseException databaseException, int retryCount, AbstractSession executionSession) {
        this.getParent().releaseInvalidClientSession(this);
        return super.retryQuery(query, row, databaseException, retryCount, executionSession);
    }

    protected void releaseWriteConnection() {
        if (this.connectionPolicy.isLazy() && this.hasWriteConnection()) {
            this.parent.releaseClientSession(this);
        }
    }

    public void setConnectionPolicy(ConnectionPolicy connectionPolicy) {
        this.connectionPolicy = connectionPolicy;
    }

    protected void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    protected void setParent(ServerSession parent) {
        this.parent = parent;
    }

    public Accessor addWriteConnection(String poolName, Accessor writeConnection) {
        this.getWriteConnections().put(poolName, writeConnection);
        writeConnection.createCustomizer(this);
        if (!writeConnection.usesExternalConnectionPooling()) {
            this.postAcquireConnection(writeConnection);
        }
        if (this.isInTransaction()) {
            this.basicBeginTransaction(writeConnection);
        }
        return this.getWriteConnections().get(poolName);
    }

    @Override
    public DatabaseException retryTransaction(Accessor writeConnection, DatabaseException databaseException, int retryCount, AbstractSession executionSession) {
        if (writeConnection.getPool() == null) {
            return super.retryTransaction(writeConnection, databaseException, retryCount, executionSession);
        }
        String poolName = writeConnection.getPool().getName();
        DatabaseLogin login = this.getLogin();
        int count = login.getQueryRetryAttemptCount();
        DatabaseException exceptionToThrow = databaseException;
        while (retryCount < count) {
            this.getWriteConnections().remove(poolName);
            if (!writeConnection.usesExternalConnectionPooling()) {
                this.preReleaseConnection(writeConnection);
            }
            writeConnection.getPool().releaseConnection(writeConnection);
            try {
                writeConnection = writeConnection.getPool().acquireConnection();
                writeConnection.beginTransaction(this);
                if (++retryCount > 1) {
                    Thread.currentThread();
                    Thread.sleep(login.getDelayBetweenConnectionAttempts());
                }
                this.getWriteConnections().put(poolName, writeConnection);
                writeConnection.createCustomizer(this);
                if (!writeConnection.usesExternalConnectionPooling()) {
                    this.postAcquireConnection(writeConnection);
                }
                return null;
            }
            catch (DatabaseException ex) {
                exceptionToThrow = ex;
            }
            catch (InterruptedException ex) {
            }
        }
        return exceptionToThrow;
    }

    public void setWriteConnections(Map<String, Accessor> writeConnections) {
        if (this.writeConnections != null && writeConnections == null) {
            for (Accessor accessor : this.writeConnections.values()) {
                accessor.releaseCustomizer(this);
            }
        }
        this.writeConnections = writeConnections;
    }

    public void setWriteConnection(Accessor writeConnection) {
        if (writeConnection == null) {
            this.setWriteConnections(null);
            return;
        }
        String poolName = null;
        poolName = writeConnection.getPool() != null ? writeConnection.getPool().getName() : "not-pooled";
        this.addWriteConnection(poolName, writeConnection);
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(this.getSessionTypeString());
        writer.write("(");
        writer.write(String.valueOf(this.getWriteConnections()));
        writer.write(")");
        return writer.toString();
    }

    @Override
    public CommandManager getCommandManager() {
        return this.parent.getCommandManager();
    }

    @Override
    public boolean shouldPropagateChanges() {
        return this.parent.shouldPropagateChanges();
    }

    @Override
    public void releaseReadConnection(Accessor connection) {
        if (this.writeConnections != null && this.writeConnections.containsKey(connection)) {
            return;
        }
        this.parent.releaseReadConnection(connection);
    }

    @Override
    public boolean isExclusiveConnectionRequired() {
        return !this.connectionPolicy.isLazy && this.isActive();
    }
}

