/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;

public class JAXBIntrospector
extends javax.xml.bind.JAXBIntrospector {
    private XMLContext context;

    public JAXBIntrospector(XMLContext context) {
        this.context = context;
    }

    public boolean isElement(Object obj) {
        if (obj instanceof JAXBElement) {
            return true;
        }
        try {
            AbstractSession session = this.context.getSession(obj);
            if (session == null) {
                return false;
            }
            XMLDescriptor descriptor = (XMLDescriptor)session.getDescriptor(obj);
            if (descriptor == null) {
                return false;
            }
            return descriptor.getDefaultRootElement().length() != 0;
        }
        catch (XMLMarshalException e) {
            return false;
        }
    }

    public QName getElementName(Object obj) {
        if (!this.isElement(obj)) {
            return null;
        }
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getName();
        }
        try {
            XMLDescriptor descriptor = (XMLDescriptor)this.context.getSession(obj).getDescriptor(obj);
            XPathFragment rootFragment = descriptor.getDefaultRootElementField().getXPathFragment();
            return new QName(rootFragment.getNamespaceURI(), rootFragment.getLocalName());
        }
        catch (XMLMarshalException e) {
            return null;
        }
    }
}

