/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectClause
extends AbstractExpression {
    private boolean hasDistinct;
    private boolean hasSpaceAfterDistinct;
    private boolean hasSpaceAfterSelect;
    private AbstractExpression selectExpression;

    AbstractSelectClause(AbstractExpression parent) {
        super(parent, "SELECT");
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getSelectExpression().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getSelectExpression());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression("SELECT"));
        if (this.hasSpaceAfterSelect) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasDistinct) {
            children.add(this.buildStringExpression("DISTINCT"));
        }
        if (this.hasSpaceAfterDistinct) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.selectExpression != null) {
            children.add(this.selectExpression);
        }
    }

    public Expression getSelectExpression() {
        if (this.selectExpression == null) {
            this.selectExpression = this.buildNullExpression();
        }
        return this.selectExpression;
    }

    public boolean hasDistinct() {
        return this.hasDistinct;
    }

    public boolean hasSelectExpression() {
        return this.selectExpression != null && !this.selectExpression.isNull();
    }

    public boolean hasSpaceAfterDistinct() {
        return this.hasSpaceAfterDistinct;
    }

    public boolean hasSpaceAfterSelect() {
        return this.hasSpaceAfterSelect;
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward("SELECT");
        this.hasSpaceAfterSelect = wordParser.skipLeadingWhitespace() > 0;
        this.hasDistinct = wordParser.startsWithIdentifier("DISTINCT");
        if (this.hasDistinct) {
            wordParser.moveForward("DISTINCT");
            this.hasSpaceAfterDistinct = wordParser.skipLeadingWhitespace() > 0;
        }
        this.selectExpression = this.parse(wordParser, this.selectItemBNF(), tolerant);
    }

    abstract JPQLQueryBNF selectItemBNF();

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append("SELECT");
        if (this.hasSpaceAfterSelect) {
            writer.append(' ');
        }
        if (this.hasDistinct) {
            writer.append("DISTINCT");
        }
        if (this.hasSpaceAfterDistinct) {
            writer.append(' ');
        }
        if (this.selectExpression != null) {
            this.selectExpression.toParsedText(writer, includeVirtual);
        }
    }
}

