/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataColumn;

public class DirectColumnMetadata
extends MetadataColumn {
    private Boolean m_nullable;
    private Boolean m_updatable;
    private Boolean m_insertable;

    public DirectColumnMetadata(MetadataAnnotation directColumn, MetadataAccessor accessor) {
        super(directColumn, accessor);
        if (directColumn != null) {
            this.m_nullable = (Boolean)directColumn.getAttribute("nullable");
            this.m_updatable = (Boolean)directColumn.getAttribute("updatable");
            this.m_insertable = (Boolean)directColumn.getAttribute("insertable");
        }
    }

    protected DirectColumnMetadata(String xmlElement) {
        super(xmlElement);
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof DirectColumnMetadata) {
            DirectColumnMetadata directColumn = (DirectColumnMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_nullable, directColumn.getNullable())) {
                return false;
            }
            if (!this.valuesMatch(this.m_updatable, directColumn.getUpdatable())) {
                return false;
            }
            return this.valuesMatch(this.m_insertable, directColumn.getInsertable());
        }
        return false;
    }

    public DatabaseField getDatabaseField() {
        DatabaseField databaseField = super.getDatabaseField();
        databaseField.setNullable(this.m_nullable == null ? true : this.m_nullable);
        databaseField.setUpdatable(this.m_updatable == null ? true : this.m_updatable);
        databaseField.setInsertable(this.m_insertable == null ? true : this.m_insertable);
        return databaseField;
    }

    public Boolean getInsertable() {
        return this.m_insertable;
    }

    public Boolean getNullable() {
        return this.m_nullable;
    }

    public Boolean getUpdatable() {
        return this.m_updatable;
    }

    public void setInsertable(Boolean insertable) {
        this.m_insertable = insertable;
    }

    public void setNullable(Boolean nullable) {
        this.m_nullable = nullable;
    }

    public void setUpdatable(Boolean updatable) {
        this.m_updatable = updatable;
    }
}

