/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceResolver
implements XMLNamespaceResolver {
    private static final String BASE_PREFIX = "ns";
    private String defaultNamespaceURI;
    private Map<String, String> prefixesToNamespaces;
    int prefixCounter;
    private Node dom;

    public Map<String, String> getPrefixesToNamespaces() {
        if (null == this.prefixesToNamespaces) {
            this.prefixesToNamespaces = new HashMap<String, String>();
        }
        return this.prefixesToNamespaces;
    }

    public boolean hasPrefixesToNamespaces() {
        return null != this.prefixesToNamespaces;
    }

    public void setDOM(Node dom) {
        this.dom = dom;
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        if (null == prefix || prefix.length() == 0) {
            return this.defaultNamespaceURI;
        }
        String uri = null;
        if (null != this.prefixesToNamespaces) {
            uri = this.prefixesToNamespaces.get(prefix);
        }
        if (null != uri) {
            return uri;
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (this.dom != null) {
            return XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(this.dom, prefix);
        }
        return null;
    }

    public String resolveNamespaceURI(String uri) {
        if (null == uri) {
            return null;
        }
        if (null != this.prefixesToNamespaces) {
            for (Map.Entry<String, String> entry : this.prefixesToNamespaces.entrySet()) {
                if (!uri.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        if (uri.equalsIgnoreCase("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (uri.equalsIgnoreCase("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        return this.resolveNamespaceURI(this.dom, uri);
    }

    private String resolveNamespaceURI(Node node, String uri) {
        if (null == node) {
            return null;
        }
        if (uri.equals(node.getNamespaceURI())) {
            return node.getPrefix();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (null != namedNodeMap) {
            int namedNodeMapSize = namedNodeMap.getLength();
            for (int x = 0; x < namedNodeMapSize; ++x) {
                Node attr = namedNodeMap.item(x);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !uri.equals(attr.getNodeValue())) continue;
                if (attr.getLocalName() != null && !attr.getLocalName().equals("xmlns")) {
                    return attr.getLocalName();
                }
                return "";
            }
        }
        return this.resolveNamespaceURI(node.getParentNode(), uri);
    }

    public void put(String prefix, String namespaceURI) {
        if (null == prefix || 0 == prefix.length()) {
            this.defaultNamespaceURI = namespaceURI;
        } else {
            this.getPrefixesToNamespaces().put(prefix, namespaceURI.intern());
        }
    }

    public Enumeration getPrefixes() {
        if (this.hasPrefixesToNamespaces()) {
            return new IteratorEnumeration(this.getPrefixesToNamespaces().keySet().iterator());
        }
        return new IteratorEnumeration(null);
    }

    public Vector getNamespaces() {
        if (!this.hasPrefixesToNamespaces()) {
            return new Vector(0);
        }
        Vector<Namespace> names = new Vector<Namespace>(this.prefixesToNamespaces.size());
        for (Map.Entry<String, String> entry : this.prefixesToNamespaces.entrySet()) {
            Namespace namespace = new Namespace(entry.getKey(), entry.getValue());
            names.addElement(namespace);
        }
        return names;
    }

    public void setNamespaces(Vector names) {
        this.prefixesToNamespaces = new HashMap<String, String>(names.size());
        for (Namespace namespace : names) {
            if (namespace.getPrefix() == null || namespace.getNamespaceURI() == null) continue;
            this.prefixesToNamespaces.put(namespace.getPrefix(), namespace.getNamespaceURI());
        }
    }

    public String generatePrefix() {
        return this.generatePrefix(this.getNextPrefix());
    }

    private String getNextPrefix() {
        return BASE_PREFIX + this.prefixCounter++;
    }

    public String generatePrefix(String defaultPrefix) {
        String lookup = this.resolveNamespacePrefix(defaultPrefix);
        while (lookup != null) {
            defaultPrefix = this.getNextPrefix();
            lookup = this.resolveNamespacePrefix(defaultPrefix);
        }
        return defaultPrefix;
    }

    public void removeNamespace(String prefix) {
        if (null != this.prefixesToNamespaces) {
            this.prefixesToNamespaces.remove(prefix);
        }
    }

    public void setDefaultNamespaceURI(String namespaceUri) {
        this.defaultNamespaceURI = namespaceUri == null ? namespaceUri : namespaceUri.intern();
    }

    public String getDefaultNamespaceURI() {
        return this.defaultNamespaceURI;
    }

    private static class IteratorEnumeration
    implements Enumeration {
        private Iterator iterator;

        public IteratorEnumeration(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasMoreElements() {
            if (null == this.iterator) {
                return false;
            }
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

