/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.sessions.CopyGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeGroup
implements Serializable,
Cloneable {
    private String name;
    protected Map<String, AttributeItem> items;

    public AttributeGroup(String name) {
        this.name = name;
    }

    public AttributeGroup() {
        this("");
    }

    protected AttributeItem newItem(AttributeGroup group, String attrName) {
        return new AttributeItem(group, attrName);
    }

    protected AttributeGroup newGroup(String name, AttributeGroup parent) {
        return new AttributeGroup(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getAttributeNames() {
        return this.getItems().keySet();
    }

    public void setAttributeNames(Set attributeNames) {
        Iterator it = attributeNames.iterator();
        while (it.hasNext()) {
            this.addAttribute((String)it.next());
        }
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public Map<String, AttributeItem> getItems() {
        if (this.items == null) {
            this.items = new HashMap<String, AttributeItem>();
        }
        return this.items;
    }

    public boolean containsAttributeInternal(String attributeName) {
        return this.items != null && this.items.containsKey(attributeName);
    }

    public boolean containsAttribute(String attributeNameOrPath) {
        String[] path = this.convert(attributeNameOrPath);
        return this.getItem(path, false) != null;
    }

    public void addAttribute(String attributeNameOrPath) {
        this.addAttribute(attributeNameOrPath, null);
    }

    public void addAttribute(String attributeNameOrPath, AttributeGroup group) {
        AttributeItem item = this.getItem(this.convert(attributeNameOrPath), true);
        item.setGroup(group);
    }

    public void addAttributes(Collection<String> attrOrPaths) {
        for (String attr : attrOrPaths) {
            this.addAttribute(attr);
        }
    }

    public AttributeGroup getGroup(String attributeNameOrPath) {
        AttributeItem item = this.getItem(this.convert(attributeNameOrPath), false);
        if (item != null) {
            return item.getGroup();
        }
        return null;
    }

    public AttributeItem getItem(String attributeNameOrPath) {
        return this.getItem(this.convert(attributeNameOrPath), false);
    }

    private AttributeItem getItem(String[] attributePath, boolean create) {
        AttributeItem item = null;
        AttributeGroup currentGroup = this;
        for (int index = 0; index < attributePath.length; ++index) {
            String attrName = attributePath[index];
            item = currentGroup.getItems().get(attrName);
            if (item == null) {
                if (!create) {
                    return null;
                }
                item = this.newItem(currentGroup, attrName);
                currentGroup.getItems().put(attrName, item);
            }
            if (item.getGroup() == null && index < attributePath.length - 1) {
                if (!create) {
                    return null;
                }
                AttributeGroup newGroup = this.newGroup(AttributeGroup.toStringPath(attributePath, index), currentGroup);
                item.setGroup(newGroup);
            }
            currentGroup = item.getGroup();
        }
        return item;
    }

    public void removeAttribute(String attributeNameOrPath) {
        AttributeItem item = this.getItem(attributeNameOrPath);
        if (item != null) {
            item.getParent().getItems().remove(item.getAttributeName());
        }
    }

    public boolean isSupersetOf(AttributeGroup anotherGroup) {
        if (anotherGroup == null) {
            return false;
        }
        if (anotherGroup != this) {
            if (this.hasItems()) {
                if (anotherGroup.hasItems()) {
                    for (Map.Entry<String, AttributeItem> otherItemEntry : anotherGroup.getItems().entrySet()) {
                        String otherAttributeName = otherItemEntry.getKey();
                        AttributeItem item = this.items.get(otherAttributeName);
                        if (item == null) {
                            return false;
                        }
                        AttributeGroup group = item.getGroup();
                        AttributeGroup otherGroup = otherItemEntry.getValue().getGroup();
                        if (group != null) {
                            if (group.isSupersetOf(otherGroup)) continue;
                            return false;
                        }
                        if (otherGroup == null) continue;
                        return true;
                    }
                    return true;
                }
                return true;
            }
            return !anotherGroup.hasItems();
        }
        return true;
    }

    protected String[] convert(String ... nameOrPath) {
        if (nameOrPath == null || nameOrPath.length == 0 || nameOrPath.length == 1 && (nameOrPath[0] == null || nameOrPath[0].length() == 0)) {
            throw new IllegalArgumentException("Inavlid name or path: " + (nameOrPath.length == 1 ? nameOrPath[0] : null));
        }
        String[] path = nameOrPath;
        if (nameOrPath.length > 1 || !nameOrPath[0].contains(".")) {
            path = nameOrPath;
        } else {
            if (nameOrPath[0].endsWith(".")) {
                throw new IllegalArgumentException("Invalid path: " + nameOrPath[0]);
            }
            path = nameOrPath[0].split("\\.");
        }
        if (path.length == 0) {
            throw new IllegalArgumentException("Invalid path: " + nameOrPath[0]);
        }
        for (int index = 0; index < path.length; ++index) {
            if (path[index] != null && path[index].length() != 0 && path[index].trim().equals(path[index])) continue;
            throw new IllegalArgumentException("Invalid path: " + nameOrPath[0]);
        }
        return path;
    }

    public boolean equals(Object obj) {
        if (this != obj) {
            if (obj == null) {
                return false;
            }
            AttributeGroup anotherGroup = null;
            try {
                anotherGroup = (AttributeGroup)obj;
            }
            catch (ClassCastException cce) {
                return false;
            }
            if (this.hasItems()) {
                if (anotherGroup.hasItems()) {
                    return ((Object)this.getItems()).equals(anotherGroup.getItems());
                }
                return false;
            }
            return !anotherGroup.hasItems();
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + ")" + this.toStringAdditionalInfo() + "{" + this.toStringItems() + "}";
    }

    protected String toStringAdditionalInfo() {
        return "";
    }

    protected String toStringItems() {
        String str = "";
        if (this.items != null) {
            Iterator<AttributeItem> it = this.items.values().iterator();
            boolean isFirst = true;
            while (it.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    str = str + ", ";
                }
                str = str + it.next().toStringNoClassName();
            }
        }
        return str;
    }

    protected static String toStringPath(String[] attributePath, int position) {
        StringWriter writer = new StringWriter();
        for (int index = 0; index <= position; ++index) {
            writer.write(attributePath[index]);
            if (index >= position) continue;
            writer.write(".");
        }
        return writer.toString();
    }

    public boolean isFetchGroup() {
        return false;
    }

    public FetchGroup toFetchGroup() {
        if (this.isFetchGroup()) {
            return (FetchGroup)this;
        }
        FetchGroup fetchGroup = new FetchGroup(this.getName());
        if (this.hasItems()) {
            for (Map.Entry<String, AttributeItem> entry : this.getItems().entrySet()) {
                AttributeGroup group = entry.getValue().getGroup();
                if (group == null) {
                    fetchGroup.addAttribute(entry.getKey());
                    continue;
                }
                fetchGroup.addAttribute(entry.getKey(), group.toFetchGroup());
            }
        }
        return fetchGroup;
    }

    public boolean isCopyGroup() {
        return false;
    }

    public CopyGroup toCopyGroup() {
        if (this.isCopyGroup()) {
            return (CopyGroup)this;
        }
        CopyGroup copyGroup = new CopyGroup(this.getName());
        copyGroup.cascadeTree();
        if (this.hasItems()) {
            for (Map.Entry<String, AttributeItem> entry : this.getItems().entrySet()) {
                AttributeGroup group = entry.getValue().getGroup();
                if (group == null) {
                    copyGroup.addAttribute(entry.getKey());
                    continue;
                }
                copyGroup.addAttribute(entry.getKey(), group.toCopyGroup());
            }
        }
        return copyGroup;
    }

    public boolean isLoadGroup() {
        return false;
    }

    public LoadGroup toLoadGroup() {
        if (this.isLoadGroup()) {
            return (LoadGroup)this;
        }
        LoadGroup loadGroup = new LoadGroup(this.getName());
        if (this.hasItems()) {
            for (Map.Entry<String, AttributeItem> entry : this.getItems().entrySet()) {
                AttributeGroup group = entry.getValue().getGroup();
                if (group == null) {
                    loadGroup.addAttribute(entry.getKey());
                    continue;
                }
                loadGroup.addAttribute(entry.getKey(), group.toLoadGroup());
            }
        }
        return loadGroup;
    }

    public AttributeGroup clone() {
        AttributeGroup clone;
        try {
            clone = (AttributeGroup)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        clone.items = null;
        if (this.hasItems()) {
            for (Map.Entry<String, AttributeItem> entry : this.getItems().entrySet()) {
                AttributeGroup group = entry.getValue().getGroup();
                if (group != null) {
                    clone.addAttribute(entry.getKey(), group.clone());
                    continue;
                }
                clone.addAttribute(entry.getKey());
            }
        }
        return clone;
    }
}

