/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypeAttrs;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewRow;

public class FieldInfo {
    public String fieldName;
    public String fieldTypeName;
    public String fieldTypeSubname;
    public String fieldTypeOwner;
    public String fieldTypeMod;
    public String fieldMethodName;
    public String fieldMethodNo;
    public String fieldPackageName;
    public String fieldCharacterSetName;
    public int fieldSequence;
    public int fieldDataLevel;
    public int fieldDataLength;
    public int fieldDataPrecision;
    public int fieldDataScale;
    public int fieldNo;

    public FieldInfo(AllTypeAttrs r) throws SQLException {
        this.fieldName = r.attrName;
        this.fieldTypeName = r.attrTypeName;
        this.fieldTypeSubname = null;
        this.fieldTypeOwner = r.attrTypeOwner;
        this.fieldTypeMod = r.attrTypeMod;
        this.fieldMethodName = null;
        this.fieldMethodNo = null;
        this.fieldPackageName = null;
        this.fieldSequence = -1;
        this.fieldDataLevel = -1;
        this.fieldDataLength = r.attrLength;
        this.fieldDataPrecision = r.attrPrecision;
        this.fieldDataScale = r.attrScale;
        this.fieldNo = r.attrNo;
        this.fieldCharacterSetName = r.characterSetName;
    }

    public FieldInfo(UserArguments r) throws SQLException {
        this.fieldNo = r.POSITION;
        this.fieldName = r.ARGUMENT_NAME;
        this.fieldTypeOwner = r.TYPE_OWNER;
        this.fieldTypeName = r.TYPE_NAME;
        if (SqlReflector.isNull(this.fieldTypeName)) {
            this.fieldTypeName = r.DATA_TYPE;
        }
        if ("PL/SQL BOOLEAN".equalsIgnoreCase(this.fieldTypeName)) {
            this.fieldTypeName = "BOOLEAN";
        }
        this.fieldTypeSubname = r.TYPE_SUBNAME;
        this.fieldTypeMod = "";
        if ("REF".equalsIgnoreCase(r.DATA_TYPE) || "PL/SQL RECORD".equalsIgnoreCase(r.DATA_TYPE) || "PL/SQL TABLE".equalsIgnoreCase(r.DATA_TYPE) || "VARRAY".equalsIgnoreCase(r.DATA_TYPE) || "TABLE".equalsIgnoreCase(r.DATA_TYPE)) {
            this.fieldTypeMod = r.DATA_TYPE;
        }
        this.fieldPackageName = r.PACKAGE_NAME;
        this.fieldMethodName = r.OBJECT_NAME;
        this.fieldMethodNo = r.OVERLOAD;
        this.fieldSequence = r.sequence;
        this.fieldDataLevel = -1;
        this.fieldDataLength = "PL/SQL RECORD".equalsIgnoreCase(r.DATA_TYPE) ? 0 : r.DATA_LENGTH;
        this.fieldDataPrecision = r.DATA_PRECISION;
        this.fieldDataScale = r.DATA_SCALE;
        this.fieldCharacterSetName = r.CHARACTER_SET_NAME;
    }

    public static List<FieldInfo> getFieldInfo(Iterator<ViewRow> iter) throws SQLException {
        ArrayList<ViewRow> v = new ArrayList<ViewRow>();
        while (iter.hasNext()) {
            v.add(iter.next());
        }
        return FieldInfo.getFieldInfo(v);
    }

    public static List<FieldInfo> getFieldInfo(ArrayList<ViewRow> v) throws SQLException {
        ArrayList<FieldInfo> a = new ArrayList<FieldInfo>();
        for (int i = 0; i < v.size(); ++i) {
            ViewRow vr = v.get(i);
            if (vr.isUserArguments() || vr.isAllArguments()) {
                UserArguments userArguments = (UserArguments)vr;
                a.add(new FieldInfo(userArguments));
                continue;
            }
            if (!vr.isAllTypeAttrs()) continue;
            AllTypeAttrs allTypeAttrs = (AllTypeAttrs)vr;
            a.add(new FieldInfo(allTypeAttrs));
        }
        return a;
    }
}

