/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;

public class DbStoredProcedure {
    protected String catalog;
    protected String schema;
    protected String name;
    protected List<DbStoredArgument> arguments = new ArrayList<DbStoredArgument>();
    protected int overload = 0;

    public DbStoredProcedure(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public List<DbStoredArgument> getArguments() {
        return this.arguments;
    }

    public boolean isFunction() {
        return false;
    }

    public int getOverload() {
        return this.overload;
    }

    public void setOverload(int overload) {
        this.overload = overload;
    }

    public String getStoredType() {
        return "PROCEDURE";
    }

    public boolean matches(String catalog, String schema, String name, boolean isOracle, boolean catalogMatchDontCare) {
        boolean schemaMatch;
        boolean catalogMatch;
        boolean bl = this.catalog == null ? (isOracle ? true : catalog == null) : (catalogMatch = this.catalog.equals(catalog));
        if (catalogMatchDontCare) {
            catalogMatch = true;
        }
        boolean bl2 = this.schema == null ? schema == null : (schemaMatch = this.schema.equals(schema));
        boolean nameMatch = this.name == null ? name == null : this.name.equals(name);
        return catalogMatch && schemaMatch && nameMatch;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.overload > 0) {
            sb.append('(');
            sb.append(this.overload);
            sb.append(')');
        }
        sb.append(this.getStoredType());
        sb.append(' ');
        if (this.schema != null && this.schema.length() > 0) {
            sb.append(this.schema);
            sb.append('.');
        }
        if (this.catalog != null && this.catalog.length() > 0) {
            sb.append(this.catalog);
            sb.append('.');
        }
        sb.append(this.name);
        if (this.arguments.size() > 0) {
            sb.append(" (");
            for (DbStoredArgument arg : this.arguments) {
                sb.append("\n\t");
                sb.append(arg);
            }
            sb.append("\n)");
        } else {
            sb.append("()\n");
        }
        return sb.toString();
    }
}

