/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.jdbc.OracleArrayType;
import org.eclipse.persistence.platform.database.oracle.jdbc.OracleObjectType;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherDefaultListener;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.ProcedureOperationModel;

public class PLSQLHelperObjectsBuilder
extends PublisherDefaultListener {
    protected Map<String, DatabaseType[]> methodTypeMap = new HashMap<String, DatabaseType[]>();
    protected Map<String, DatabaseType> knownDatabaseTypesMap = new HashMap<String, DatabaseType>();
    protected Stack<DatabaseType> typeStack = new Stack();
    protected String packageName = null;
    protected String schemaName = null;
    protected String currentMethodName = null;
    protected int currentMethodArgIdx = -1;
    protected DBWSBuilder dbwsBuilder;
    protected ProcedureOperationModel opModel;
    protected boolean processingMethodReturnType = false;

    public PLSQLHelperObjectsBuilder(DBWSBuilder dbwsBuilder) {
        this(dbwsBuilder, null);
    }

    public PLSQLHelperObjectsBuilder(DBWSBuilder dbwsBuilder, ProcedureOperationModel opModel) {
        this.dbwsBuilder = dbwsBuilder;
        this.opModel = opModel;
    }

    public String trimOffSchemaName(String s) {
        if (this.schemaName != null && s.startsWith(this.schemaName)) {
            return s.substring(this.schemaName.length() + 1);
        }
        return s;
    }

    public DatabaseType[] getTypesForMethod(String methodName) {
        return this.methodTypeMap.get(methodName);
    }

    public Map<String, DatabaseType[]> getMethodTypeMap() {
        return this.methodTypeMap;
    }

    public DatabaseType getKnownDatabaseType(String typeName) {
        return this.knownDatabaseTypesMap.get(typeName);
    }

    public void putKnownDatabaseType(String typeName, DatabaseType databaseType) {
        this.knownDatabaseTypesMap.put(typeName, databaseType);
    }

    @Override
    public void beginPackage(String packageName) {
        int dotIdx = packageName.indexOf(46);
        if (dotIdx > -1) {
            this.schemaName = packageName.substring(0, dotIdx);
            this.packageName = packageName.substring(dotIdx + 1);
        }
    }

    @Override
    public void beginPlsqlTable(String tableName, String targetTypeName) {
        PLSQLCollection plsqlCollection = null;
        boolean found = false;
        block0: for (DatabaseType[] databaseTypes : this.methodTypeMap.values()) {
            if (found) break;
            for (DatabaseType databaseType : databaseTypes) {
                PLSQLCollection tmp;
                ComplexDatabaseType cdt;
                if (databaseType == null || !databaseType.isComplexDatabaseType() || !(cdt = (ComplexDatabaseType)databaseType).isCollection() || !(tmp = (PLSQLCollection)cdt).getCompatibleType().equalsIgnoreCase(targetTypeName)) continue;
                found = true;
                plsqlCollection = tmp;
                continue block0;
            }
        }
        if (plsqlCollection == null) {
            plsqlCollection = new PLSQLCollection();
            plsqlCollection.setTypeName(this.trimOffSchemaName(tableName));
            plsqlCollection.setCompatibleType(targetTypeName);
            this.putKnownDatabaseType(tableName, (DatabaseType)plsqlCollection);
        }
        this.typeStack.push((DatabaseType)plsqlCollection);
    }

    @Override
    public void endPlsqlTable(String tableName, String typeDeclaration, String typeDropDDL) {
        if (!"".equals(typeDeclaration)) {
            this.dbwsBuilder.getTypeDDL().add(typeDeclaration);
            this.dbwsBuilder.getTypeDropDDL().add(typeDropDDL);
        }
        PLSQLCollection plsqlCollection = (PLSQLCollection)this.typeStack.pop();
        plsqlCollection.setJavaTypeName(plsqlCollection.getTypeName().toLowerCase() + "_CollectionWrapper");
        if (!this.typeStack.empty()) {
            DatabaseType top = this.typeStack.peek();
            if (top.isComplexDatabaseType()) {
                ComplexDatabaseType cdt = (ComplexDatabaseType)top;
                if (cdt.isCollection()) {
                    ((PLSQLCollection)cdt).setNestedType((DatabaseType)plsqlCollection);
                } else if (cdt.isRecord()) {
                    List fields = ((PLSQLrecord)cdt).getFields();
                    PLSQLargument field = (PLSQLargument)fields.get(fields.size() - 1);
                    if (field.databaseType == null) {
                        field.databaseType = plsqlCollection;
                    }
                }
            }
        } else {
            this.typeStack.push((DatabaseType)plsqlCollection);
        }
    }

    @Override
    public void beginPlsqlRecord(String plsqlRecordName, String targetTypeName, int numFields) {
        PLSQLrecord plsqlRecord = null;
        boolean found = false;
        block0: for (DatabaseType[] databaseTypes : this.methodTypeMap.values()) {
            if (found) break;
            for (DatabaseType databaseType : databaseTypes) {
                PLSQLrecord tmp;
                ComplexDatabaseType cdt;
                if (databaseType == null || !databaseType.isComplexDatabaseType() || !(cdt = (ComplexDatabaseType)databaseType).isRecord() || !(tmp = (PLSQLrecord)cdt).getCompatibleType().equalsIgnoreCase(targetTypeName)) continue;
                found = true;
                plsqlRecord = tmp;
                continue block0;
            }
        }
        if (plsqlRecord == null) {
            plsqlRecord = new PLSQLrecord();
            plsqlRecord.setTypeName(this.trimOffSchemaName(plsqlRecordName));
            plsqlRecord.setCompatibleType(targetTypeName);
            plsqlRecord.setJavaTypeName(plsqlRecord.getTypeName().toLowerCase());
            this.putKnownDatabaseType(plsqlRecordName, (DatabaseType)plsqlRecord);
        }
        this.typeStack.push((DatabaseType)plsqlRecord);
    }

    @Override
    public void beginPlsqlRecordField(String fieldName, int idx) {
        PLSQLrecord plsqlRecord = (PLSQLrecord)this.typeStack.peek();
        boolean found = false;
        for (PLSQLargument arg : plsqlRecord.getFields()) {
            if (!arg.name.equalsIgnoreCase(fieldName)) continue;
            found = true;
            break;
        }
        if (!found) {
            plsqlRecord.addField(fieldName, null);
        }
    }

    @Override
    public void endPlsqlRecord(String plsqlRecordName, String typeDeclaration, String typeDropDDL) {
        if (!"".equals(typeDeclaration)) {
            this.dbwsBuilder.getTypeDDL().add(typeDeclaration);
            this.dbwsBuilder.getTypeDropDDL().add(typeDropDDL);
        }
        PLSQLrecord plsqlRecord = (PLSQLrecord)this.typeStack.pop();
        if (!this.typeStack.empty()) {
            DatabaseType top = this.typeStack.peek();
            if (top.isComplexDatabaseType()) {
                ComplexDatabaseType cdt = (ComplexDatabaseType)top;
                if (cdt.isCollection()) {
                    PLSQLCollection coll = (PLSQLCollection)cdt;
                    if (coll.getNestedType() == null) {
                        coll.setNestedType((DatabaseType)plsqlRecord);
                    }
                } else if (cdt.isRecord()) {
                    PLSQLrecord rec = (PLSQLrecord)cdt;
                    List fields = rec.getFields();
                    PLSQLargument arg = (PLSQLargument)fields.get(fields.size() - 1);
                    if (arg.databaseType == null) {
                        arg.databaseType = plsqlRecord;
                    }
                }
            }
        } else {
            this.typeStack.push((DatabaseType)plsqlRecord);
        }
    }

    @Override
    public void beginMethod(String methodName, int numArgs) {
        this.methodTypeMap.put(methodName, new DatabaseType[numArgs]);
        this.currentMethodName = methodName;
    }

    @Override
    public void beginMethodArg(String argName, String direction, int idx) {
        this.currentMethodArgIdx = idx;
        if (this.processingMethodReturnType) {
            this.processingMethodReturnType = false;
            if (this.opModel != null && !this.typeStack.empty()) {
                this.opModel.setDbStoredFunctionReturnType(this.typeStack.pop());
            }
        }
    }

    @Override
    public void endMethodArg(String argName) {
        DatabaseType[] methodType = this.methodTypeMap.get(this.currentMethodName);
        methodType[this.currentMethodArgIdx] = this.typeStack.pop();
    }

    @Override
    public void endMethod(String methodName) {
        if (this.opModel != null) {
            this.opModel.addArgumentTypes(this.methodTypeMap.get(methodName));
            if (this.processingMethodReturnType) {
                this.processingMethodReturnType = false;
                if (!this.typeStack.empty()) {
                    this.opModel.setDbStoredFunctionReturnType(this.typeStack.pop());
                }
            }
        }
        this.currentMethodName = null;
        this.currentMethodArgIdx = -1;
    }

    @Override
    public void handleMethodReturn(String returnTypeName) {
        this.processingMethodReturnType = true;
    }

    @Override
    public void handleSqlType(String sqlTypeName, int typecode, String targetType) {
        DatabaseType databaseType = JDBCTypes.getDatabaseTypeForCode((int)typecode);
        if (databaseType == null && (databaseType = OraclePLSQLTypes.getDatabaseTypeForCode((String)this.trimOffSchemaName(sqlTypeName))) == null) {
            databaseType = this.getKnownDatabaseType(sqlTypeName);
        }
        if (!this.typeStack.empty()) {
            DatabaseType top = this.typeStack.peek();
            if (top.isComplexDatabaseType()) {
                ComplexDatabaseType cdt = (ComplexDatabaseType)top;
                if (cdt.isCollection()) {
                    PLSQLCollection coll;
                    if (!cdt.isJDBCType() && (coll = (PLSQLCollection)cdt).getNestedType() == null) {
                        coll.setNestedType(databaseType);
                    }
                } else if (cdt.isRecord()) {
                    PLSQLrecord rec = (PLSQLrecord)cdt;
                    List fields = rec.getFields();
                    PLSQLargument arg = (PLSQLargument)fields.get(fields.size() - 1);
                    if (arg.databaseType == null) {
                        arg.databaseType = databaseType;
                    }
                } else if (cdt.isJDBCType()) {
                    OracleObjectType oot = (OracleObjectType)cdt;
                    Map fields = oot.getFields();
                    Object[] keys = oot.getFields().keySet().toArray();
                    String lastInsertedKey = (String)keys[oot.getLastFieldIndex()];
                    fields.put(lastInsertedKey, databaseType);
                }
            }
        } else {
            this.typeStack.push(databaseType);
        }
    }

    @Override
    public void beginObjectType(String objectTypename) {
        DatabaseType databaseType = OraclePLSQLTypes.getDatabaseTypeForCode((String)this.trimOffSchemaName(objectTypename));
        if (databaseType == null) {
            databaseType = this.getKnownDatabaseType(objectTypename);
        }
        if (databaseType == null) {
            ComplexDatabaseType cdt;
            OracleObjectType objectType = new OracleObjectType();
            objectType.setTypeName(objectTypename);
            DatabaseType top = this.typeStack.peek();
            if (top.isComplexDatabaseType() && (cdt = (ComplexDatabaseType)top).isJDBCType()) {
                if (cdt.isCollection()) {
                    OracleArrayType oat = (OracleArrayType)cdt;
                    oat.setNestedType((DatabaseType)objectType);
                } else {
                    Object[] keys;
                    String lastInsertedKey;
                    OracleObjectType oot = (OracleObjectType)cdt;
                    Map fields = oot.getFields();
                    if (fields.get(lastInsertedKey = (String)(keys = oot.getFields().keySet().toArray())[oot.getLastFieldIndex()]) == JDBCTypes.NULL_TYPE) {
                        fields.put(lastInsertedKey, objectType);
                    }
                }
            }
            this.typeStack.push((DatabaseType)objectType);
            this.putKnownDatabaseType(objectTypename, (DatabaseType)objectType);
        }
    }

    @Override
    public void handleObjectType(String objectTypename, String targetTypeName, int numAttributes) {
        DatabaseType databaseType = OraclePLSQLTypes.getDatabaseTypeForCode((String)this.trimOffSchemaName(objectTypename));
        if (databaseType == null) {
            databaseType = this.getKnownDatabaseType(objectTypename);
        }
        if (!this.typeStack.empty()) {
            DatabaseType top = this.typeStack.peek();
            if (top.isComplexDatabaseType()) {
                ComplexDatabaseType cdt = (ComplexDatabaseType)top;
                if (cdt.isCollection()) {
                    PLSQLCollection coll = (PLSQLCollection)cdt;
                    if (coll.getNestedType() == null) {
                        coll.setNestedType(databaseType);
                    }
                } else if (cdt.isRecord()) {
                    PLSQLrecord rec = (PLSQLrecord)cdt;
                    List fields = rec.getFields();
                    PLSQLargument arg = (PLSQLargument)fields.get(fields.size() - 1);
                    if (arg.databaseType == null) {
                        arg.databaseType = databaseType;
                    }
                } else if (cdt.isJDBCType() && this.typeStack.size() > 1) {
                    ComplexDatabaseType cdtMinus1;
                    this.typeStack.pop();
                    DatabaseType topMinus1 = this.typeStack.peek();
                    if (topMinus1.isComplexDatabaseType() && (cdtMinus1 = (ComplexDatabaseType)topMinus1).isRecord()) {
                        PLSQLrecord rec = (PLSQLrecord)cdtMinus1;
                        List fields = rec.getFields();
                        PLSQLargument arg = (PLSQLargument)fields.get(fields.size() - 1);
                        if (arg.databaseType == null) {
                            arg.databaseType = cdt;
                        }
                    }
                    this.typeStack.push(top);
                }
            }
        } else {
            this.typeStack.push(databaseType);
        }
    }

    @Override
    public void handleAttributeField(String attributeFieldName, int idx) {
        DatabaseType top;
        if (!this.typeStack.empty() && (top = this.typeStack.peek()).isComplexDatabaseType() && top.isJDBCType()) {
            ComplexDatabaseType cdt = (ComplexDatabaseType)top;
            OracleObjectType oot = (OracleObjectType)cdt;
            oot.getFields().put(attributeFieldName, JDBCTypes.NULL_TYPE);
            oot.setLastFieldIndex(idx);
        }
    }

    @Override
    public void endObjectType(String objectTypename) {
        DatabaseType top;
        DatabaseType databaseType = OraclePLSQLTypes.getDatabaseTypeForCode((String)this.trimOffSchemaName(objectTypename));
        if (databaseType == null && (top = this.typeStack.peek()).getTypeName().equals(objectTypename)) {
            this.typeStack.pop();
        }
    }

    @Override
    public void handleSqlArrayType(String name, String targetTypeName) {
        DatabaseType databaseType = OraclePLSQLTypes.getDatabaseTypeForCode((String)this.trimOffSchemaName(name));
        if (databaseType == null) {
            databaseType = this.getKnownDatabaseType(name);
        }
        if (databaseType == null) {
            OracleArrayType oat = new OracleArrayType();
            oat.setTypeName(name);
            this.typeStack.push((DatabaseType)oat);
            this.putKnownDatabaseType(name, (DatabaseType)oat);
        } else {
            this.typeStack.push(databaseType);
        }
    }

    @Override
    public void endPlsqlRecordField(String fieldName, int idx) {
        ComplexDatabaseType cdt;
        DatabaseType top;
        if (!this.typeStack.empty() && (top = this.typeStack.peek()).isComplexDatabaseType() && (cdt = (ComplexDatabaseType)top).isJDBCType() && cdt.isCollection()) {
            ComplexDatabaseType cdtMinus1;
            DatabaseType topMinus1;
            DatabaseType pop = this.typeStack.pop();
            if (!this.typeStack.isEmpty() && (topMinus1 = this.typeStack.peek()).isComplexDatabaseType() && (cdtMinus1 = (ComplexDatabaseType)topMinus1).isRecord()) {
                PLSQLrecord recMinus1 = (PLSQLrecord)cdtMinus1;
                PLSQLargument arg2 = null;
                for (PLSQLargument arg2 : recMinus1.getFields()) {
                    if (!arg2.name.equalsIgnoreCase(fieldName)) continue;
                }
                if (arg2 != null && arg2.databaseType == null) {
                    arg2.databaseType = pop;
                }
            }
        }
    }
}

