/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.chooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassDescriptionRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultClassDescriptionAdapter;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.FilteringListPanel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ClassChooserDialog
extends AbstractDialog {
    private ClassDescriptionRepository repository;
    private ClassDescriptionAdapter adapter;
    private ShortClassNameEntry[] shortClassNameEntries;
    private FilteringListPanel filteringPanel;
    private JList packageListBox;
    private MouseListener doubleClickMouseListener;
    Icon classIcon;
    Icon packageIcon;
    private Object initialSelection;
    private boolean allowNullSelection;
    private static final Object[] EMPTY_PACKAGE_LIST = new Object[0];

    public static ClassChooserDialog createDialog(ClassDescriptionRepository repository, WorkbenchContext context) {
        return ClassChooserDialog.createDialog(repository, DefaultClassDescriptionAdapter.instance(), context);
    }

    public static ClassChooserDialog createDialog(ClassDescriptionRepository repository, ClassDescriptionAdapter adapter, WorkbenchContext context) {
        Window window = context.getCurrentWindow();
        if (window instanceof Dialog) {
            return new ClassChooserDialog(repository, adapter, context, (Dialog)window);
        }
        return new ClassChooserDialog(repository, adapter, context);
    }

    private static String title(ApplicationContext context) {
        return context.getResourceRepository().getString("CLASS_CHOOSER_DIALOG.TITLE");
    }

    private ClassChooserDialog(ClassDescriptionRepository repository, ClassDescriptionAdapter adapter, WorkbenchContext context) {
        super(context, ClassChooserDialog.title(context.getApplicationContext()));
        this.initialize(repository, adapter);
    }

    private ClassChooserDialog(ClassDescriptionRepository repository, ClassDescriptionAdapter adapter, WorkbenchContext context, Dialog owner) {
        super(context, ClassChooserDialog.title(context.getApplicationContext()), owner);
        this.initialize(repository, adapter);
    }

    private void initialize(ClassDescriptionRepository cdr, ClassDescriptionAdapter cda) {
        this.repository = cdr;
        this.adapter = cda;
        this.shortClassNameEntries = this.buildShortClassNameEntries();
        this.doubleClickMouseListener = this.buildDoubleClickMouseListener();
        this.classIcon = this.resourceRepository().getIcon("class.public");
        this.packageIcon = this.resourceRepository().getIcon("package");
        this.allowNullSelection = false;
    }

    private ShortClassNameEntry[] buildShortClassNameEntries() {
        Collator collator = Collator.getInstance();
        HashMap shortClassNameEntryMap = new HashMap(20000);
        Iterator stream = this.repository.classDescriptions();
        while (stream.hasNext()) {
            Object classDescription = stream.next();
            this.shortClassNameEntry(classDescription, shortClassNameEntryMap, collator).addPackageEntry(new PackageEntry(classDescription, this.adapter, collator));
        }
        Collection values = shortClassNameEntryMap.values();
        Object[] entries = values.toArray(new ShortClassNameEntry[values.size()]);
        Arrays.sort(entries);
        return entries;
    }

    private ShortClassNameEntry shortClassNameEntry(Object classDescription, Map shortClassNameEntryMap, Collator collator) {
        String shortClassName = this.adapter.shortClassName(classDescription).replace('$', '.');
        ShortClassNameEntry shortClassNameEntry = (ShortClassNameEntry)shortClassNameEntryMap.get(shortClassName);
        if (shortClassNameEntry == null) {
            shortClassNameEntry = new ShortClassNameEntry(shortClassName, collator);
            shortClassNameEntryMap.put(shortClassName, shortClassNameEntry);
        }
        return shortClassNameEntry;
    }

    private MouseListener buildDoubleClickMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ClassChooserDialog.this.clickOK();
                }
            }
        };
    }

    private Action buildRefreshAction() {
        return new AbstractFrameworkAction(this.getWorkbenchContext()){

            @Override
            protected void initialize() {
                this.initializeTextAndMnemonic("CLASS_CHOOSER_DIALOG.REFRESH_BUTTON");
            }

            @Override
            protected void execute() {
                ClassChooserDialog.this.refresh();
            }
        };
    }

    @Override
    protected Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        this.filteringPanel = new FilteringListPanel(this.shortClassNameEntries, null, new ShortClassNameEntryStringConverter());
        this.configureLabel(this.filteringPanel.getTextFieldLabel(), "CLASS_CHOOSER_DIALOG.TEXT_FIELD_LABEL");
        this.configureLabel(this.filteringPanel.getListBoxLabel(), "CLASS_CHOOSER_DIALOG.CLASS_LIST_BOX_LABEL");
        this.filteringPanel.setListBoxCellRenderer(this.buildClassListCellRenderer());
        this.filteringPanel.getListBox().getSelectionModel().addListSelectionListener(this.buildClassListSelectionListener());
        this.filteringPanel.getListBox().addMouseListener(this.doubleClickMouseListener);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 3.0;
        constraints.anchor = 19;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)this.filteringPanel, constraints);
        JPanel packageListPanel = new JPanel(new BorderLayout());
        JLabel packageListLabel = new JLabel();
        this.configureLabel(packageListLabel, "CLASS_CHOOSER_DIALOG.PACKAGE_LIST_BOX_LABEL");
        packageListLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        packageListPanel.add((Component)packageListLabel, "First");
        this.packageListBox = SwingComponentFactory.buildList();
        this.packageListBox.setDoubleBuffered(true);
        this.packageListBox.setCellRenderer(this.buildPackageListCellRenderer());
        this.packageListBox.getSelectionModel().setSelectionMode(0);
        this.packageListBox.getSelectionModel().addListSelectionListener(this.buildPackageListSelectionListener());
        this.packageListBox.addMouseListener(this.doubleClickMouseListener);
        packageListLabel.setLabelFor(this.packageListBox);
        packageListPanel.add((Component)new JScrollPane(this.packageListBox), "Center");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 20;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        mainPanel.add((Component)packageListPanel, constraints);
        return mainPanel;
    }

    private void configureLabel(JLabel label, String key) {
        label.setText(this.resourceRepository().getString(key));
        label.setDisplayedMnemonic(this.resourceRepository().getMnemonic(key));
    }

    private ListCellRenderer buildClassListCellRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected Icon buildIcon(Object value) {
                return ClassChooserDialog.this.classIcon;
            }

            @Override
            protected String buildText(Object value) {
                return ((ShortClassNameEntry)value).getName();
            }
        };
    }

    private ListSelectionListener buildClassListSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ClassChooserDialog.this.classSelectionChanged(e);
                }
            }
        };
    }

    private ListCellRenderer buildPackageListCellRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected Icon buildIcon(Object value) {
                return ClassChooserDialog.this.packageIcon;
            }

            @Override
            protected String buildText(Object value) {
                return ((PackageEntry)value).getDisplayString();
            }
        };
    }

    private ListSelectionListener buildPackageListSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ClassChooserDialog.this.packageSelectionChanged(e);
                }
            }
        };
    }

    @Override
    protected Action buildOKAction() {
        Action action = super.buildOKAction();
        action.setEnabled(false);
        return action;
    }

    @Override
    protected Iterator buildCustomActions() {
        return new SingleElementIterator((Object)this.buildRefreshAction());
    }

    @Override
    protected String helpTopicId() {
        return "dialog.classChooser";
    }

    @Override
    protected Component initialFocusComponent() {
        return this.filteringPanel.getTextField();
    }

    @Override
    protected void prepareToShow() {
        this.pack();
        Dimension size = this.getPreferredSize();
        size.width = Math.max(size.width, 350);
        size.height = Math.max(size.height, 566);
        this.setSize(size);
        this.setLocationRelativeTo(this.getParent());
        if (this.initialSelection != null) {
            this.setInitialSelectionInternal(this.initialSelection);
        }
    }

    @Override
    protected void clickOK() {
        super.clickOK();
    }

    private void setInitialSelectionInternal(Object classDescription) {
        ShortClassNameEntry[] scnEntries = this.shortClassNameEntries;
        int i = scnEntries.length;
        while (i-- > 0) {
            ShortClassNameEntry scnEntry = scnEntries[i];
            PackageEntry pEntry = scnEntry.packageEntryFor(classDescription);
            if (pEntry == null) continue;
            this.filteringPanel.setSelection(scnEntry);
            this.packageListBox.setSelectedValue(pEntry, true);
            break;
        }
    }

    void classSelectionChanged(ListSelectionEvent e) {
        Object sel = this.filteringPanel.getSelection();
        if (sel == null) {
            this.packageListBox.setListData(EMPTY_PACKAGE_LIST);
        } else {
            this.packageListBox.setListData(((ShortClassNameEntry)sel).getPackageEntries());
            this.packageListBox.getSelectionModel().setAnchorSelectionIndex(0);
            this.packageListBox.getSelectionModel().setLeadSelectionIndex(0);
        }
    }

    void packageSelectionChanged(ListSelectionEvent e) {
        this.packageListBox.ensureIndexIsVisible(e.getFirstIndex());
        this.getOKAction().setEnabled(this.allowNullSelection || this.packageListBox.getSelectedValue() != null);
    }

    void refresh() {
        this.repository.refreshClassDescriptions();
        this.shortClassNameEntries = this.buildShortClassNameEntries();
        this.filteringPanel.setCompleteList(this.shortClassNameEntries);
    }

    public void setAllowNullSelection(boolean allowNullSelection) {
        this.allowNullSelection = allowNullSelection;
    }

    public void setInitialSelection(Object classDescription) {
        this.initialSelection = classDescription;
    }

    public Object selection() {
        if (!this.wasConfirmed()) {
            throw new IllegalStateException();
        }
        PackageEntry packageEntry = (PackageEntry)this.packageListBox.getSelectedValue();
        return packageEntry == null ? null : packageEntry.getClassDescription();
    }

    public static void gc() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    return;
                }
                System.gc();
            }
        };
        t.start();
    }

    private static class PackageEntry
    implements Comparable {
        private Object classDescription;
        private String name;
        private String additionalInfo;
        private boolean displaysAdditionalInfo;
        private String displayString;
        private Collator collator;

        PackageEntry(Object classDescription, ClassDescriptionAdapter adapter, Collator collator) {
            this.classDescription = classDescription;
            this.name = adapter.packageName(classDescription);
            this.additionalInfo = adapter.additionalInfo(this.classDescription);
            this.displaysAdditionalInfo = false;
            this.displayString = this.buildDisplayString();
            this.collator = collator;
        }

        private String buildDisplayString() {
            if (!this.displaysAdditionalInfo || this.additionalInfo == null || this.additionalInfo.length() == 0) {
                return this.name;
            }
            return this.name + " - " + this.additionalInfo;
        }

        Object getClassDescription() {
            return this.classDescription;
        }

        String getName() {
            return this.name;
        }

        String getAdditionalInfo() {
            return this.additionalInfo;
        }

        boolean displaysAdditionalInfo() {
            return this.displaysAdditionalInfo;
        }

        void setDisplaysAdditionalInfo(boolean displaysAdditionalInfo) {
            if (this.displaysAdditionalInfo == displaysAdditionalInfo) {
                return;
            }
            this.displaysAdditionalInfo = displaysAdditionalInfo;
            this.displayString = this.buildDisplayString();
        }

        String getDisplayString() {
            return this.displayString;
        }

        boolean isEntryFor(Object otherClassDescription) {
            return this.classDescription == otherClassDescription;
        }

        public int compareTo(Object o) {
            int result = this.collator.compare(this.name, ((PackageEntry)o).name);
            if (result != 0) {
                return result;
            }
            return this.collator.compare(this.displayString, ((PackageEntry)o).displayString);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.displayString);
        }
    }

    private class ShortClassNameEntryStringConverter
    implements StringConverter {
        private ShortClassNameEntryStringConverter() {
        }

        public String convertToString(Object o) {
            return o == null ? null : ((ShortClassNameEntry)o).getName();
        }
    }

    private static class ShortClassNameEntry
    implements Comparable {
        private String name;
        private CollationKey collationKey;
        private PackageEntry[] packageEntries;

        ShortClassNameEntry(String name, Collator collator) {
            this.name = name;
            this.collationKey = collator.getCollationKey(name);
            this.packageEntries = new PackageEntry[1];
        }

        String getName() {
            return this.name;
        }

        PackageEntry[] getPackageEntries() {
            return this.packageEntries;
        }

        void addPackageEntry(PackageEntry packageEntry) {
            if (this.packageEntries[0] == null) {
                this.packageEntries[0] = packageEntry;
            } else {
                this.addSubsequentPackageEntry(packageEntry);
            }
        }

        private void addSubsequentPackageEntry(PackageEntry packageEntry) {
            int len;
            String packageName = packageEntry.getName();
            PackageEntry[] oldEntries = this.packageEntries;
            int i = len = oldEntries.length;
            while (i-- > 0) {
                if (!oldEntries[i].getName().equals(packageName)) continue;
                oldEntries[i].setDisplaysAdditionalInfo(true);
                packageEntry.setDisplaysAdditionalInfo(true);
            }
            Object[] newEntries = new PackageEntry[len + 1];
            System.arraycopy(oldEntries, 0, newEntries, 0, len);
            newEntries[len] = packageEntry;
            Arrays.sort(newEntries);
            this.packageEntries = newEntries;
        }

        PackageEntry packageEntryFor(Object classDescription) {
            int len;
            PackageEntry[] entries = this.packageEntries;
            int i = len = entries.length;
            while (i-- > 0) {
                if (!entries[i].isEntryFor(classDescription)) continue;
                return entries[i];
            }
            return null;
        }

        public int compareTo(Object o) {
            return this.collationKey.compareTo(((ShortClassNameEntry)o).collationKey);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.name);
        }
    }
}

