/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveTablePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractProcedureArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedure;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedureNamedInArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedureNamedInOutputArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedureNamedOutputArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedureUnamedInArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedureUnamedInOutputArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWProcedureUnamedOutputArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AddArgumentDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.CustomParameterInArgumentPane;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.CustomParameterInOutArgumentPane;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ParameterOutArgumentPane;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ValueInArgumentPane;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ValueInOutArgumentPane;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Transformer;

final class CustomStoredProcedurePropertiesPane
extends AbstractSubjectPanel {
    private PropertyValueModel selectedArgumentHolder;
    private CustomParameterInArgumentPane namedInPane;
    private ValueInArgumentPane namedInValuePane;
    private ParameterOutArgumentPane namedOutPane;
    private CustomParameterInOutArgumentPane namedInOutPane;
    private ValueInOutArgumentPane namedInOutValuePane;
    private CustomParameterInArgumentPane unnamedInPane;
    private ValueInArgumentPane unnamedInValuePane;
    private ParameterOutArgumentPane unnamedOutPane;
    private CustomParameterInOutArgumentPane unnamedInOutPane;
    private ValueInOutArgumentPane unnamedInOutValuePane;
    private PropertyValueModel useUnnamedOutputCursorHolder;

    CustomStoredProcedurePropertiesPane(PropertyValueModel procedureHolder, WorkbenchContextHolder workbenchContextHolder) {
        super((ValueModel)procedureHolder, workbenchContextHolder);
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.selectedArgumentHolder = new SimplePropertyValueModel();
        JComponent nameField = this.buildLabeledTextField("STORED_PROCEDURE_PROPERTIES_PAGE_PROCEDURE_NAME", this.buildNameDocument());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)nameField, constraints);
        JCheckBox useUnamedOutputCursorCheckbox = this.buildCheckBox("STORED_PROCEDURE_PROPERTIES_PAGE_USE_UNNAMED_OUPUT_CURSOR", this.buildUnnamedOuputCursorCheckboxModel());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)useUnamedOutputCursorCheckbox, constraints);
        JComponent outputCursorNameWidgets = this.buildLabeledTextField("STORED_PROCEDURE_PROPERTIES_PAGE_OUTPUT_CURSOR_NAME", this.buildOutputCursorNameDocument());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)outputCursorNameWidgets, constraints);
        new ComponentEnabler((ValueModel)this.buildReverseHolder(this.useUnnamedOutputCursorHolder), outputCursorNameWidgets);
        JPanel argumentPanel = new JPanel(new GridBagLayout());
        argumentPanel.setOpaque(false);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 15, 0, 0);
        this.add((Component)argumentPanel, constraints);
        AddRemoveListPanel argumentsListPane = this.buildArgumentsListPanel();
        argumentsListPane.setPreferredSize(new Dimension(175, 200));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 3;
        constraints.anchor = 19;
        constraints.insets = new Insets(1, 0, 0, 0);
        argumentPanel.add((Component)argumentsListPane, constraints);
        JPanel container = new JPanel(new GridBagLayout());
        container.setOpaque(false);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 10, 0, 0);
        argumentPanel.add((Component)container, constraints);
        JTextField typeField = new JTextField(this.buildArgumentTypeDocument(this.selectedArgumentHolder), null, 20);
        typeField.setEditable(false);
        JComponent typeWidgets = this.buildLabeledComponent("ARGUMENT_TYPE_LABEL", typeField);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(15, 0, 0, 0);
        container.add((Component)typeWidgets, constraints);
        this.initializePanes();
        SwitcherPanel argumentsPanel = new SwitcherPanel(this.selectedArgumentHolder, this.buildArgumentTypeTransformer());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 0, 0, 0);
        container.add((Component)argumentsPanel, constraints);
        Spacer endSpace = new Spacer();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 15, 0, 0);
        this.add((Component)endSpace, constraints);
    }

    protected AddRemoveListPanel buildArgumentsListPanel() {
        AddRemoveListPanel argumentsListPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildAddRemoveListPanelAdapter(), this.buildArgumentListValueModel(), this.resourceRepository().getString("ARGUMENTS_LIST"));
        argumentsListPanel.setCellRenderer(this.buildArgumentsListCellRenderer());
        argumentsListPanel.setBorder(this.buildStandardEmptyBorder());
        argumentsListPanel.addListSelectionListener(this.buildArgumentListSelectionListener());
        return argumentsListPanel;
    }

    private AddRemovePanel.Adapter buildAddRemoveListPanelAdapter() {
        return new AddRemovePanel.Adapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                CustomStoredProcedurePropertiesPane.this.promptToAddAgument(listSelectionModel);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                CustomStoredProcedurePropertiesPane.this.removeSelectedArguments(listSelectionModel);
            }
        };
    }

    protected ListSelectionListener buildArgumentListSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ObjectListSelectionModel listSelectionModel = (ObjectListSelectionModel)e.getSource();
                    Object[] values = listSelectionModel.getSelectedValues();
                    if (values.length == 1) {
                        CustomStoredProcedurePropertiesPane.this.selectedArgumentHolder.setValue(values[0]);
                    } else {
                        CustomStoredProcedurePropertiesPane.this.selectedArgumentHolder.setValue(null);
                    }
                }
            }
        };
    }

    private ListCellRenderer buildArgumentsListCellRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                if ("".equals(((MWAbstractProcedureArgument)value).getArgumentName())) {
                    return CustomStoredProcedurePropertiesPane.this.resourceRepository().getString("UNNAMED_ARGUMENT");
                }
                return ((MWAbstractProcedureArgument)value).getArgumentName();
            }
        };
    }

    private DocumentAdapter buildNameDocument() {
        return new DocumentAdapter(this.buildNameModel());
    }

    private PropertyValueModel buildNameModel() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "name"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWProcedure)this.subject).getName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWProcedure)this.subject).setName((String)value);
            }
        };
    }

    protected void promptToAddAgument(ObjectListSelectionModel listSelectionModel) {
        AddArgumentDialog.AddArgumentBuilder builder = new AddArgumentDialog.AddArgumentBuilder();
        builder.setTitle(this.resourceRepository().getString("ADD_ARGUMENT_DIALOG_TITLE"));
        builder.setTextFieldDescription("ENTER_NEW_ARGUMENT_NAME");
        builder.setHelpTopicId("dialog.addNewArgument");
        AddArgumentDialog dialog = builder.buildDialog(this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasConfirmed()) {
            AddArgumentDialog.ArgumentType argumentType = dialog.getArgumentType();
            String argumentName = dialog.getNewName();
            Object newArgument = argumentType == AddArgumentDialog.ArgumentType.NAMED_IN ? ((MWProcedure)this.subject()).addNamedInArgument(argumentName) : (argumentType == AddArgumentDialog.ArgumentType.NAMED_OUT ? ((MWProcedure)this.subject()).addNamedOutputArgument(argumentName) : (argumentType == AddArgumentDialog.ArgumentType.NAMED_IN_OUT ? ((MWProcedure)this.subject()).addNamedInOutputArgument(argumentName) : (argumentType == AddArgumentDialog.ArgumentType.UNNAMED_IN ? ((MWProcedure)this.subject()).addUnamedInArgument() : (argumentType == AddArgumentDialog.ArgumentType.UNNAMED_OUT ? ((MWProcedure)this.subject()).addUnamedOutputArgument() : ((MWProcedure)this.subject()).addUnamedInOutputArgument()))));
            if (dialog.getArgumentPassType() == AddArgumentDialog.ArgumentPassType.VALUE) {
                newArgument.setPassType("value type");
            } else {
                newArgument.setPassType("paramter type");
            }
            listSelectionModel.setSelectedValue(newArgument);
        }
    }

    protected void removeSelectedArguments(ObjectListSelectionModel listSelectionModel) {
        Iterator arguments = CollectionTools.iterator((Object[])listSelectionModel.getSelectedValues());
        while (arguments.hasNext()) {
            ((MWProcedure)this.subject()).removeArgument((MWAbstractProcedureArgument)arguments.next());
        }
    }

    private ListValueModel buildArgumentListValueModel() {
        return new CollectionListValueModelAdapter(this.buildArgumentsHolder());
    }

    private CollectionValueModel buildArgumentsHolder() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "arguments"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWProcedure)this.subject).getAllArguments();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWProcedure)this.subject).argumentsSize();
            }
        };
    }

    private void initializePanes() {
        this.namedInPane = new CustomParameterInArgumentPane(this.buildNamedInArgumentHolder(), this.getWorkbenchContextHolder());
        this.namedInValuePane = new ValueInArgumentPane(this.buildNamedInArgumentHolder(), this.getWorkbenchContextHolder());
        this.namedOutPane = new ParameterOutArgumentPane(this.buildNamedOutArgumentHolder(), this.getWorkbenchContextHolder());
        this.namedInOutPane = new CustomParameterInOutArgumentPane(this.buildNamedInOutArgumentHolder(), this.getWorkbenchContextHolder());
        this.namedInOutValuePane = new ValueInOutArgumentPane((ValueModel)this.buildNamedInOutArgumentHolder(), this.getWorkbenchContextHolder());
        this.unnamedInPane = new CustomParameterInArgumentPane(this.buildUnnamedInArgumentHolder(), this.getWorkbenchContextHolder());
        this.unnamedInValuePane = new ValueInArgumentPane(this.buildUnnamedInArgumentHolder(), this.getWorkbenchContextHolder());
        this.unnamedOutPane = new ParameterOutArgumentPane(this.buildUnnamedOutputArgumentHolder(), this.getWorkbenchContextHolder());
        this.unnamedInOutPane = new CustomParameterInOutArgumentPane(this.buildUnnamedInOutputArgumentHolder(), this.getWorkbenchContextHolder());
        this.unnamedInOutValuePane = new ValueInOutArgumentPane((ValueModel)this.buildUnnamedInOutputArgumentHolder(), this.getWorkbenchContextHolder());
    }

    private Transformer buildArgumentTypeTransformer() {
        return new Transformer(){
            private JComponent emptyPane;

            private JComponent emptyPane() {
                if (this.emptyPane == null) {
                    this.emptyPane = CustomStoredProcedurePropertiesPane.this.buildEmptyPanel();
                }
                return this.emptyPane;
            }

            private JComponent namedInPane() {
                return CustomStoredProcedurePropertiesPane.this.namedInPane;
            }

            private JComponent namedInValuePane() {
                return CustomStoredProcedurePropertiesPane.this.namedInValuePane;
            }

            private JComponent namedOutPane() {
                return CustomStoredProcedurePropertiesPane.this.namedOutPane;
            }

            private JComponent namedInOutPane() {
                return CustomStoredProcedurePropertiesPane.this.namedInOutPane;
            }

            private JComponent namedInOutValue() {
                return CustomStoredProcedurePropertiesPane.this.namedInOutValuePane;
            }

            private JComponent unnamedInPane() {
                return CustomStoredProcedurePropertiesPane.this.unnamedInPane;
            }

            private JComponent unnamedInValuePane() {
                return CustomStoredProcedurePropertiesPane.this.unnamedInValuePane;
            }

            private JComponent unnamedOutPane() {
                return CustomStoredProcedurePropertiesPane.this.unnamedOutPane;
            }

            private JComponent unnamedInOutPane() {
                return CustomStoredProcedurePropertiesPane.this.unnamedInOutPane;
            }

            private JComponent unnamedInOutValuePane() {
                return CustomStoredProcedurePropertiesPane.this.unnamedInOutValuePane;
            }

            public JComponent transform(Object argument) {
                if (argument == null) {
                    return this.emptyPane();
                }
                MWAbstractProcedureArgument procedureArg = (MWAbstractProcedureArgument)argument;
                if (procedureArg.getPassType().equals("value type")) {
                    if (procedureArg.isNamedIn()) {
                        return this.namedInValuePane();
                    }
                    if (procedureArg.isNamedInOut()) {
                        return this.namedInOutValue();
                    }
                    if (procedureArg.isUnnamedIn()) {
                        return this.unnamedInValuePane();
                    }
                    if (procedureArg.isUnnamedInOut()) {
                        return this.unnamedInOutValuePane();
                    }
                } else {
                    if (procedureArg.isNamedIn()) {
                        return this.namedInPane();
                    }
                    if (procedureArg.isNamedOut()) {
                        return this.namedOutPane();
                    }
                    if (procedureArg.isNamedInOut()) {
                        return this.namedInOutPane();
                    }
                    if (procedureArg.isUnnamedIn()) {
                        return this.unnamedInPane();
                    }
                    if (procedureArg.isUnnamedOut()) {
                        return this.unnamedOutPane();
                    }
                    if (procedureArg.isUnnamedInOut()) {
                        return this.unnamedInOutPane();
                    }
                }
                return this.emptyPane();
            }
        };
    }

    private PropertyValueModel buildNamedInArgumentHolder() {
        return new TransformationPropertyValueModel(this.selectedArgumentHolder){

            @Override
            protected Object transform(Object value) {
                return value instanceof MWProcedureNamedInArgument ? (MWProcedureNamedInArgument)value : null;
            }
        };
    }

    private PropertyValueModel buildNamedOutArgumentHolder() {
        return new TransformationPropertyValueModel(this.selectedArgumentHolder){

            @Override
            protected Object transform(Object value) {
                return value instanceof MWProcedureNamedOutputArgument ? (MWProcedureNamedOutputArgument)value : null;
            }
        };
    }

    private PropertyValueModel buildNamedInOutArgumentHolder() {
        return new TransformationPropertyValueModel(this.selectedArgumentHolder){

            @Override
            protected Object transform(Object value) {
                return value instanceof MWProcedureNamedInOutputArgument ? (MWProcedureNamedInOutputArgument)value : null;
            }
        };
    }

    private PropertyValueModel buildUnnamedInArgumentHolder() {
        return new TransformationPropertyValueModel(this.selectedArgumentHolder){

            @Override
            protected Object transform(Object value) {
                return value instanceof MWProcedureUnamedInArgument ? (MWProcedureUnamedInArgument)value : null;
            }
        };
    }

    private PropertyValueModel buildUnnamedOutputArgumentHolder() {
        return new TransformationPropertyValueModel(this.selectedArgumentHolder){

            @Override
            protected Object transform(Object value) {
                return value instanceof MWProcedureUnamedOutputArgument ? (MWProcedureUnamedOutputArgument)value : null;
            }
        };
    }

    private PropertyValueModel buildUnnamedInOutputArgumentHolder() {
        return new TransformationPropertyValueModel(this.selectedArgumentHolder){

            @Override
            protected Object transform(Object value) {
                return value instanceof MWProcedureUnamedInOutputArgument ? (MWProcedureUnamedInOutputArgument)value : null;
            }
        };
    }

    protected JComponent buildEmptyPanel() {
        JPanel container = new JPanel();
        container.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(204, 204, 204)));
        container.setOpaque(false);
        return container;
    }

    protected final Document buildArgumentTypeDocument(PropertyValueModel argumentHolder) {
        return new DocumentAdapter(this.buildArgumentTypeHolder(argumentHolder));
    }

    private PropertyValueModel buildArgumentTypeHolder(PropertyValueModel argumentHolder) {
        return new TransformationPropertyValueModel(argumentHolder){

            @Override
            protected String transform(Object argument) {
                if (argument == null || CustomStoredProcedurePropertiesPane.this.subject() == null) {
                    return CustomStoredProcedurePropertiesPane.this.resourceRepository().getString("ARGUMENT_NONE_SELECTED");
                }
                if (((MWAbstractProcedureArgument)argument).isNamedIn()) {
                    return CustomStoredProcedurePropertiesPane.this.resourceRepository().getString("ARGUMENT_NAMED_IN");
                }
                if (((MWAbstractProcedureArgument)argument).isNamedOut()) {
                    return CustomStoredProcedurePropertiesPane.this.resourceRepository().getString("ARGUMENT_NAMED_OUT");
                }
                if (((MWAbstractProcedureArgument)argument).isNamedInOut()) {
                    return CustomStoredProcedurePropertiesPane.this.resourceRepository().getString("ARGUMENT_NAMED_IN_OUT");
                }
                if (((MWAbstractProcedureArgument)argument).isUnnamedIn()) {
                    return CustomStoredProcedurePropertiesPane.this.resourceRepository().getString("ARGUMENT_UNNAMED_IN");
                }
                if (((MWAbstractProcedureArgument)argument).isUnnamedOut()) {
                    return CustomStoredProcedurePropertiesPane.this.resourceRepository().getString("ARGUMENT_UNNAMED_OUT");
                }
                return CustomStoredProcedurePropertiesPane.this.resourceRepository().getString("ARGUMENT_UNNAMED_IN_OUT");
            }
        };
    }

    private CheckBoxModelAdapter buildUnnamedOuputCursorCheckboxModel() {
        this.useUnnamedOutputCursorHolder = this.buildUnnamedOutputCursorCheckboxModel();
        return new CheckBoxModelAdapter(this.useUnnamedOutputCursorHolder);
    }

    private PropertyValueModel buildUnnamedOutputCursorCheckboxModel() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "useUnamedCursorOutput"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWProcedure)this.subject).getUseUnamedCursorOutput();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWProcedure)this.subject).setUseUnamedCursorOutput((Boolean)value);
            }
        };
    }

    private PropertyValueModel buildReverseHolder(PropertyValueModel holder) {
        return new TransformationPropertyValueModel(holder){

            @Override
            protected Object transform(Object value) {
                if (value == null) {
                    return null;
                }
                if (((Boolean)value).booleanValue()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        };
    }

    private DocumentAdapter buildOutputCursorNameDocument() {
        return new DocumentAdapter(this.buildOutputCursorNameModel());
    }

    private PropertyValueModel buildOutputCursorNameModel() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "cursorOutputName"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWProcedure)this.subject).getCursorOutputName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWProcedure)this.subject).setCursorOutputName((String)value);
            }
        };
    }

    private void selectNewArgument(AddRemoveTablePanel tablePane, ObjectListSelectionModel listSelectionModel, MWAbstractProcedureArgument argument, int count) {
        listSelectionModel.setSelectedValue(argument);
    }
}

