/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaComplexTypeChooserDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaValue;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class SchemaComplexTypeChooser
extends AbstractPanel {
    private SchemaValue schemaValue;
    private PropertyValueModel complexTypeHolder;
    private ComplexTypeDisplayStringValueModel complexTypeDisplayStringHolder;

    public SchemaComplexTypeChooser(WorkbenchContextHolder contextHolder, SchemaValue schemaValue, PropertyValueModel complexTypeHolder, JLabel label) {
        super(contextHolder);
        this.initialize(schemaValue, complexTypeHolder, label);
    }

    private void initialize(SchemaValue schemaValue, PropertyValueModel complexTypeHolder, JLabel label) {
        this.schemaValue = schemaValue;
        this.complexTypeHolder = complexTypeHolder;
        this.complexTypeDisplayStringHolder = this.buildComplexTypeDisplayStringHolder();
        this.initializeLayout(label);
    }

    private ComplexTypeDisplayStringValueModel buildComplexTypeDisplayStringHolder() {
        return new ComplexTypeDisplayStringValueModel(this.complexTypeHolder);
    }

    private void initializeLayout(JLabel label) {
        GridBagConstraints constraints = new GridBagConstraints();
        JTextField textField = this.buildTextField();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)textField, constraints);
        textField.putClientProperty("labeledBy", label);
        JButton button = this.buildButton();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.addAlignRight(button);
        label.setLabelFor(button);
        SwingComponentFactory.updateButtonAccessibleName(label, button);
        this.add((Component)button, constraints);
    }

    private JTextField buildTextField() {
        JTextField textField = new JTextField(this.buildComplexTypeDisplayStringDocument(), null, 1);
        textField.setEditable(true);
        textField.setEnabled(true);
        return textField;
    }

    private DocumentAdapter buildComplexTypeDisplayStringDocument() {
        return new DocumentAdapter(this.complexTypeDisplayStringHolder);
    }

    private JButton buildButton() {
        JButton button = this.buildButton("SCHEMA_COMPLEX_TYPE_CHOOSER_BROWSE_BUTTON");
        button.addActionListener(this.buildBrowseAction());
        return button;
    }

    private ActionListener buildBrowseAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SchemaComplexTypeChooser.this.promptToComplexTypeElement();
            }
        };
    }

    private void promptToComplexTypeElement() {
        SchemaComplexTypeChooserDialog dialog = new SchemaComplexTypeChooserDialog(this.getWorkbenchContext(), this.schemaValue.schema(), this.complexTypeHolder);
        dialog.show();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Iterator stream = CollectionTools.iterator((Object[])this.getComponents());
        while (stream.hasNext()) {
            ((Component)stream.next()).setEnabled(enabled);
        }
    }

    private class ComplexTypeDisplayStringValueModel
    extends PropertyValueModelWrapper {
        private String displayString;
        private PropertyChangeListener propertyChangeListener;
        private MWNamespace namespace;

        private ComplexTypeDisplayStringValueModel(PropertyValueModel complexTypeHolder) {
            super(complexTypeHolder);
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.propertyChangeListener = this.buildPropertyChangeListener();
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ComplexTypeDisplayStringValueModel.this.displayStringChanged();
                }
            };
        }

        private MWComplexTypeDefinition type() {
            return (MWComplexTypeDefinition)this.valueHolder.getValue();
        }

        private void displayStringChanged() {
            Object oldValue = this.getValue();
            this.synchronizeDisplayString();
            Object newValue = this.getValue();
            this.firePropertyChanged("value", oldValue, newValue);
        }

        private void synchronizeDisplayString() {
            this.displayString = this.type() == null ? SchemaComplexTypeChooser.this.resourceRepository().getString("SCHEMA_COMPLEX_TYPE_CHOOSER_NONE_SELECTED_TEXT") : this.buildDisplayString(this.type());
        }

        private String buildDisplayString(MWComplexTypeDefinition element) {
            return element.qName();
        }

        private void engageNewType() {
            if (this.type() != null) {
                this.namespace = this.type().getTargetNamespace();
                this.namespace.addPropertyChangeListener("namespacePrefix", this.propertyChangeListener);
            }
        }

        private void disengageOldType() {
            if (this.namespace != null) {
                this.namespace.removePropertyChangeListener("namespacePrefix", this.propertyChangeListener);
                this.namespace = null;
            }
        }

        @Override
        public Object getValue() {
            return this.displayString;
        }

        @Override
        public void setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void engageValueHolder() {
            super.engageValueHolder();
            this.engageNewType();
            this.synchronizeDisplayString();
        }

        @Override
        protected void disengageValueHolder() {
            this.disengageOldType();
            super.disengageValueHolder();
            this.synchronizeDisplayString();
        }

        @Override
        protected void valueChanged(PropertyChangeEvent e) {
            this.disengageOldType();
            this.engageNewType();
            this.displayStringChanged();
        }
    }
}

