/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.broker;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.broker.SessionsListDialog;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.AbstractSessionsListPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.SessionCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;

final class SessionsListPane
extends AbstractSessionsListPane {
    SessionsListPane(PropertyValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    @Override
    protected void addNewSession() {
        CollectionValueModel itemHolder = this.buildUnmanagedSessionsCollectionHolder();
        ObjectListSelectionModel selectionModel = this.buildSelectionModel(itemHolder);
        SessionsListDialog dialog = new SessionsListDialog(this.getWorkbenchContext(), itemHolder, selectionModel, this.buildLabelDecorator());
        dialog.setVisible(true);
        if (dialog.wasCanceled()) {
            return;
        }
        Iterator iter = CollectionTools.iterator((Object[])selectionModel.getSelectedValues());
        while (iter.hasNext()) {
            SessionBrokerAdapter sessionBroker = (SessionBrokerAdapter)this.subject();
            SessionAdapter session = (SessionAdapter)iter.next();
            sessionBroker.manage(session.getName());
        }
    }

    private CellRendererAdapter buildLabelDecorator() {
        return new SessionCellRendererAdapter(this.resourceRepository());
    }

    private ObjectListSelectionModel buildSelectionModel(CollectionValueModel itemHolder) {
        ListModelAdapter adapter = new ListModelAdapter(itemHolder);
        return new ObjectListSelectionModel(adapter);
    }

    @Override
    protected AddRemoveListPanel buildSessionListPane() {
        AddRemoveListPanel panel = super.buildSessionListPane();
        this.registerListenerToUpdateAddButtonEnableState(panel);
        return panel;
    }

    @Override
    protected CollectionValueModel buildSessionsCollectionHolder() {
        return new CollectionAspectAdapter(this.getSubjectHolder(), "sessions"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((SessionBrokerAdapter)this.subject).sessions();
            }

            @Override
            protected int sizeFromSubject() {
                return ((SessionBrokerAdapter)this.subject).sessionsSize();
            }
        };
    }

    private CollectionValueModel buildUnmanagedSessionsCollectionHolder() {
        Iterator iterator = this.buildUnmanagedSessionsIterator();
        return new ReadOnlyCollectionValueModel(CollectionTools.collection((Iterator)iterator));
    }

    private Iterator buildUnmanagedSessionsIterator() {
        SessionBrokerAdapter broker = (SessionBrokerAdapter)this.subject();
        TopLinkSessionsAdapter topLinkSessions = (TopLinkSessionsAdapter)broker.getParent();
        return topLinkSessions.databaseSessions();
    }

    private void registerListenerToUpdateAddButtonEnableState(final AddRemoveListPanel panel) {
        PropertyAspectAdapter parentHolder = new PropertyAspectAdapter(this.getSubjectHolder(), ""){

            @Override
            protected Object getValueFromSubject() {
                SessionBrokerAdapter broker = (SessionBrokerAdapter)this.subject;
                return broker.getParent();
            }
        };
        CollectionAspectAdapter collectionHolder = new CollectionAspectAdapter(parentHolder, "sessions"){

            @Override
            protected Iterator getValueFromSubject() {
                TopLinkSessionsAdapter topLinkSessions = (TopLinkSessionsAdapter)this.subject;
                return topLinkSessions.databaseSessions();
            }
        };
        collectionHolder.addCollectionChangeListener("value", new CollectionChangeListener(){

            public void collectionChanged(CollectionChangeEvent e) {
                SessionsListPane.this.updateAddButtonEnableState(panel);
            }

            public void itemsAdded(CollectionChangeEvent e) {
                SessionsListPane.this.updateAddButtonEnableState(panel);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                SessionsListPane.this.updateAddButtonEnableState(panel);
            }
        });
        this.updateAddButtonEnableState(panel);
    }

    @Override
    protected void removeSessions(Collection sessions) {
        SessionBrokerAdapter broker = (SessionBrokerAdapter)this.subject();
        broker.unManage(sessions);
    }

    private void updateAddButtonEnableState(AddRemoveListPanel panel) {
        SessionBrokerAdapter broker = (SessionBrokerAdapter)this.subject();
        if (broker != null) {
            TopLinkSessionsAdapter topLinkSessions = (TopLinkSessionsAdapter)broker.getParent();
            boolean enabled = topLinkSessions.databaseSessionsSize() > 0;
            panel.setAddButtonEnabled(enabled);
        }
    }
}

