/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class ClassDeclaration {
    private ConstantPool constantPool;
    private short accessFlags;
    private short standardAccessFlags;
    private short thisClassIndex;
    private short superClassIndex;
    private short interfacesCount;
    private short[] interfaceIndexes;
    public static final short ACC_SUPER = 32;
    public static final short ACC_SYNTHETIC = 4096;
    public static final short ACC_ANNOTATION = 8192;
    public static final short ACC_ENUM = 16384;
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int VISIBLE_ACCESS_FLAGS_MASK = 3615;

    ClassDeclaration(ClassFileDataInputStream stream, ConstantPool constantPool) throws IOException {
        this.constantPool = constantPool;
        this.initialize(stream);
    }

    private void initialize(ClassFileDataInputStream stream) throws IOException {
        this.accessFlags = stream.readU2();
        this.standardAccessFlags = this.buildStandardAccessFlags();
        this.thisClassIndex = stream.readU2();
        this.superClassIndex = stream.readU2();
        short cnt = this.interfacesCount = stream.readU2();
        short[] indexes = this.interfaceIndexes = new short[cnt];
        for (short i = 0; i < cnt; i = (short)(i + 1)) {
            indexes[i] = stream.readU2();
        }
    }

    private short buildStandardAccessFlags() {
        short result = this.accessFlags;
        result = (short)(result & 0xE1F);
        return result;
    }

    void setStandardAccessFlagsForNestedClass(short flags) {
        this.standardAccessFlags = flags;
    }

    public String displayString() {
        StringWriter sw = new StringWriter();
        IndentingPrintWriter writer = new IndentingPrintWriter(sw);
        this.displayStringOn(writer);
        return sw.toString();
    }

    public void displayStringOn(IndentingPrintWriter writer) {
        writer.println("Declaration:");
        writer.indent();
        this.printDeclarationOn(writer);
        writer.undent();
        writer.println();
    }

    public void printDeclarationOn(PrintWriter writer) {
        short cnt;
        String modifierString = this.modifierString();
        if (modifierString.length() != 0) {
            writer.print(modifierString);
            writer.print(' ');
        }
        if (this.isClass()) {
            writer.print("class ");
        }
        writer.print(this.thisClassName());
        if (this.isClass()) {
            writer.print(" extends ");
            writer.print(this.superClassName());
        }
        if ((cnt = this.interfacesCount) != 0) {
            if (this.isClass()) {
                writer.print(" implements ");
            } else {
                writer.print(" extends ");
            }
            for (short i = 0; i < cnt; i = (short)(i + 1)) {
                if (i != 0) {
                    writer.write(", ");
                }
                writer.write(this.interfaceName(i));
            }
        }
    }

    public String modifierString() {
        return Modifier.toString(this.standardAccessFlags);
    }

    public short standardAccessFlags() {
        return this.standardAccessFlags;
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.accessFlags);
    }

    public boolean isClass() {
        return !this.isInterface();
    }

    public boolean isSuper() {
        return (this.accessFlags & 0x20) != 0;
    }

    public boolean isSynthetic() {
        return (this.accessFlags & 0x1000) != 0;
    }

    public boolean isAnnotation() {
        return (this.accessFlags & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.accessFlags & 0x4000) != 0;
    }

    public String thisClassName() {
        return this.className(this.thisClassIndex);
    }

    public String superClassName() {
        if (this.isInterface()) {
            return null;
        }
        short index = this.superClassIndex;
        return index == 0 ? null : this.className(index);
    }

    public String interfaceName(int index) {
        return this.className(this.interfaceIndexes[index]);
    }

    public String[] interfaceNames() {
        short count = this.interfacesCount;
        if (count == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] interfaceNames = new String[count];
        for (short i = 0; i < count; i = (short)(i + 1)) {
            interfaceNames[i] = this.interfaceName(i);
        }
        return interfaceNames;
    }

    private String className(short index) {
        return this.constantPool.getClassConstant(index).name();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public short getAccessFlags() {
        return this.accessFlags;
    }

    public short getThisClassIndex() {
        return this.thisClassIndex;
    }

    public short getSuperClassIndex() {
        return this.superClassIndex;
    }

    public short getInterfacesCount() {
        return this.interfacesCount;
    }

    public short[] getInterfaceIndexes() {
        return this.interfaceIndexes;
    }

    public short getInterfaceIndex(int index) {
        return this.interfaceIndexes[index];
    }

    public String toString() {
        StringWriter sw = new StringWriter(200);
        PrintWriter pw = new PrintWriter(sw);
        pw.print(ClassTools.shortClassNameForObject(this));
        pw.print('(');
        this.printDeclarationOn(pw);
        pw.print(')');
        return sw.toString();
    }
}

