/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.log;

import java.io.File;
import java.util.logging.FileHandler;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class FileHandlerCleanup
implements Runnable {
    private FileHandler fileHandler;
    private String lockFileName;

    public static void register(FileHandler fileHandler) {
        Runtime.getRuntime().addShutdownHook(FileHandlerCleanup.buildFileHandlerCleanupThread(fileHandler));
    }

    private static Thread buildFileHandlerCleanupThread(FileHandler fileHandler) {
        return new Thread((Runnable)new FileHandlerCleanup(fileHandler), "File Handler Cleanup");
    }

    private FileHandlerCleanup(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
        this.initialize();
    }

    private void initialize() {
        this.lockFileName = (String)ClassTools.getFieldValue(this.fileHandler, "lockFileName");
    }

    @Override
    public void run() {
        this.fileHandler.close();
        new File(this.lockFileName).delete();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.lockFileName);
    }
}

