/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.deferred.CompositeCollectionMappingContentHandler;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLCompositeCollectionMappingNodeValue
extends XMLRelationshipMappingNodeValue
implements ContainerValue {
    private XMLCompositeCollectionMapping xmlCompositeCollectionMapping;
    private int index = -1;

    public XMLCompositeCollectionMappingNodeValue(XMLCompositeCollectionMapping xmlCompositeCollectionMapping) {
        this.xmlCompositeCollectionMapping = xmlCompositeCollectionMapping;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        if (this.xmlCompositeCollectionMapping.isReadOnly()) {
            return false;
        }
        Object collection = this.xmlCompositeCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (collection == null) {
            AbstractNullPolicy wrapperNP = this.xmlCompositeCollectionMapping.getWrapperNullPolicy();
            if (wrapperNP != null && wrapperNP.getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                marshalRecord.nilSimple(namespaceResolver);
                return true;
            }
            return false;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iterator = cp.iteratorFor(collection);
        if (iterator == null || !cp.hasNext(iterator)) {
            return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, this.xmlCompositeCollectionMapping.getWrapperNullPolicy() != null);
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        marshalRecord.closeStartGroupingElements(groupingFragment);
        marshalRecord.startCollection();
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        marshalRecord.endCollection();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        try {
            AbstractNullPolicy nullPolicy;
            XMLDescriptor xmlDescriptor = (XMLDescriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor();
            if (xmlDescriptor == null) {
                xmlDescriptor = this.findReferenceDescriptor(xPathFragment, unmarshalRecord, atts, this.xmlCompositeCollectionMapping, this.xmlCompositeCollectionMapping.getKeepAsElementPolicy());
                if (xmlDescriptor == null) {
                    QName leafType;
                    if (this.xmlCompositeCollectionMapping.getNullPolicy().isNullRepresentedByXsiNil()) {
                        if (unmarshalRecord.isNil()) {
                            this.getContainerPolicy().addInto(null, unmarshalRecord.getContainerInstance(this), unmarshalRecord.getSession());
                            return true;
                        }
                    } else if (this.xmlCompositeCollectionMapping.getNullPolicy().valueIsNull(atts)) {
                        this.getContainerPolicy().addInto(null, unmarshalRecord.getContainerInstance(this), unmarshalRecord.getSession());
                        return true;
                    }
                    if (this.xmlCompositeCollectionMapping.getField() != null && (leafType = ((XMLField)this.xmlCompositeCollectionMapping.getField()).getLastXPathFragment().getLeafElementType()) != null) {
                        XPathFragment frag = new XPathFragment();
                        frag.setNamespaceAware(unmarshalRecord.isNamespaceAware());
                        String xpath = leafType.getLocalPart();
                        String uri = leafType.getNamespaceURI();
                        if (uri != null && uri.length() > 0) {
                            frag.setNamespaceURI(uri);
                            String prefix = ((XMLDescriptor)this.xmlCompositeCollectionMapping.getDescriptor()).getNonNullNamespaceResolver().resolveNamespaceURI(uri);
                            if (prefix != null && prefix.length() > 0) {
                                xpath = String.valueOf(prefix) + ':' + xpath;
                            }
                        }
                        frag.setXPath(xpath);
                        XMLContext xmlContext = unmarshalRecord.getUnmarshaller().getXMLContext();
                        xmlDescriptor = xmlContext.getDescriptorByGlobalType(frag);
                    }
                }
                UnmarshalKeepAsElementPolicy policy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy();
                if (xmlDescriptor == null && policy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || policy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
                    if (unmarshalRecord.getTypeQName() == null) {
                        this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                        return true;
                    }
                    XMLConversionManager cfr_ignored_0 = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
                    Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(unmarshalRecord.getTypeQName());
                    if (theClass == null) {
                        this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                        return true;
                    }
                }
            }
            if ((nullPolicy = this.xmlCompositeCollectionMapping.getNullPolicy()).isNullRepresentedByEmptyNode()) {
                String qnameString = xPathFragment.getLocalName();
                if (xPathFragment.getPrefix() != null) {
                    qnameString = String.valueOf(xPathFragment.getPrefix()) + ':' + qnameString;
                }
                if (xmlDescriptor == null) return true;
                CompositeCollectionMappingContentHandler aHandler = new CompositeCollectionMappingContentHandler(unmarshalRecord, this, this.xmlCompositeCollectionMapping, atts, xPathFragment, xmlDescriptor);
                aHandler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), qnameString, atts);
                XMLReader xmlReader = unmarshalRecord.getXMLReader();
                xmlReader.setContentHandler(aHandler);
                xmlReader.setLexicalHandler(aHandler);
                return true;
            }
            if (nullPolicy.isNullRepresentedByXsiNil() && unmarshalRecord.isNil()) {
                this.getContainerPolicy().addInto(null, unmarshalRecord.getContainerInstance(this), unmarshalRecord.getSession());
                return true;
            }
            XMLField xmlFld = (XMLField)this.xmlCompositeCollectionMapping.getField();
            if (xmlFld.hasLastXPathFragment()) {
                unmarshalRecord.setLeafElementType(xmlFld.getLastXPathFragment().getLeafElementType());
            }
            this.processChild(xPathFragment, unmarshalRecord, atts, xmlDescriptor, this.xmlCompositeCollectionMapping);
            return true;
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        Object collection = unmarshalRecord.getContainerInstance(this);
        this.endElement(xPathFragment, unmarshalRecord, collection);
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Object collection) {
        if (unmarshalRecord.isNil() && this.xmlCompositeCollectionMapping.getNullPolicy().isNullRepresentedByXsiNil()) {
            unmarshalRecord.resetStringBuffer();
            return;
        }
        if (unmarshalRecord.getChildRecord() == null) {
            SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
            UnmarshalKeepAsElementPolicy keepAsElementPolicy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy();
            if ((keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && builder.getNodes().size() > 1) {
                if (unmarshalRecord.getTypeQName() != null) {
                    XMLConversionManager cfr_ignored_0 = (XMLConversionManager)unmarshalRecord.getSession().getDatasourcePlatform().getConversionManager();
                    Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(unmarshalRecord.getTypeQName());
                    if (theClass != null) {
                        this.endElementProcessText(unmarshalRecord, this.xmlCompositeCollectionMapping.getConverter(), xPathFragment, collection);
                        return;
                    }
                }
                if (builder.getNodes().size() > 1) {
                    this.setOrAddAttributeValueForKeepAsElement(builder, this.xmlCompositeCollectionMapping, (XMLConverter)this.xmlCompositeCollectionMapping.getConverter(), unmarshalRecord, true, collection);
                    return;
                }
            } else {
                this.endElementProcessText(unmarshalRecord, this.xmlCompositeCollectionMapping.getConverter(), xPathFragment, collection);
                return;
            }
            return;
        }
        Object objectValue = unmarshalRecord.getChildRecord().getCurrentObject();
        if (this.xmlCompositeCollectionMapping.hasConverter()) {
            Converter converter = this.xmlCompositeCollectionMapping.getConverter();
            objectValue = converter instanceof XMLConverter ? ((XMLConverter)converter).convertDataValueToObjectValue(objectValue, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller()) : converter.convertObjectValueToDataValue(objectValue, unmarshalRecord.getSession());
        }
        unmarshalRecord.addAttributeValue(this, objectValue, collection);
        XMLInverseReferenceMapping inverseReferenceMapping = this.xmlCompositeCollectionMapping.getInverseReferenceMapping();
        if (inverseReferenceMapping != null) {
            if (inverseReferenceMapping.getContainerPolicy() == null) {
                inverseReferenceMapping.getAttributeAccessor().setAttributeValueInObject(objectValue, unmarshalRecord.getCurrentObject());
            } else {
                Object backpointerContainer = inverseReferenceMapping.getAttributeAccessor().getAttributeValueFromObject(objectValue);
                if (backpointerContainer == null) {
                    backpointerContainer = inverseReferenceMapping.getContainerPolicy().containerInstance();
                    inverseReferenceMapping.getAttributeAccessor().setAttributeValueInObject(objectValue, backpointerContainer);
                }
                inverseReferenceMapping.getContainerPolicy().addInto(unmarshalRecord.getCurrentObject(), backpointerContainer, unmarshalRecord.getSession());
            }
        }
        unmarshalRecord.setChildRecord(null);
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCompositeCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.xmlCompositeCollectionMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Class<?> objectValueClass;
        XMLMarshaller marshaller = marshalRecord.getMarshaller();
        Converter converter = this.xmlCompositeCollectionMapping.getConverter();
        if (converter != null) {
            value = converter instanceof XMLConverter ? ((XMLConverter)converter).convertObjectValueToDataValue(value, session, marshaller) : converter.convertObjectValueToDataValue(value, session);
        }
        if (value == null) {
            return this.xmlCompositeCollectionMapping.getNullPolicy().compositeObjectMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
        }
        XMLDescriptor descriptor = (XMLDescriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor();
        if (descriptor == null) {
            descriptor = (XMLDescriptor)session.getDescriptor(value.getClass());
        } else if (descriptor.hasInheritance() && (objectValueClass = value.getClass()) != descriptor.getJavaClass()) {
            descriptor = (XMLDescriptor)session.getDescriptor(objectValueClass);
        }
        UnmarshalKeepAsElementPolicy keepAsElementPolicy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy();
        if ((keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || keepAsElementPolicy == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) && value instanceof Node) {
            marshalRecord.node((Node)value, marshalRecord.getNamespaceResolver());
            return true;
        }
        if (descriptor != null) {
            marshalRecord.beforeContainmentMarshal(value);
            TreeObjectBuilder objectBuilder = (TreeObjectBuilder)descriptor.getObjectBuilder();
            this.xPathNode.startElement(marshalRecord, xPathFragment, object, session, namespaceResolver, objectBuilder, value);
            List extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session, true, false);
            this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
            objectBuilder.addXsiTypeAndClassIndicatorIfRequired(marshalRecord, descriptor, (XMLDescriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor(), (XMLField)this.xmlCompositeCollectionMapping.getField(), false);
            objectBuilder.buildRow(marshalRecord, value, session, marshaller, xPathFragment, DatabaseMapping.WriteType.UNDEFINED);
            marshalRecord.afterContainmentMarshal(object, value);
            marshalRecord.endElement(xPathFragment, namespaceResolver);
            objectBuilder.removeExtraNamespacesFromNamespaceResolver(marshalRecord, extraNamespaces, session);
        } else {
            this.xPathNode.startElement(marshalRecord, xPathFragment, object, session, namespaceResolver, null, value);
            QName schemaType = ((XMLField)this.xmlCompositeCollectionMapping.getField()).getSchemaTypeForValue(value, session);
            this.updateNamespaces(schemaType, marshalRecord, (XMLField)this.xmlCompositeCollectionMapping.getField());
            marshalRecord.characters(schemaType, value, null, false);
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
        return true;
    }

    @Override
    public XMLCompositeCollectionMapping getMapping() {
        return this.xmlCompositeCollectionMapping;
    }

    @Override
    protected void setOrAddAttributeValue(UnmarshalRecord unmarshalRecord, Object value, XPathFragment xPathFragment, Object collection) {
        unmarshalRecord.addAttributeValue(this, value, collection);
    }

    @Override
    public boolean getReuseContainer() {
        return this.xmlCompositeCollectionMapping.getReuseContainer();
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.xmlCompositeCollectionMapping.isDefaultEmptyContainer();
    }
}

