/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model;

import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.model.IJPQLQueryFormatter;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObjectVisitor;

public abstract class BaseJPQLQueryFormatter
implements StateObjectVisitor,
IJPQLQueryFormatter {
    protected final IJPQLQueryFormatter.IdentifierStyle style;
    protected final StringBuilder writer;
    protected static final String COMMA = ",";
    protected static final String COMMA_SPACE = ", ";
    protected static final String LEFT_PARENTHESIS = "(";
    protected static final String RIGHT_PARENTHESIS = ")";
    protected static final String SPACE = " ";

    protected BaseJPQLQueryFormatter(IJPQLQueryFormatter.IdentifierStyle style) {
        Assert.isNotNull((Object)style, "The IdentifierStyle cannot be null");
        this.style = style;
        this.writer = new StringBuilder();
    }

    protected String formatIdentifier(String identifier) {
        return this.style.formatIdentifier(identifier);
    }

    public IJPQLQueryFormatter.IdentifierStyle getIdentifierStyle() {
        return this.style;
    }

    public String toString() {
        return this.writer.toString();
    }

    public String toString(StateObject stateObject) {
        this.writer.delete(0, this.writer.length());
        stateObject.accept(this);
        return this.writer.toString();
    }

    protected void toText(StateObject stateObject) {
        if (stateObject.isDecorated()) {
            StateObject decorator = stateObject.getDecorator();
            stateObject.decorate(null);
            try {
                decorator.accept(this);
            }
            finally {
                stateObject.decorate(decorator);
            }
        } else {
            stateObject.accept(this);
        }
    }
}

