/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class StoredProcWithOutputParamsAndResultSetTest
extends TestCase {
    boolean useCustomSQL;
    boolean shouldBindAllParameters;
    boolean shouldBindAllParametersOriginal;

    public StoredProcWithOutputParamsAndResultSetTest(boolean useCustomSQL, boolean shouldBindAllParameters) {
        this.useCustomSQL = useCustomSQL;
        this.shouldBindAllParameters = shouldBindAllParameters;
        if (useCustomSQL) {
            this.setName(this.getName() + " customSQL");
        } else {
            this.setName(this.getName() + " storedProc");
        }
        if (shouldBindAllParameters) {
            this.setName(this.getName() + " Bind");
        } else {
            this.setName(this.getName() + " don'tBind");
        }
    }

    public void setup() {
        this.shouldBindAllParametersOriginal = this.getSession().getLogin().getShouldBindAllParameters();
        if (!(this.getSession().getPlatform().isSQLServer() || this.getSession().getPlatform().isSybase() || this.getSession().getPlatform().isSQLAnywhere())) {
            throw new TestWarningException("This test can only be run in SQLServer. Or Sybase or SQLAnywhere");
        }
        this.getSession().getLogin().setShouldBindAllParameters(this.shouldBindAllParameters);
    }

    public void test() {
        Vector vResult;
        StoredProcedureCall spCall;
        StoredProcedureCall call;
        boolean useInOut;
        ReadAllQuery readQuery = new ReadAllQuery(Employee.class);
        boolean bl = useInOut = this.getSession().getPlatform().isSybase() || this.getSession().getPlatform().isSQLAnywhere();
        if (this.useCustomSQL) {
            String prefix = useInOut ? "####" : "###";
            String parameterNamePrefix = this.getSession().getPlatform().getStoredProcedureParameterPrefix();
            SQLCall sqlCall = new SQLCall("EXECUTE Select_Output_and_ResultSet " + parameterNamePrefix + "ARG1 = #argument, " + parameterNamePrefix + "VERSION = " + prefix + "version " + this.getSession().getPlatform().getOutputProcedureToken());
            sqlCall.setCustomSQLArgumentType("version", BigDecimal.class);
            call = sqlCall;
        } else {
            spCall = new StoredProcedureCall();
            spCall.setProcedureName("Select_Output_and_ResultSet");
            spCall.addNamedArgument("ARG1", "argument");
            if (useInOut) {
                spCall.addNamedInOutputArgumentValue("VERSION", (Object)new Long(0L), "VERSION", BigDecimal.class);
            } else {
                spCall.addNamedOutputArgument("VERSION", "VERSION", BigDecimal.class);
            }
            call = spCall;
        }
        call.setReturnsResultSet(true);
        readQuery.setCall((Call)call);
        readQuery.addArgument("argument");
        if (this.useCustomSQL && useInOut) {
            readQuery.addArgument("version");
        }
        this.getSession().removeQuery("dblogin");
        this.getSession().addQuery("dblogin", (DatabaseQuery)readQuery);
        Vector<Number> args = new Vector<Number>(2);
        args.addElement(new Integer(1));
        if (this.useCustomSQL && useInOut) {
            args.addElement(new Long(0L));
        }
        try {
            vResult = (Vector)this.getSession().executeQuery("dblogin", args);
        }
        catch (ClassCastException e) {
            throw new TestErrorException("Stored Procedure is returning a Row and the query expects a Vector");
        }
        readQuery = new ReadAllQuery(Employee.class);
        if (this.useCustomSQL) {
            return;
        }
        spCall = new StoredProcedureCall();
        spCall.setProcedureName("Select_Output_and_ResultSet");
        spCall.addNamedArgumentValue("ARG1", (Object)new Integer(1));
        if (useInOut) {
            spCall.addNamedInOutputArgumentValue("VERSION", (Object)new Long(0L), "VERSION", BigDecimal.class);
        } else {
            spCall.addNamedOutputArgument("VERSION", "VERSION", BigDecimal.class);
        }
        call = spCall;
        call.setReturnsResultSet(true);
        readQuery.setCall((Call)call);
        try {
            vResult = (Vector)this.getSession().executeQuery((DatabaseQuery)readQuery);
        }
        catch (ClassCastException e) {
            throw new TestErrorException("Stored Procedure is returning a Row and the query expects a Vector");
        }
    }

    public void reset() {
        this.getSession().getLogin().setShouldBindAllParameters(this.shouldBindAllParametersOriginal);
    }
}

