/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedcache;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.employee.domain.Child;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.tests.distributedcache.DistributedCacheMergeTest;

public class OrderedListMergeTest
extends DistributedCacheMergeTest {
    @Override
    protected void modifyCollection(UnitOfWork uow, Object objectToModify) {
        Child newChildWC = (Child)uow.registerNewObject(this.newItemForCollection());
        ((Employee)objectToModify).children.add(newChildWC);
        newChildWC.parent = (Employee)objectToModify;
    }

    @Override
    protected int getCollectionSize(Object rootObject) {
        return ((Employee)rootObject).children.size();
    }

    @Override
    protected Object buildOriginalObject() {
        Employee emp = new Employee();
        emp.setFirstName("Sally");
        emp.setLastName("Hamilton");
        emp.setFemale();
        Vector<Child> children = new Vector<Child>();
        Calendar cal = Calendar.getInstance();
        Child child = new Child();
        child.setFirstName("Sarah");
        child.setLastName("Hamilton");
        cal.set(2005, 8, 8);
        child.setBirthday(new Date(cal.getTimeInMillis()));
        child.setGender("Female");
        child.setParent(emp);
        children.add(child);
        child = new Child();
        child.setFirstName("Billy");
        child.setLastName("Hamilton");
        cal.set(2006, 8, 8);
        child.setBirthday(new Date(cal.getTimeInMillis()));
        child.setGender("Male");
        child.setParent(emp);
        children.add(child);
        child = new Child();
        child.setFirstName("Samantha");
        child.setLastName("Hamilton");
        cal.set(2007, 8, 8);
        child.setBirthday(new Date(cal.getTimeInMillis()));
        child.setGender("Female");
        child.setParent(emp);
        children.add(child);
        emp.children = children;
        return emp;
    }

    protected Object newItemForCollection() {
        Child child = new Child();
        child.firstName = "Susy";
        child.lastName = "Hamilton";
        child.birthday = new Date(System.currentTimeMillis());
        child.gender = "Female";
        return child;
    }

    @Override
    protected Project getNewProject() {
        EmployeeProject empProject = new EmployeeProject();
        empProject.getDescriptor(Employee.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        return empProject;
    }

    protected boolean compareObjectsCollections(Object object1, Object object2) {
        if (this.getCollectionSize(object1) != this.getCollectionSize(object2)) {
            return false;
        }
        return this.compareCollections(((Employee)object1).children, ((Employee)object2).children);
    }

    protected boolean compareCollections(Collection col1, Collection col2) {
        boolean comparison = true;
        Iterator i1 = col1.iterator();
        Iterator i2 = col2.iterator();
        while (comparison && i1.hasNext()) {
            Object o = i1.next();
            comparison = o.equals(i2.next());
        }
        return comparison;
    }
}

