/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ConcurrentIdentityMapKeyEnumerationTest
extends TestCase {
    protected boolean shouldRun;
    protected Object storedObject;
    protected FullIdentityMap identityMap = new FullIdentityMap(1);

    public void reset() {
        this.shouldRun = false;
    }

    public void setup() {
        this.storedObject = this.getSession().readObject(Employee.class);
        this.shouldRun = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        Thread enumeration = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (ConcurrentIdentityMapKeyEnumerationTest.this.shouldRun) {
                    Enumeration keys = ConcurrentIdentityMapKeyEnumerationTest.this.identityMap.keys();
                    while (keys.hasMoreElements()) {
                        try {
                            Object key = keys.nextElement();
                        }
                        catch (Exception ex) {
                            ConcurrentIdentityMapKeyEnumerationTest.this.shouldRun = false;
                            Object object = ConcurrentIdentityMapKeyEnumerationTest.this.storedObject;
                            synchronized (object) {
                                ConcurrentIdentityMapKeyEnumerationTest.this.storedObject.notifyAll();
                            }
                        }
                    }
                }
            }
        };
        enumeration.start();
        Thread remover = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Vector<BigDecimal> pk = new Vector<BigDecimal>(1);
                pk.add(((Employee)ConcurrentIdentityMapKeyEnumerationTest.this.storedObject).getId());
                while (ConcurrentIdentityMapKeyEnumerationTest.this.shouldRun) {
                    ConcurrentIdentityMapKeyEnumerationTest.this.identityMap.put(pk, ConcurrentIdentityMapKeyEnumerationTest.this.storedObject, null, 0L);
                    try {
                        Thread.sleep(2L);
                    }
                    catch (InterruptedException ex) {
                        ConcurrentIdentityMapKeyEnumerationTest.this.shouldRun = false;
                        Object object = ConcurrentIdentityMapKeyEnumerationTest.this.storedObject;
                        synchronized (object) {
                            ConcurrentIdentityMapKeyEnumerationTest.this.storedObject.notifyAll();
                        }
                    }
                    ConcurrentIdentityMapKeyEnumerationTest.this.identityMap.remove(pk, null);
                }
            }
        };
        remover.start();
        try {
            Object object = this.storedObject;
            synchronized (object) {
                this.storedObject.wait(30000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.shouldRun) {
            throw new TestErrorException("Failed to ignore nulls while enumeration identitymap");
        }
        this.shouldRun = false;
    }
}

