/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.isolatedsession;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee;
import org.eclipse.persistence.testing.tests.isolatedsession.VPDIsolatedSessionEventAdaptor;

public class VPDSupportTest
extends AutoVerifyTestCase {
    protected DatabaseLogin login;
    protected ServerSession server;
    protected VPDIsolatedSessionEventAdaptor eventAdaptor;
    protected Session nonVPDSession;

    public VPDSupportTest() {
        this.setDescription("This test will verify that the isolation support will work with VPD");
    }

    public void copyDescriptors(Session session) {
        Vector descriptors = new Vector();
        Iterator iterator = session.getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            descriptors.addElement(iterator.next());
        }
        this.server.addDescriptors(descriptors);
        this.server.getProject().setHasIsolatedClasses(true);
    }

    public void reset() {
        try {
            this.server.logout();
            this.getDatabaseSession().logout();
            this.getDatabaseSession().login();
            String schemaName = ((AbstractSession)this.getSession()).getAccessor().getConnection().getMetaData().getUserName();
            this.getSession().executeNonSelectingCall((Call)new SQLCall("CALL DBMS_RLS.DROP_POLICY ('" + schemaName + "', 'isolated_employee', 'testing_policy')"));
            this.getSession().executeNonSelectingCall((Call)new SQLCall("DROP CONTEXT testing_ctx"));
        }
        catch (DatabaseException ex) {
        }
        catch (SQLException se) {
            se.printStackTrace();
            throw new TestErrorException("There is SQLException");
        }
    }

    public void setup() {
        try {
            Vector emps = this.getSession().readAllObjects(IsolatedEmployee.class);
            String schemaName = ((AbstractSession)this.getSession()).getAccessor().getConnection().getMetaData().getUserName();
            this.getSession().executeNonSelectingCall((Call)new SQLCall("CREATE OR REPLACE PACKAGE " + schemaName + ".init AS PROCEDURE set_emp_id(e_id NUMBER, identifier NUMBER); END init;"));
            this.getSession().executeNonSelectingCall((Call)new SQLCall("CREATE OR REPLACE PACKAGE BODY " + schemaName + ".init AS PROCEDURE set_emp_id(e_id NUMBER, identifier NUMBER) IS BEGIN DBMS_SESSION.SET_CONTEXT('testing_ctx', 'e_id', e_id, null, identifier); end set_emp_id; end;"));
            this.getSession().executeNonSelectingCall((Call)new SQLCall("CREATE OR REPLACE CONTEXT testing_ctx USING " + schemaName + ".init ACCESSED GLOBALLY"));
            this.getSession().executeNonSelectingCall((Call)new SQLCall("CREATE OR REPLACE PACKAGE testing_security AS FUNCTION Allowed_ids (ns VARCHAR, na VARCHAR) RETURN VARCHAR2;END;"));
            this.getSession().executeNonSelectingCall((Call)new SQLCall("CREATE OR REPLACE PACKAGE BODY testing_security AS FUNCTION Allowed_ids(ns VARCHAR, na VARCHAR) RETURN VARCHAR2 IS D_predicate VARCHAR2(200); BEGIN  D_predicate := 'EMP_ID = SYS_CONTEXT(''testing_ctx'', ''e_id'')'; RETURN D_predicate; END Allowed_ids; END testing_security;"));
            this.getSession().executeNonSelectingCall((Call)new SQLCall("CALL DBMS_RLS.ADD_POLICY ('" + schemaName + "', 'isolated_employee', 'testing_policy', '" + schemaName + "', 'testing_security.Allowed_ids', 'select')"));
            this.getSession().executeNonSelectingCall((Call)new SQLCall("CALL " + schemaName + ".init.set_emp_id (" + ((IsolatedEmployee)emps.get(0)).getId() + ", 1)"));
            this.getSession().executeNonSelectingCall((Call)new SQLCall("CALL " + schemaName + ".init.set_emp_id (" + ((IsolatedEmployee)emps.get(1)).getId() + ", 2)"));
            this.login = (DatabaseLogin)this.getSession().getLogin().clone();
            this.server = new ServerSession((Login)this.login, 2, 5);
            this.server.getDefaultConnectionPolicy().setExclusiveMode(ConnectionPolicy.ExclusiveMode.Isolated);
            this.server.setSessionLog(this.getSession().getSessionLog());
            this.copyDescriptors(this.getSession());
            this.server.login();
            this.nonVPDSession = this.server.acquireClientSession();
            this.nonVPDSession.readAllObjects(IsolatedEmployee.class);
            this.eventAdaptor = new VPDIsolatedSessionEventAdaptor();
            this.server.getEventManager().addListener((SessionEventListener)this.eventAdaptor);
        }
        catch (RuntimeException ex) {
            this.getSession().logMessage("This test requires that the connected user has privleges to \"Creat any context\", \"Drop any context\" and \"execute Sys.DBMS_RLS package\".");
            throw ex;
        }
        catch (SQLException se) {
            se.printStackTrace();
            throw new TestErrorException("There is SQLException");
        }
    }

    public void test() {
        ClientSession client1 = this.server.acquireClientSession();
        ClientSession client2 = this.server.acquireClientSession();
        this.eventAdaptor.setSession_Id(1);
        Vector vector1 = client1.readAllObjects(IsolatedEmployee.class);
        if (vector1.size() > 1) {
            throw new TestErrorException("Too Many Employee's returned from the VPD");
        }
        this.eventAdaptor.setSession_Id(2);
        Vector vector2 = client2.readAllObjects(IsolatedEmployee.class);
        if (vector2.size() > 1) {
            throw new TestErrorException("Too Many Employee's returned from the VPD");
        }
        if (vector1.get(0).equals(vector2.get(0))) {
            throw new TestErrorException("The data was not isolated from the other session");
        }
        client1.release();
        client2.release();
    }

    public void verify() {
        if (this.nonVPDSession.readAllObjects(IsolatedEmployee.class).size() > 0) {
            throw new TestErrorException("The objects were not isolated by the VPD");
        }
        this.nonVPDSession.release();
    }
}

