/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking;

import junit.framework.Test;
import org.eclipse.persistence.descriptors.AllFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.ChangedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.optimisticlocking.Guitar;
import org.eclipse.persistence.testing.models.optimisticlocking.LockInAggregateObject;
import org.eclipse.persistence.testing.models.optimisticlocking.LockInCache;
import org.eclipse.persistence.testing.models.optimisticlocking.LockInObject;
import org.eclipse.persistence.testing.models.optimisticlocking.OptimisticLockingSystem;
import org.eclipse.persistence.testing.models.optimisticlocking.RockBand;
import org.eclipse.persistence.testing.models.optimisticlocking.RockMusician;
import org.eclipse.persistence.testing.models.optimisticlocking.TimestampInAggregateObject;
import org.eclipse.persistence.testing.models.optimisticlocking.TimestampInCache;
import org.eclipse.persistence.testing.models.optimisticlocking.TimestampInObject;
import org.eclipse.persistence.testing.tests.optimisticlocking.ChangeSetOptimisticLockingInsertTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.ChangeSetOptimisticLockingUpdateTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.FieldsLockingCachedUpdateCallsTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.OptimisticLockingDeleteTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.OptimisticLockingInsertTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.OptimisticLockingPolicyChangedValueUpdateTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.OptimisticLockingPolicyDeleteRowTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.OptimisticLockingPolicyUpdateTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.OptimisticLockingPolicyUpdateWithUOWTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.OptimisticLockingUpdateTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.TimestampNewObjectInCache;
import org.eclipse.persistence.testing.tests.optimisticlocking.UpdateAllWithTimestampLockingTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.UpdateNullAggregateValueTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.UpdateNullDirectToFieldValueTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.UpdateNullManyToManyValueTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.UpdateNullOneToManyValueTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.UpdateNullOneToManyValueTest2;
import org.eclipse.persistence.testing.tests.optimisticlocking.UpdateNullOneToOneValueTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.UpdateNullTransformationValueTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.UpdateNullVariableOneToOneValueTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.WriteLockValueSerializationTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.BarSystem;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.Cascaded121OptimisticLockingTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.Cascaded12MInheritanceListOnSuperOptimisticLockingTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.Cascaded12MInheritanceOptimisticLockingTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.Cascaded12MOptimisticLockingTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.CascadedCollectionOptimisticLockingTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.CascadedMultiLevel121OptimisticLockingTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.CascadedMultiLevel12MOptimisticLockingTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.CascadedMultiLevelCollectionOptimisticLockingTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.CascadedVersionLockingMultiplePrivateOwnedTest;

public class OptimisticLockingTestModel
extends TestModel {
    public OptimisticLockingTestModel() {
        this.setDescription("This model tests EclipseLink optimistic locking features.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new OptimisticLockingSystem());
        this.addRequiredSystem(new BarSystem());
    }

    public void addTests() {
        this.addTest((Test)OptimisticLockingTestModel.getOptimisticLockingTestSuite());
        this.addTest((Test)OptimisticLockingTestModel.getCascadeOptimisticLockingTestSuite());
        this.addTest((Test)OptimisticLockingTestModel.getLockingExceptionTestSuite());
        this.addTest((Test)OptimisticLockingTestModel.getUpdateNullValueOptimisticLockingTestSuite());
    }

    public static TestSuite getLockingExceptionTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("LockingExceptionTestSuite");
        suite.addTest((Test)new OptimisticLockingPolicyDeleteRowTest(Guitar.class));
        suite.addTest((Test)new OptimisticLockingPolicyDeleteRowTest(RockMusician.class));
        suite.addTest((Test)new OptimisticLockingPolicyDeleteRowTest(RockBand.class));
        suite.addTest((Test)new OptimisticLockingPolicyChangedValueUpdateTest(Guitar.class));
        suite.addTest((Test)new OptimisticLockingPolicyChangedValueUpdateTest(RockMusician.class));
        suite.addTest((Test)new OptimisticLockingPolicyChangedValueUpdateTest(RockBand.class));
        suite.addTest((Test)new OptimisticLockingPolicyUpdateTest(Guitar.class));
        suite.addTest((Test)new OptimisticLockingPolicyUpdateTest(RockMusician.class));
        suite.addTest((Test)new OptimisticLockingPolicyUpdateTest(RockBand.class));
        return suite;
    }

    public static TestSuite getOptimisticLockingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OptimisticLockingTestSuite");
        suite.setDescription("This suite tests the functionality of the optimistic locking policy.");
        suite.addTest((Test)new OptimisticLockingUpdateTest(LockInCache.class, true));
        suite.addTest((Test)new OptimisticLockingDeleteTest(LockInCache.class, true));
        suite.addTest((Test)new OptimisticLockingInsertTest(new LockInCache()));
        suite.addTest((Test)new OptimisticLockingUpdateTest(LockInObject.class, true));
        suite.addTest((Test)new OptimisticLockingDeleteTest(LockInObject.class, true));
        suite.addTest((Test)new OptimisticLockingInsertTest(new LockInObject()));
        suite.addTest((Test)new OptimisticLockingUpdateTest(TimestampInCache.class, true));
        suite.addTest((Test)new OptimisticLockingDeleteTest(TimestampInCache.class, true));
        suite.addTest((Test)new OptimisticLockingInsertTest(new TimestampInCache()));
        suite.addTest((Test)new OptimisticLockingUpdateTest(TimestampInObject.class, true));
        suite.addTest((Test)new OptimisticLockingDeleteTest(TimestampInObject.class, true));
        suite.addTest((Test)new OptimisticLockingInsertTest(new TimestampInObject()));
        suite.addTest((Test)new OptimisticLockingPolicyUpdateWithUOWTest());
        suite.addTest((Test)new OptimisticLockingUpdateTest(TimestampInAggregateObject.class, true));
        suite.addTest((Test)new OptimisticLockingDeleteTest(TimestampInAggregateObject.class, true));
        suite.addTest((Test)new OptimisticLockingInsertTest(new TimestampInAggregateObject()));
        suite.addTest((Test)new OptimisticLockingUpdateTest(LockInAggregateObject.class, true));
        suite.addTest((Test)new OptimisticLockingDeleteTest(LockInAggregateObject.class, true));
        suite.addTest((Test)new OptimisticLockingInsertTest(new LockInAggregateObject()));
        suite.addTest((Test)new TimestampNewObjectInCache(LockInObject.example1()));
        suite.addTest((Test)new TimestampNewObjectInCache(TimestampInObject.example1()));
        suite.addTest((Test)new ChangeSetOptimisticLockingUpdateTest(TimestampInAggregateObject.class));
        suite.addTest((Test)new ChangeSetOptimisticLockingUpdateTest(LockInAggregateObject.class));
        suite.addTest((Test)new ChangeSetOptimisticLockingUpdateTest(TimestampInCache.class));
        suite.addTest((Test)new ChangeSetOptimisticLockingUpdateTest(LockInCache.class));
        suite.addTest((Test)new ChangeSetOptimisticLockingUpdateTest(TimestampInObject.class));
        suite.addTest((Test)new ChangeSetOptimisticLockingUpdateTest(LockInObject.class));
        suite.addTest((Test)new ChangeSetOptimisticLockingInsertTest(TimestampInAggregateObject.class));
        suite.addTest((Test)new ChangeSetOptimisticLockingInsertTest(LockInAggregateObject.class));
        suite.addTest((Test)new ChangeSetOptimisticLockingInsertTest(TimestampInCache.class));
        suite.addTest((Test)new ChangeSetOptimisticLockingInsertTest(LockInCache.class));
        suite.addTest((Test)new ChangeSetOptimisticLockingInsertTest(TimestampInObject.class));
        suite.addTest((Test)new ChangeSetOptimisticLockingInsertTest(LockInObject.class));
        suite.addTest((Test)new WriteLockValueSerializationTest());
        suite.addTest((Test)new FieldsLockingCachedUpdateCallsTest());
        suite.addTest((Test)new UpdateAllWithTimestampLockingTest());
        return suite;
    }

    public static TestSuite getCascadeOptimisticLockingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("CascadeOptimisticLockingTestSuite");
        suite.setDescription("This suite tests the functionality of the cascade optimistic locking policy.");
        suite.addTest((Test)new Cascaded121OptimisticLockingTest());
        suite.addTest((Test)new Cascaded12MOptimisticLockingTest());
        suite.addTest((Test)new CascadedCollectionOptimisticLockingTest());
        suite.addTest((Test)new CascadedMultiLevel121OptimisticLockingTest());
        suite.addTest((Test)new CascadedMultiLevel12MOptimisticLockingTest());
        suite.addTest((Test)new CascadedMultiLevelCollectionOptimisticLockingTest());
        suite.addTest((Test)new Cascaded12MInheritanceOptimisticLockingTest());
        suite.addTest((Test)new Cascaded12MInheritanceListOnSuperOptimisticLockingTest());
        suite.addTest((Test)new CascadedVersionLockingMultiplePrivateOwnedTest());
        return suite;
    }

    public static TestSuite getUpdateNullValueOptimisticLockingTestSuite() {
        int i;
        TestSuite suite = new TestSuite();
        suite.setName("UpdateNullValueOptimisticLockingTestSuite");
        suite.setDescription("Tests the functionality of updating fields with a null database value, with optimistic locking");
        Class[] policies = new Class[]{AllFieldsLockingPolicy.class, SelectedFieldsLockingPolicy.class, ChangedFieldsLockingPolicy.class, VersionLockingPolicy.class, TimestampLockingPolicy.class};
        for (i = 0; i < policies.length; ++i) {
            suite.addTest((Test)new UpdateNullDirectToFieldValueTest(policies[i]));
        }
        for (i = 0; i < policies.length; ++i) {
            suite.addTest((Test)new UpdateNullOneToOneValueTest(policies[i]));
        }
        for (i = 0; i < policies.length; ++i) {
            suite.addTest((Test)new UpdateNullAggregateValueTest(policies[i]));
        }
        for (i = 0; i < policies.length; ++i) {
            suite.addTest((Test)new UpdateNullOneToManyValueTest(policies[i]));
        }
        for (i = 0; i < policies.length; ++i) {
            suite.addTest((Test)new UpdateNullOneToManyValueTest2(policies[i]));
        }
        for (i = 0; i < policies.length; ++i) {
            suite.addTest((Test)new UpdateNullTransformationValueTest(policies[i]));
        }
        for (i = 0; i < policies.length; ++i) {
            suite.addTest((Test)new UpdateNullVariableOneToOneValueTest(policies[i]));
        }
        for (i = 0; i < policies.length; ++i) {
            suite.addTest((Test)new UpdateNullManyToManyValueTest(policies[i]));
        }
        return suite;
    }
}

