/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.QuerySQLTracker;

public class QueryCacheParameterizedResultsTest
extends AutoVerifyTestCase {
    protected QuerySQLTracker tracker = null;
    protected ReadAllQuery query = null;
    protected Vector args1 = null;
    protected Vector args2 = null;
    protected Vector results1 = null;
    protected Vector results2 = null;
    protected int expectedQuery1SQLStatementCount = 0;
    protected int expectedQuery2SQLStatementCount = 0;
    protected int query1SQLStatementCount = 0;
    protected int query2SQLStatementCount = 0;

    public QueryCacheParameterizedResultsTest() {
        this.setDescription("Ensure a query with multiple cached results based on parameters works.");
        this.args1 = new Vector();
        this.args1.addElement("Bob");
        this.args2 = new Vector();
        this.args2.addElement("Jill");
    }

    public ReadAllQuery getReadAllQuery() {
        ReadAllQuery testQuery = new ReadAllQuery(Employee.class);
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression exp = employees.get("firstName").equal(employees.getParameter("name"));
        testQuery.setSelectionCriteria(exp);
        testQuery.addArgument("name");
        testQuery.cacheQueryResults();
        return testQuery;
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.query = this.getReadAllQuery();
        this.getSession().executeQuery((DatabaseQuery)this.query, (List)this.args1);
        this.getSession().executeQuery((DatabaseQuery)this.query, (List)this.args2);
        this.tracker = new QuerySQLTracker(this.getSession());
    }

    public void test() {
        this.results2 = (Vector)this.getSession().executeQuery((DatabaseQuery)this.query, (List)this.args2);
        this.query2SQLStatementCount = this.tracker.getSqlStatements().size();
        this.results1 = (Vector)this.getSession().executeQuery((DatabaseQuery)this.query, (List)this.args1);
        this.query1SQLStatementCount = this.tracker.getSqlStatements().size();
    }

    public void verify() {
        if (this.query1SQLStatementCount != this.expectedQuery1SQLStatementCount) {
            throw new TestErrorException("An incorrect number of sql statements were executed in the first query , the query cache was not used sucessfully: " + this.tracker.getSqlStatements().size());
        }
        if (this.query2SQLStatementCount != this.expectedQuery2SQLStatementCount) {
            throw new TestErrorException("An incorrect number of sql statements were executed in the second query , the query cache was not used sucessfully: " + this.tracker.getSqlStatements().size());
        }
        for (Employee emp : this.results1) {
            if (emp.getFirstName().equals("Bob")) continue;
            throw new TestErrorException("The cached query returned the wrong results. " + emp);
        }
        for (Employee emp : this.results2) {
            if (emp.getFirstName().equals("Jill")) continue;
            throw new TestErrorException("The cached query returned the wrong results. " + emp);
        }
    }

    public void reset() {
        this.tracker.remove();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

