/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public abstract class ReportQueryTestCase
extends AutoVerifyTestCase {
    protected ReportQuery reportQuery;
    protected Vector expectedResults;
    protected Vector results;
    protected boolean checkEntrySet = true;

    protected void addResult(Object[] values, Object primaryKey) {
        Vector<Object> results = new Vector<Object>(values.length);
        for (int index = 0; index < values.length; ++index) {
            results.add(values[index]);
        }
        ReportQueryResult result = new ReportQueryResult(results, primaryKey);
        this.expectedResults.addElement(result);
    }

    protected abstract void buildExpectedResults() throws Exception;

    public String getName() {
        return super.getName() + ": " + this.getDescription();
    }

    protected void removeFromResult(ReportQueryResult result, Vector expected) {
        Enumeration e = expected.elements();
        while (e.hasMoreElements()) {
            ReportQueryResult expRes = (ReportQueryResult)e.nextElement();
            if (!result.equals(expRes)) continue;
            expected.removeElement(expRes);
            return;
        }
        this.getSession().logMessage("missing element: " + result);
    }

    protected boolean isEntrySetOk(ReportQueryResult result) {
        try {
            Set set = result.entrySet();
            if (result.size() != set.size()) {
                return false;
            }
            ArrayList names = new ArrayList(result.getNames());
            ArrayList results = new ArrayList(result.getResults());
            for (Map.Entry entry : set) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                int index = names.indexOf(key);
                if (index == -1) {
                    return false;
                }
                if (results.get(index) != value) {
                    return false;
                }
                names.remove(index);
                results.remove(index);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    protected void setup() throws Exception {
        this.results = new Vector();
        this.expectedResults = new Vector();
        this.buildExpectedResults();
    }

    public void test() {
        this.results = (Vector)this.getSession().executeQuery((DatabaseQuery)this.reportQuery);
    }

    protected void verify() {
        this.getSession().logMessage("results: " + this.results);
        this.getSession().logMessage("expectedResults: " + this.expectedResults);
        if (this.results.size() != this.expectedResults.size()) {
            throw new TestErrorException("ReportQuery test failed: The result size are different");
        }
        Vector cloneResults = (Vector)this.expectedResults.clone();
        Enumeration e = this.results.elements();
        while (e.hasMoreElements()) {
            this.removeFromResult((ReportQueryResult)e.nextElement(), cloneResults);
        }
        if (cloneResults.size() != 0) {
            throw new TestErrorException("ReportQuery test failed: The result didn't match");
        }
        if (this.checkEntrySet) {
            e = this.results.elements();
            while (e.hasMoreElements()) {
                if (this.isEntrySetOk((ReportQueryResult)e.nextElement())) continue;
                throw new TestErrorException("Problem with ReportQueryResult.entrySet() method");
            }
        }
    }
}

