/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.tests.transparentindirection.TestSession;
import org.eclipse.persistence.testing.tests.transparentindirection.ZTestCase;

public class IndirectMapTestAPI
extends ZTestCase {
    Hashtable map;
    IndirectMap testMap;

    public IndirectMapTestAPI(String name) {
        super(name);
    }

    protected void assertElementsEqual(String message, Map expected, Map actual) {
        if (expected == actual) {
            return;
        }
        if (expected.size() != actual.size()) {
            IndirectMapTestAPI.assertTrue((String)this.notEqualsMessage(message, expected, actual), (boolean)false);
        }
        for (Object key : expected.keySet()) {
            if (expected.get(key).equals(actual.get(key))) continue;
            IndirectMapTestAPI.assertTrue((String)this.notEqualsMessage(message, expected, actual), (boolean)false);
        }
    }

    protected void assertElementsEqual(Map expected, Map actual) {
        this.assertElementsEqual("", expected, actual);
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.map = this.setUpMap();
        Hashtable temp = new Hashtable(this.map);
        QueryBasedValueHolder vh = new QueryBasedValueHolder((ReadQuery)new ReadAllQuery(), (AbstractRecord)new DatabaseRecord(), (AbstractSession)new TestSession(temp));
        this.testMap = new IndirectMap();
        this.testMap.setValueHolder((ValueHolderInterface)vh);
    }

    protected Hashtable setUpMap() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("zero", "000");
        result.put("one", "111");
        result.put("two", "222");
        result.put("three", "333");
        result.put("four", "444");
        result.put("five", "555");
        result.put("six", "666");
        result.put("seven", "777");
        result.put("eight", "888");
        result.put("nine", "999");
        return result;
    }

    @Override
    protected void tearDown() {
        super.tearDown();
    }

    public void testClear() {
        this.map.clear();
        this.testMap.clear();
        IndirectMapTestAPI.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI.assertTrue((this.testMap.size() == 0 ? 1 : 0) != 0);
    }

    public void testContains() {
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.contains(this.map.elements().nextElement()));
    }

    public void testContainsKey() {
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.containsKey(this.map.keys().nextElement()));
    }

    public void testContainsValue() {
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.containsValue(this.map.elements().nextElement()));
    }

    public void testElements() {
        if (!this.map.contains(this.testMap.elements().nextElement())) {
            IndirectMapTestAPI.assertTrue((String)"Map Does not contain elements from test", (boolean)false);
        }
    }

    public void testEntrySet() {
        IndirectMapTestAPI.assertEquals(this.map.entrySet(), (Object)this.testMap.entrySet());
    }

    public void testEquals() {
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.equals((Object)this.map));
    }

    public void testGet() {
        IndirectMapTestAPI.assertEquals(this.map.get("six"), (Object)this.testMap.get((Object)"six"));
    }

    public void testHashCode() {
        IndirectMapTestAPI.assertEquals((int)this.map.hashCode(), (int)this.testMap.hashCode());
    }

    public void testIsEmpty() {
        IndirectMapTestAPI.assertTrue((!this.testMap.isEmpty() ? 1 : 0) != 0);
    }

    public void testKeys() {
        if (this.map.contains(this.testMap.keys().nextElement())) {
            IndirectMapTestAPI.assertTrue((String)"Map Does not contain keys from test", (boolean)false);
        }
    }

    public void testKeySet() {
        IndirectMapTestAPI.assertEquals(this.map.entrySet(), (Object)this.testMap.entrySet());
    }

    public void testPut() {
        String key = "foo";
        String value = "bar";
        this.map.put(key, value);
        this.testMap.put((Object)key, (Object)value);
        IndirectMapTestAPI.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.containsKey((Object)key));
        IndirectMapTestAPI.assertTrue((boolean)this.testMap.contains((Object)value));
    }

    public void testPutAll() {
        Hashtable<String, String> temp = new Hashtable<String, String>();
        temp.put("foo", "bar");
        temp.put("sna", "fu");
        this.map.putAll(temp);
        this.testMap.putAll(temp);
        IndirectMapTestAPI.assertEquals((Object)this.map, (Object)this.testMap);
        Enumeration<Object> stream = temp.keys();
        while (stream.hasMoreElements()) {
            IndirectMapTestAPI.assertTrue((boolean)this.testMap.containsKey(stream.nextElement()));
        }
        stream = temp.elements();
        while (stream.hasMoreElements()) {
            IndirectMapTestAPI.assertTrue((boolean)this.testMap.contains(stream.nextElement()));
        }
    }

    public void testRemove() {
        String temp = "one";
        IndirectMapTestAPI.assertTrue((this.map.remove(temp) != null ? 1 : 0) != 0);
        IndirectMapTestAPI.assertTrue((this.testMap.remove((Object)temp) != null ? 1 : 0) != 0);
        IndirectMapTestAPI.assertEquals((Object)this.map, (Object)this.testMap);
        IndirectMapTestAPI.assertTrue((!this.testMap.containsKey((Object)temp) ? 1 : 0) != 0);
    }

    public void testSize() {
        IndirectMapTestAPI.assertEquals((int)this.map.size(), (int)this.testMap.size());
    }

    public void testValues() {
        IndirectMapTestAPI.assertEquals((int)this.map.size(), (int)this.testMap.values().size());
        Iterator stream = this.testMap.values().iterator();
        while (stream.hasNext()) {
            IndirectMapTestAPI.assertTrue((boolean)this.map.contains(stream.next()));
        }
        this.map.values().removeAll(this.testMap.values());
        IndirectMapTestAPI.assertTrue((boolean)this.map.values().isEmpty());
    }
}

