/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class PrimaryKeyClassTest
extends EntityContainerTestBase {
    protected boolean reset = false;
    protected Exception m_createException;
    protected Exception m_readException;
    protected Exception m_updateException;
    protected Exception m_deleteException;

    @Override
    public void setup() {
        super.setup();
        this.reset = true;
        ((EntityManagerImpl)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    @Override
    public void reset() {
        if (this.reset) {
            this.reset = false;
        }
        super.reset();
    }

    public void test() throws Exception {
        int empId = this.createTest();
        this.readTest(empId);
        this.updateTest(empId);
        this.deleteTest(empId);
    }

    private int createTest() {
        Vector<PhoneNumber> phoneNumbers = new Vector<PhoneNumber>();
        Employee employee = new Employee();
        try {
            this.beginTransaction();
            employee.setFirstName("Guy");
            employee.setLastName("Pelletier");
            PhoneNumber homeNumber = new PhoneNumber();
            homeNumber.setAreaCode("61x");
            homeNumber.setNumber("823-6262");
            homeNumber.setOwner(employee);
            homeNumber.setType("Home");
            phoneNumbers.add(homeNumber);
            PhoneNumber cellNumber = new PhoneNumber();
            cellNumber.setAreaCode("61x");
            cellNumber.setNumber("299-6747");
            cellNumber.setOwner(employee);
            cellNumber.setType("Cell");
            phoneNumbers.add(cellNumber);
            PhoneNumber workNumber = new PhoneNumber();
            workNumber.setAreaCode("61x");
            workNumber.setNumber("288-4639");
            workNumber.setOwner(employee);
            workNumber.setType("Work");
            phoneNumbers.add(workNumber);
            employee.setPhoneNumbers(phoneNumbers);
            this.getEntityManager().persist((Object)employee);
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            this.m_createException = e;
        }
        return employee.getId();
    }

    private void readTest(int empId) {
        try {
            this.getEntityManager().find(Employee.class, (Object)empId);
        }
        catch (Exception e) {
            this.m_readException = e;
        }
    }

    private void updateTest(int empId) {
        try {
            this.beginTransaction();
            Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)empId);
            Vector phones = (Vector)employee.getPhoneNumbers();
            Enumeration e = phones.elements();
            while (e.hasMoreElements()) {
                PhoneNumber phone = (PhoneNumber)e.nextElement();
                phone.setAreaCode("613");
            }
            this.getEntityManager().persist((Object)employee);
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            this.m_updateException = e;
        }
    }

    private void deleteTest(int empId) {
        try {
            this.beginTransaction();
            Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)empId);
            this.getEntityManager().remove(((Vector)employee.getPhoneNumbers()).firstElement());
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            this.m_deleteException = e;
        }
    }

    public void verify() {
        if (this.m_createException != null) {
            throw new TestErrorException("Create exception was caught. " + this.m_createException);
        }
        if (this.m_readException != null) {
            throw new TestErrorException("Read exception was caught. " + this.m_readException);
        }
        if (this.m_updateException != null) {
            throw new TestErrorException("Update exception was caught. " + this.m_updateException);
        }
        if (this.m_deleteException != null) {
            throw new TestErrorException("Delete exception was caught. " + this.m_deleteException);
        }
    }
}

