/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.cacheable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableFalseDetail;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableFalseDetailWithBackPointer;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableFalseEntity;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableForceProtectedEntity;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableProtectedEntity;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableRelationshipsEntity;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableTableCreator;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableTrueDerivedIDEntity;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableTrueDerivedIDPK;
import org.eclipse.persistence.testing.models.jpa.cacheable.CacheableTrueEntity;
import org.eclipse.persistence.testing.models.jpa.cacheable.ChildCacheableFalseEntity;
import org.eclipse.persistence.testing.models.jpa.cacheable.ForceProtectedEntityWithComposite;
import org.eclipse.persistence.testing.models.jpa.cacheable.ProtectedEmbeddable;
import org.eclipse.persistence.testing.models.jpa.cacheable.ProtectedRelationshipsEntity;
import org.eclipse.persistence.testing.models.jpa.cacheable.SharedEmbeddable;

public class CacheableModelJunitTest
extends JUnitTestCase {
    protected static int m_cacheableTrueEntity1Id;
    protected static int m_cacheableForceProtectedEntity1Id;
    protected static int m_cacheableTrueEntity2Id;
    protected static int m_childCacheableFalseEntityId;
    protected static int m_cacheableProtectedEntityId;
    protected static int m_forcedProtectedEntityCompositId;
    protected static int m_cacheableRelationshipsEntityId;

    public CacheableModelJunitTest() {
    }

    public CacheableModelJunitTest(String name) {
        super(name);
    }

    public void clearDSCache() {
        JUnitTestCase.clearCache((String)"DISABLE_SELECTIVE");
    }

    public void closeEM(EntityManager em) {
        if (em.isOpen()) {
            this.closeEntityManager(em);
        }
    }

    public EntityManager createDSEntityManager() {
        return JUnitTestCase.createEntityManager((String)"DISABLE_SELECTIVE");
    }

    protected CacheableTrueEntity findCacheableTrueEntity(EntityManager em, int id) {
        if (em == null) {
            EntityManager myEm = this.createDSEntityManager();
            CacheableTrueEntity entity = (CacheableTrueEntity)myEm.find(CacheableTrueEntity.class, (Object)id);
            this.closeEM(myEm);
            return entity;
        }
        return (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)id);
    }

    protected CacheableTrueEntity findCacheableTrueEntity_BYPASS_BYPASS(EntityManager em, int id) {
        return this.findCacheableTrueEntityUsingQuery(em, "findCacheableTrueEntityByPK_BYPASS_BYPASS", id);
    }

    protected CacheableTrueEntity findCacheableTrueEntity_BYPASS_USE(EntityManager em, int id) {
        return this.findCacheableTrueEntityUsingQuery(em, "findCacheableTrueEntityByPK_RETRIEVE_BYPASS_STORE_USE", id);
    }

    protected CacheableTrueEntity findCacheableTrueEntity_USE_BYPASS(EntityManager em, int id) {
        return this.findCacheableTrueEntityUsingQuery(em, "findCacheableTrueEntityByPK_RETRIEVE_USE_STORE_BYPASS", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheableTrueEntity findCacheableTrueEntityUsingQuery(EntityManager em, String query, int id) {
        CacheableTrueEntity entity = null;
        EntityManager emToUse = em == null ? this.createDSEntityManager() : em;
        try {
            boolean commit = false;
            if (!this.isTransactionActive(emToUse)) {
                this.beginTransaction(emToUse);
                commit = true;
            }
            entity = (CacheableTrueEntity)emToUse.createNamedQuery(query).setParameter("id", (Object)id).getSingleResult();
            if (commit) {
                this.commitTransaction(emToUse);
            }
        }
        catch (Exception e) {
            CacheableModelJunitTest.fail((String)("Error executing query: " + e));
        }
        finally {
            if (em == null) {
                this.closeEM(emToUse);
            }
        }
        return entity;
    }

    public ServerSession getDSServerSession() {
        return this.getPUServerSession("DISABLE_SELECTIVE");
    }

    public ServerSession getPUServerSession(String puName) {
        return JUnitTestCase.getServerSession((String)puName);
    }

    public void setUp() {
        this.clearDSCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("CacheableModelJunitTest");
        if (!JUnitTestCase.isJPA10()) {
            suite.addTest((Test)new CacheableModelJunitTest("testSetup"));
            suite.addTest((Test)new CacheableModelJunitTest("testCachingOnALL"));
            suite.addTest((Test)new CacheableModelJunitTest("testCachingOnNONE"));
            suite.addTest((Test)new CacheableModelJunitTest("testCachingOnENABLE_SELECTIVE"));
            suite.addTest((Test)new CacheableModelJunitTest("testCachingOnDISABLE_SELECTIVE"));
            suite.addTest((Test)new CacheableModelJunitTest("testCachingOnUNSPECIFIED"));
            suite.addTest((Test)new CacheableModelJunitTest("testCreateEntities"));
            suite.addTest((Test)new CacheableModelJunitTest("testFindWithEMProperties"));
            suite.addTest((Test)new CacheableModelJunitTest("testFindWithFindProperties"));
            suite.addTest((Test)new CacheableModelJunitTest("testRefreshWithEMProperties"));
            suite.addTest((Test)new CacheableModelJunitTest("testRefreshWithRefreshProperties"));
            suite.addTest((Test)new CacheableModelJunitTest("testRetrieveBYPASSStoreUSE1"));
            suite.addTest((Test)new CacheableModelJunitTest("testRetrieveBYPASSStoreUSE2"));
            suite.addTest((Test)new CacheableModelJunitTest("testRetrieveUSEStoreBYPASS1"));
            suite.addTest((Test)new CacheableModelJunitTest("testRetrieveUSEStoreBYPASS2"));
            suite.addTest((Test)new CacheableModelJunitTest("testRetrieveBYPASSStoreBYPASS1"));
            suite.addTest((Test)new CacheableModelJunitTest("testRetrieveBYPASSStoreBYPASS2"));
            suite.addTest((Test)new CacheableModelJunitTest("testMultipleEMQueries"));
            suite.addTest((Test)new CacheableModelJunitTest("testEMPropertiesOnCommit1"));
            suite.addTest((Test)new CacheableModelJunitTest("testEMPropertiesOnCommit2"));
            suite.addTest((Test)new CacheableModelJunitTest("testInheritanceCacheable"));
            suite.addTest((Test)new CacheableModelJunitTest("testDetailsOrder_Isolated"));
            suite.addTest((Test)new CacheableModelJunitTest("testDetailsOrder_Isolated_BeginEarlyTransaction"));
            suite.addTest((Test)new CacheableModelJunitTest("testDetailsOrder_Shared"));
            suite.addTest((Test)new CacheableModelJunitTest("testDetailsOrder_Shared_BeginEarlyTransaction"));
            suite.addTest((Test)new CacheableModelJunitTest("testLoadMixedCacheTree"));
            suite.addTest((Test)new CacheableModelJunitTest("testIsolatedIsolation"));
            suite.addTest((Test)new CacheableModelJunitTest("testProtectedIsolation"));
            suite.addTest((Test)new CacheableModelJunitTest("testProtectedCaching"));
            suite.addTest((Test)new CacheableModelJunitTest("testReadOnlyTree"));
            suite.addTest((Test)new CacheableModelJunitTest("testUpdateForceProtectedBasic"));
            suite.addTest((Test)new CacheableModelJunitTest("testUpdateForceProtectedOneToOne"));
            suite.addTest((Test)new CacheableModelJunitTest("testUpdateProtectedBasic"));
            suite.addTest((Test)new CacheableModelJunitTest("testUpdateProtectedOneToMany"));
            suite.addTest((Test)new CacheableModelJunitTest("testProtectedRelationshipsMetadata"));
            suite.addTest((Test)new CacheableModelJunitTest("testForceProtectedFromEmbeddable"));
            suite.addTest((Test)new CacheableModelJunitTest("testEmbeddableProtectedCaching"));
            suite.addTest((Test)new CacheableModelJunitTest("testEmbeddableProtectedReadOnly"));
            suite.addTest((Test)new CacheableModelJunitTest("testUpdateProtectedManyToOne"));
            suite.addTest((Test)new CacheableModelJunitTest("testUpdateProtectedManyToMany"));
            suite.addTest((Test)new CacheableModelJunitTest("testUpdateProtectedElementCollection"));
            suite.addTest((Test)new CacheableModelJunitTest("testIsolationBeforeEarlyTxBegin"));
            suite.addTest((Test)new CacheableModelJunitTest("testFindWithLegacyFindProperties"));
            suite.addTest((Test)new CacheableModelJunitTest("testFindWithEMLegacyProperties"));
            suite.addTest((Test)new CacheableModelJunitTest("testMergeNonCachedWithRelationship"));
            suite.addTest((Test)new CacheableModelJunitTest("testIndirectCollectionRefreshBehavior"));
            suite.addTest((Test)new CacheableModelJunitTest("testDerivedIDProtectedRead"));
        }
        return suite;
    }

    public void testSetup() {
        new CacheableTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearDSCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEMPropertiesOnCommit1() {
        EntityManager em1 = this.createDSEntityManager();
        CacheableTrueEntity cachedEntity = this.findCacheableTrueEntity(em1, m_cacheableTrueEntity1Id);
        String staleName = cachedEntity.getName();
        this.beginTransaction(em1);
        CacheableTrueEntity entityToDelete = new CacheableTrueEntity();
        entityToDelete.setName("entityToDelete");
        em1.persist((Object)entityToDelete);
        int entityToDeleteId = entityToDelete.getId();
        this.commitTransaction(em1);
        this.beginTransaction(em1);
        em1.setProperty("javax.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
        CacheableTrueEntity entity = this.findCacheableTrueEntity(em1, m_cacheableTrueEntity1Id);
        String updatedName = "testEMPropertiesOnCommit1";
        entity.setName(updatedName);
        CacheableTrueEntity deletedEntity1 = this.findCacheableTrueEntity(em1, entityToDeleteId);
        em1.remove((Object)deletedEntity1);
        this.commitTransaction(em1);
        this.closeEM(em1);
        EntityManager em2 = this.createDSEntityManager();
        this.beginTransaction(em2);
        try {
            CacheableTrueEntity entity2 = this.findCacheableTrueEntity_USE_BYPASS(em2, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"The shared cache was updated when the EM property CacheStoreMode = BYPASS", (boolean)entity2.getName().equals(staleName));
            em2.refresh((Object)entity2);
            CacheableModelJunitTest.assertTrue((String)"The entity was not refreshed with the updated name.", (boolean)entity2.getName().equals(updatedName));
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("javax.persistence.cache.retrieveMode", CacheRetrieveMode.USE);
            props.put("javax.persistence.cache.storeMode", CacheStoreMode.BYPASS);
            CacheableTrueEntity deletedEntity2 = (CacheableTrueEntity)em2.find(CacheableTrueEntity.class, (Object)entityToDeleteId, props);
            CacheableModelJunitTest.assertTrue((String)"The deleted entity was removed from the cache", (deletedEntity2 == null ? 1 : 0) != 0);
            deletedEntity2 = (CacheableTrueEntity)em2.find(CacheableTrueEntity.class, (Object)entityToDeleteId);
            CacheableModelJunitTest.assertTrue((String)"The deleted entity was removed from the database", (deletedEntity2 == null ? 1 : 0) != 0);
        }
        finally {
            this.closeEntityManagerAndTransaction(em2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEMPropertiesOnCommit2() {
        EntityManager em1 = this.createDSEntityManager();
        CacheableTrueEntity cachedEntity1 = this.findCacheableTrueEntity(em1, m_cacheableTrueEntity1Id);
        CacheableTrueEntity cachedEntity2 = this.findCacheableTrueEntity(em1, m_cacheableTrueEntity2Id);
        String staleName = cachedEntity2.getName();
        String updatedName = "testEMPropertiesOnCommit2";
        this.beginTransaction(em1);
        em1.setProperty("javax.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
        Query query = em1.createQuery("UPDATE JPA_CACHEABLE_TRUE e SET e.name = :name WHERE e.id = :id ").setParameter("name", (Object)updatedName).setParameter("id", (Object)m_cacheableTrueEntity1Id);
        query.setHint("javax.persistence.cache.storeMode", (Object)CacheStoreMode.USE);
        query.executeUpdate();
        CacheableTrueEntity entity2 = this.findCacheableTrueEntity(em1, m_cacheableTrueEntity2Id);
        entity2.setName(updatedName);
        this.commitTransaction(em1);
        this.closeEM(em1);
        EntityManager em2 = this.createDSEntityManager();
        this.beginTransaction(em2);
        try {
            CacheableTrueEntity entity21 = this.findCacheableTrueEntity_USE_BYPASS(em2, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"The shared cache should have been updated", (boolean)entity21.getName().equals(updatedName));
            CacheableTrueEntity entity22 = this.findCacheableTrueEntity_USE_BYPASS(em2, m_cacheableTrueEntity2Id);
            CacheableModelJunitTest.assertTrue((String)"The shared cache should NOT have been updated", (boolean)entity22.getName().equals(staleName));
            em2.refresh((Object)entity22);
            CacheableModelJunitTest.assertTrue((String)"The entity was not refreshed with the updated name.", (boolean)entity22.getName().equals(updatedName));
        }
        finally {
            this.closeEntityManagerAndTransaction(em2);
        }
    }

    public void testFindWithEMProperties() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity = this.findCacheableTrueEntity(em, m_cacheableTrueEntity1Id);
            this.updateCacheableTrueEntityNameInSharedCache("testCacheRetrieveModeBypassOnFindThroughEMProperties");
            EntityManager em2 = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity2 = (CacheableTrueEntity)em2.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"The shared cache was not updated.", (boolean)cachedEntity2.getName().equals("testCacheRetrieveModeBypassOnFindThroughEMProperties"));
            this.closeEM(em2);
            em.setProperty("javax.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.USE);
            em.setProperty("javax.persistence.cache.storeMode", (Object)CacheStoreMode.REFRESH);
            CacheableTrueEntity entity = (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have been refreshed.", (boolean)entity.getName().equals("testCacheRetrieveModeBypassOnFindThroughEMProperties"));
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity from UOW should have been refreshed.", (boolean)cachedEntity.getName().equals(entity.getName()));
            CacheableModelJunitTest.assertTrue((String)"Entity returned should be the same instance from the UOW cache", (cachedEntity == entity ? 1 : 0) != 0);
            this.closeEM(em);
        }
    }

    public void testFindWithEMLegacyProperties() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity = this.findCacheableTrueEntity(em, m_cacheableTrueEntity1Id);
            this.updateCacheableTrueEntityNameInSharedCache("testCacheRetrieveModeBypassOnFindThroughEMProperties");
            EntityManager em2 = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity2 = (CacheableTrueEntity)em2.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"The shared cache was not updated.", (boolean)cachedEntity2.getName().equals("testCacheRetrieveModeBypassOnFindThroughEMProperties"));
            this.closeEM(em2);
            em.setProperty("javax.persistence.cacheRetrieveMode", (Object)CacheRetrieveMode.USE);
            em.setProperty("javax.persistence.cacheStoreMode", (Object)CacheStoreMode.REFRESH);
            CacheableTrueEntity entity = (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have been refreshed.", (boolean)entity.getName().equals("testCacheRetrieveModeBypassOnFindThroughEMProperties"));
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity from UOW should have been refreshed.", (boolean)cachedEntity.getName().equals(entity.getName()));
            CacheableModelJunitTest.assertTrue((String)"Entity returned should be the same instance from the UOW cache", (cachedEntity == entity ? 1 : 0) != 0);
            this.closeEM(em);
        }
    }

    public void testFindWithFindProperties() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity = (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
            this.updateCacheableTrueEntityNameAndBypassStore("testCacheRetrieveModeBypassOnFindThroughFindProperties");
            EntityManager em2 = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity2 = (CacheableTrueEntity)em2.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertFalse((String)"The shared cache was updated.", (boolean)cachedEntity2.getName().equals("testCacheRetrieveModeBypassOnFindThroughFindProperties"));
            this.closeEM(em2);
            em.setProperty("javax.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.USE);
            HashMap<String, CacheStoreMode> properties = new HashMap<String, CacheStoreMode>();
            properties.put("javax.persistence.cache.storeMode", CacheStoreMode.REFRESH);
            CacheableTrueEntity entity = (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id, properties);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have been refreshed.", (boolean)entity.getName().equals("testCacheRetrieveModeBypassOnFindThroughFindProperties"));
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity from UOW should have been refreshed.", (boolean)cachedEntity.getName().equals(entity.getName()));
            CacheableModelJunitTest.assertTrue((String)"Entity returned should be the same instance from the UOW cache", (cachedEntity == entity ? 1 : 0) != 0);
            this.closeEM(em);
        }
    }

    public void testFindWithLegacyFindProperties() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity = (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
            this.updateCacheableTrueEntityNameAndBypassStore("testCacheRetrieveModeBypassOnFindThroughFindProperties");
            EntityManager em2 = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity2 = (CacheableTrueEntity)em2.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertFalse((String)"The shared cache was updated.", (boolean)cachedEntity2.getName().equals("testCacheRetrieveModeBypassOnFindThroughFindProperties"));
            this.closeEM(em2);
            em.setProperty("javax.persistence.cacheRetrieveMode", (Object)CacheRetrieveMode.USE);
            HashMap<String, CacheStoreMode> properties = new HashMap<String, CacheStoreMode>();
            properties.put("javax.persistence.cacheStoreMode", CacheStoreMode.REFRESH);
            CacheableTrueEntity entity = (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id, properties);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have been refreshed.", (boolean)entity.getName().equals("testCacheRetrieveModeBypassOnFindThroughFindProperties"));
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity from UOW should have been refreshed.", (boolean)cachedEntity.getName().equals(entity.getName()));
            CacheableModelJunitTest.assertTrue((String)"Entity returned should be the same instance from the UOW cache", (cachedEntity == entity ? 1 : 0) != 0);
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshWithEMProperties() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity = (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
            String updatedName = "testRefreshWithEMProperties";
            this.updateCacheableTrueEntityNameInSharedCache(updatedName);
            em.setProperty("javax.persistence.cache.retrieveMode", (Object)CacheRetrieveMode.USE);
            this.beginTransaction(em);
            try {
                cachedEntity = (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
                em.refresh((Object)cachedEntity);
                this.commitTransaction(em);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
            }
            finally {
                this.closeEM(em);
            }
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have been refreshed.", (boolean)cachedEntity.getName().equals(updatedName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshWithRefreshProperties() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity = (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
            String updatedName = "testRefreshWithRefreshProperties";
            this.updateCacheableTrueEntityNameInSharedCache(updatedName);
            HashMap<String, CacheRetrieveMode> properties = new HashMap<String, CacheRetrieveMode>();
            properties.put("javax.persistence.cache.retrieveMode", CacheRetrieveMode.USE);
            this.beginTransaction(em);
            try {
                cachedEntity = (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
                em.refresh((Object)cachedEntity, properties);
                this.commitTransaction(em);
            }
            catch (Exception ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
            }
            finally {
                this.closeEM(em);
            }
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have been refreshed.", (boolean)cachedEntity.getName().equals(updatedName));
        }
    }

    public void testRetrieveBYPASSStoreBYPASS1() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity = this.findCacheableTrueEntity(em, m_cacheableTrueEntity1Id);
            String updatedName = "testRetrieveBYPASSStoreBYPASS1";
            this.updateCacheableTrueEntityNameInSharedCache(updatedName);
            CacheableTrueEntity entity1 = this.findCacheableTrueEntity_BYPASS_BYPASS(em, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"The entity instances must be the same", (entity1 == cachedEntity ? 1 : 0) != 0);
            CacheableModelJunitTest.assertTrue((String)"The name should not of been refreshed", (boolean)entity1.getName().equals(cachedEntity.getName()));
            HashMap<String, CacheStoreMode> properties = new HashMap<String, CacheStoreMode>();
            properties.put("javax.persistence.cache.storeMode", CacheStoreMode.REFRESH);
            CacheableTrueEntity entity1b = (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id, properties);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should of been refreshed.", (boolean)entity1b.getName().equals(updatedName));
            this.closeEM(em);
            CacheableTrueEntity entity2 = this.findCacheableTrueEntity_BYPASS_BYPASS(null, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have been refreshed.", (boolean)entity2.getName().equals(updatedName));
        }
    }

    public void testRetrieveBYPASSStoreBYPASS2() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity = this.findCacheableTrueEntity(em, m_cacheableTrueEntity1Id);
            String updatedName = "testRetrieveBYPASSStoreBYPASS2";
            this.updateCacheableTrueEntityNameAndBypassStore(updatedName);
            CacheableTrueEntity entity1a = this.findCacheableTrueEntity_BYPASS_BYPASS(em, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"The entity returned should match the cached instance", (entity1a == cachedEntity ? 1 : 0) != 0);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have been refreshed.", (boolean)entity1a.getName().equals(cachedEntity.getName()));
            CacheableTrueEntity entity2 = this.findCacheableTrueEntity(null, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should not of been refreshed.", (boolean)entity2.getName().equals(entity1a.getName()));
            HashMap<String, CacheStoreMode> properties = new HashMap<String, CacheStoreMode>();
            properties.put("javax.persistence.cache.storeMode", CacheStoreMode.REFRESH);
            CacheableTrueEntity entity1b = (CacheableTrueEntity)em.find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id, properties);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should be from the shared cache.", (boolean)entity1b.getName().equals(updatedName));
            this.closeEM(em);
        }
    }

    public void testRetrieveBYPASSStoreUSE1() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity = this.findCacheableTrueEntity(em, m_cacheableTrueEntity1Id);
            String updatedName = "testRetrieveBYPASSStoreUSE1";
            this.updateCacheableTrueEntityNameInSharedCache(updatedName);
            CacheableTrueEntity entity1 = this.findCacheableTrueEntity_BYPASS_USE(em, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"The entity instances must be the same", (entity1 == cachedEntity ? 1 : 0) != 0);
            CacheableModelJunitTest.assertTrue((String)"The name should not of been refreshed", (boolean)entity1.getName().equals(cachedEntity.getName()));
            CacheableTrueEntity entity2 = this.findCacheableTrueEntity_USE_BYPASS(null, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have the name from the shared cache.", (boolean)entity2.getName().equals(updatedName));
            this.closeEM(em);
        }
    }

    public void testRetrieveBYPASSStoreUSE2() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity = this.findCacheableTrueEntity(em, m_cacheableTrueEntity1Id);
            String updatedName = "testRetrieveBYPASSStoreUSE2";
            this.updateCacheableTrueEntityNameAndBypassStore(updatedName);
            CacheableTrueEntity entity1 = this.findCacheableTrueEntity_BYPASS_USE(em, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"The entity instances must be the same", (entity1 == cachedEntity ? 1 : 0) != 0);
            CacheableModelJunitTest.assertTrue((String)"The name should not of been refreshed", (boolean)entity1.getName().equals(cachedEntity.getName()));
            this.closeEM(em);
            CacheableTrueEntity entity2 = this.findCacheableTrueEntity(null, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have the name from the shared cache.", (boolean)entity2.getName().equals(updatedName));
        }
    }

    public void testRetrieveUSEStoreBYPASS1() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity = this.findCacheableTrueEntity(em, m_cacheableTrueEntity1Id);
            String updatedName = "testRetrieveUSEStoreBYPASS1";
            this.updateCacheableTrueEntityNameInSharedCache(updatedName);
            CacheableTrueEntity entity1 = this.findCacheableTrueEntity_USE_BYPASS(em, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"The entity returned should match the cached instance", (entity1 == cachedEntity ? 1 : 0) != 0);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should not have been refreshed.", (boolean)entity1.getName().equals(cachedEntity.getName()));
            this.closeEM(em);
            CacheableTrueEntity entity2 = this.findCacheableTrueEntity_USE_BYPASS(null, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have the name from the shared cache.", (boolean)entity2.getName().equals(updatedName));
        }
    }

    public void testRetrieveUSEStoreBYPASS2() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em1 = this.createDSEntityManager();
            CacheableTrueEntity cachedEntity = this.findCacheableTrueEntity(em1, m_cacheableTrueEntity1Id);
            String updatedName = "testRetrieveUSEStoreBYPASS2";
            this.updateCacheableTrueEntityNameAndBypassStore(updatedName);
            CacheableTrueEntity entity1 = this.findCacheableTrueEntity_USE_BYPASS(em1, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"The entity returned should match the cached instance", (entity1 == cachedEntity ? 1 : 0) != 0);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should not have been refreshed.", (boolean)entity1.getName().equals(cachedEntity.getName()));
            this.closeEM(em1);
            EntityManager em2 = this.createDSEntityManager();
            CacheableTrueEntity entity2 = this.findCacheableTrueEntity(em2, m_cacheableTrueEntity1Id);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have the name from the shared cache.", (boolean)entity2.getName().equals(entity1.getName()));
            em2.refresh((Object)entity2);
            CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have the name from database.", (boolean)entity2.getName().equals(updatedName));
            this.closeEM(em2);
        }
    }

    public void testInheritanceCacheable() {
        EntityManager em1 = this.createDSEntityManager();
        this.beginTransaction(em1);
        CacheableTrueEntity cacheableEntity1 = new CacheableTrueEntity();
        cacheableEntity1.setName("cacheableEntity");
        em1.persist((Object)cacheableEntity1);
        ChildCacheableFalseEntity nonCacheableEntity1 = new ChildCacheableFalseEntity();
        nonCacheableEntity1.setName("nonCacheableEntity");
        em1.persist((Object)nonCacheableEntity1);
        this.commitTransaction(em1);
        this.closeEM(em1);
        EntityManager em2 = this.createDSEntityManager();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("eclipselink.cache-usage", "CheckCacheOnly");
        CacheableTrueEntity cacheableEntity2 = (CacheableTrueEntity)em2.find(CacheableTrueEntity.class, (Object)cacheableEntity1.getId(), props);
        CacheableTrueEntity nonCacheableEntity2a = (CacheableTrueEntity)em2.find(CacheableTrueEntity.class, (Object)nonCacheableEntity1.getId(), props);
        ChildCacheableFalseEntity nonCacheableEntity2b = (ChildCacheableFalseEntity)em2.find(ChildCacheableFalseEntity.class, (Object)nonCacheableEntity1.getId(), props);
        CacheableModelJunitTest.assertFalse((String)"CacheableTrueEntity was not in the cache", (cacheableEntity2 == null ? 1 : 0) != 0);
        CacheableModelJunitTest.assertTrue((String)"ChildCacheableFalseEntity was in the cache", (nonCacheableEntity2a == null ? 1 : 0) != 0);
        CacheableModelJunitTest.assertTrue((String)"ChildCacheableFalseEntity was in the cache", (nonCacheableEntity2b == null ? 1 : 0) != 0);
        this.closeEM(em2);
    }

    public void testMultipleEMQueries() {
        CacheableTrueEntity cachedEntity = (CacheableTrueEntity)this.createDSEntityManager().find(CacheableTrueEntity.class, (Object)m_cacheableTrueEntity1Id);
        String updatedName = "testMultipleEMQueries";
        this.updateCacheableTrueEntityNameAndBypassStore(updatedName);
        CacheableTrueEntity entity1 = this.findCacheableTrueEntity_USE_BYPASS(null, m_cacheableTrueEntity1Id);
        CacheableModelJunitTest.assertFalse((String)"CacheableTrueEntity should not have the updated name.", (boolean)entity1.getName().equals(updatedName));
        CacheableTrueEntity entity2 = this.findCacheableTrueEntity_BYPASS_USE(null, m_cacheableTrueEntity1Id);
        CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have the updated name.", (boolean)entity2.getName().equals(updatedName));
        CacheableTrueEntity entity3 = this.findCacheableTrueEntity_USE_BYPASS(null, m_cacheableTrueEntity1Id);
        CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity should have the updated name.", (boolean)entity3.getName().equals(updatedName));
    }

    public void testCachingOnALL() {
        ServerSession session = this.getPUServerSession("ALL");
        ClassDescriptor falseEntityDescriptor = session.getDescriptorForAlias("JPA_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertFalse((String)"CacheableFalseEntity (ALL) from annotations has caching turned off", (boolean)this.usesNoCache(falseEntityDescriptor));
        ClassDescriptor trueEntityDescriptor = session.getDescriptorForAlias("JPA_CACHEABLE_TRUE");
        CacheableModelJunitTest.assertFalse((String)"CacheableTrueEntity (ALL) from annotations has caching turned off", (boolean)this.usesNoCache(trueEntityDescriptor));
        ClassDescriptor protectedEntityDescriptor = session.getDescriptorForAlias("JPA_CACHEABLE_PROTECTED");
        CacheableModelJunitTest.assertFalse((String)"CacheableProtectedEntity (ALL) from annotations has caching turned off", (boolean)this.usesNoCache(protectedEntityDescriptor));
        ClassDescriptor childFalseEntityDescriptor = session.getDescriptorForAlias("JPA_CHILD_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertFalse((String)"ChildCacheableFalseEntity (ALL) from annotations has caching turned off", (boolean)this.usesNoCache(childFalseEntityDescriptor));
        ClassDescriptor falseSubEntityDescriptor = session.getDescriptorForAlias("JPA_SUB_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertFalse((String)"SubCacheableFalseEntity (ALL) from annotations has caching turned off", (boolean)this.usesNoCache(falseSubEntityDescriptor));
        ClassDescriptor noneSubEntityDescriptor = session.getDescriptorForAlias("JPA_SUB_CACHEABLE_NONE");
        CacheableModelJunitTest.assertFalse((String)"SubCacheableNoneEntity (ALL) from annotations has caching turned off", (boolean)this.usesNoCache(noneSubEntityDescriptor));
        ClassDescriptor xmlFalseEntityDescriptor = session.getDescriptorForAlias("XML_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertFalse((String)"CacheableFalseEntity (ALL) from XML has caching turned off", (boolean)this.usesNoCache(xmlFalseEntityDescriptor));
        ClassDescriptor xmlTrueEntityDescriptor = session.getDescriptorForAlias("XML_CACHEABLE_TRUE");
        CacheableModelJunitTest.assertFalse((String)"CacheableTrueEntity (ALL) from XML has caching turned ff", (boolean)this.usesNoCache(xmlTrueEntityDescriptor));
        ClassDescriptor xmlFalseSubEntityDescriptor = session.getDescriptorForAlias("XML_SUB_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertFalse((String)"SubCacheableFalseEntity (ALL) from XML has caching turned off", (boolean)this.usesNoCache(xmlFalseSubEntityDescriptor));
        ClassDescriptor xmlNoneSubEntityDescriptor = session.getDescriptorForAlias("XML_SUB_CACHEABLE_NONE");
        CacheableModelJunitTest.assertFalse((String)"SubCacheableTrueEntity (ALL) from XML has caching turned off", (boolean)this.usesNoCache(xmlNoneSubEntityDescriptor));
    }

    public void testCachingOnNONE() {
        ServerSession session = this.getPUServerSession("NONE");
        ClassDescriptor falseEntityDescriptor = session.getDescriptorForAlias("JPA_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"CacheableFalseEntity (NONE) from annotations has caching turned on", (boolean)this.usesNoCache(falseEntityDescriptor));
        ClassDescriptor trueEntityDescriptor = session.getDescriptorForAlias("JPA_CACHEABLE_TRUE");
        CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity (NONE) from annotations has caching turned on", (boolean)this.usesNoCache(trueEntityDescriptor));
        ClassDescriptor protectedEntityDescriptor = session.getDescriptorForAlias("JPA_CACHEABLE_PROTECTED");
        CacheableModelJunitTest.assertTrue((String)"CacheableProtectedEntity (ALL) from annotations has caching turned off", (boolean)this.usesNoCache(protectedEntityDescriptor));
        ClassDescriptor childFalseEntityDescriptor = session.getDescriptorForAlias("JPA_CHILD_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"ChildCacheableFalseEntity (NONE) from annotations has caching turned on", (boolean)this.usesNoCache(childFalseEntityDescriptor));
        ClassDescriptor falseSubEntityDescriptor = session.getDescriptorForAlias("JPA_SUB_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"SubCacheableFalseEntity (NONE) from annotations has caching turned on", (boolean)this.usesNoCache(falseSubEntityDescriptor));
        ClassDescriptor noneSubEntityDescriptor = session.getDescriptorForAlias("JPA_SUB_CACHEABLE_NONE");
        CacheableModelJunitTest.assertTrue((String)"SubCacheableNoneEntity (NONE) from annotations has caching turned on", (boolean)this.usesNoCache(noneSubEntityDescriptor));
        ClassDescriptor xmlFalseEntityDescriptor = session.getDescriptorForAlias("XML_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"CacheableFalseEntity (NONE) from XML has caching turned on", (boolean)this.usesNoCache(xmlFalseEntityDescriptor));
        ClassDescriptor xmlTrueEntityDescriptor = session.getDescriptorForAlias("XML_CACHEABLE_TRUE");
        CacheableModelJunitTest.assertTrue((String)"CacheableTrueEntity (NONE) from XML has caching turned on", (boolean)this.usesNoCache(xmlTrueEntityDescriptor));
        ClassDescriptor xmlFalseSubEntityDescriptor = session.getDescriptorForAlias("XML_SUB_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"SubCacheableFalseEntity (NONE) from XML has caching turned on", (boolean)this.usesNoCache(xmlFalseSubEntityDescriptor));
        ClassDescriptor xmlNoneSubEntityDescriptor = session.getDescriptorForAlias("XML_SUB_CACHEABLE_NONE");
        CacheableModelJunitTest.assertTrue((String)"SubCacheableTrueEntity (NONE) from XML has caching turned on", (boolean)this.usesNoCache(xmlNoneSubEntityDescriptor));
    }

    public void testCachingOnENABLE_SELECTIVE() {
        ServerSession session = this.getPUServerSession("ENABLE_SELECTIVE");
        ClassDescriptor falseEntityDescriptor = session.getDescriptorForAlias("JPA_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"CacheableFalseEntity (ENABLE_SELECTIVE) from annotations has caching turned on", (boolean)this.usesNoCache(falseEntityDescriptor));
        ClassDescriptor trueEntityDescriptor = session.getDescriptorForAlias("JPA_CACHEABLE_TRUE");
        CacheableModelJunitTest.assertFalse((String)"CacheableTrueEntity (ENABLE_SELECTIVE) from annotations has caching turned off", (boolean)this.usesNoCache(trueEntityDescriptor));
        ClassDescriptor childFalseEntityDescriptor = session.getDescriptorForAlias("JPA_CHILD_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"ChildCacheableFalseEntity (ENABLE_SELECTIVE) from annotations has caching turned on", (boolean)this.usesNoCache(childFalseEntityDescriptor));
        ClassDescriptor falseSubEntityDescriptor = session.getDescriptorForAlias("JPA_SUB_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"SubCacheableFalseEntity (ENABLE_SELECTIVE) from annotations has caching turned on", (boolean)this.usesNoCache(falseSubEntityDescriptor));
        ClassDescriptor noneSubEntityDescriptor = session.getDescriptorForAlias("JPA_SUB_CACHEABLE_NONE");
        CacheableModelJunitTest.assertFalse((String)"SubCacheableNoneEntity (ENABLE_SELECTIVE) from annotations has caching turned off", (boolean)this.usesNoCache(noneSubEntityDescriptor));
        ClassDescriptor xmlFalseEntityDescriptor = session.getDescriptorForAlias("XML_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"CacheableFalseEntity (ENABLE_SELECTIVE) from XML has caching turned on", (boolean)this.usesNoCache(xmlFalseEntityDescriptor));
        ClassDescriptor xmlTrueEntityDescriptor = session.getDescriptorForAlias("XML_CACHEABLE_TRUE");
        CacheableModelJunitTest.assertFalse((String)"CacheableTrueEntity (ENABLE_SELECTIVE) from XML has caching turned off", (boolean)this.usesNoCache(xmlTrueEntityDescriptor));
        ClassDescriptor xmlFalseSubEntityDescriptor = session.getDescriptorForAlias("XML_SUB_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"SubCacheableFalseEntity (ENABLE_SELECTIVE) from XML has caching turned on", (boolean)this.usesNoCache(xmlFalseSubEntityDescriptor));
        ClassDescriptor xmlNoneSubEntityDescriptor = session.getDescriptorForAlias("XML_SUB_CACHEABLE_NONE");
        CacheableModelJunitTest.assertFalse((String)"SubCacheableNoneEntity (ENABLE_SELECTIVE) from XML has caching turned off", (boolean)this.usesNoCache(xmlNoneSubEntityDescriptor));
    }

    public void testCachingOnDISABLE_SELECTIVE() {
        ServerSession session = this.getPUServerSession("DISABLE_SELECTIVE");
        ClassDescriptor falseEntityDescriptor = session.getDescriptorForAlias("JPA_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"CacheableFalseEntity (DISABLE_SELECTIVE) from annotations has caching turned on", (boolean)this.usesNoCache(falseEntityDescriptor));
        ClassDescriptor trueEntityDescriptor = session.getDescriptorForAlias("JPA_CACHEABLE_TRUE");
        CacheableModelJunitTest.assertFalse((String)"CacheableTrueEntity (DISABLE_SELECTIVE) from annotations has caching turned off", (boolean)this.usesNoCache(trueEntityDescriptor));
        ClassDescriptor childFalseEntityDescriptor = session.getDescriptorForAlias("JPA_CHILD_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"ChildCacheableFalseEntity (DISABLE_SELECTIVE) from annotations has caching turned on", (boolean)this.usesNoCache(childFalseEntityDescriptor));
        ClassDescriptor falseSubEntityDescriptor = session.getDescriptorForAlias("JPA_SUB_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"SubCacheableFalseEntity (DISABLE_SELECTIVE) from annotations has caching turned on", (boolean)this.usesNoCache(falseSubEntityDescriptor));
        ClassDescriptor noneSubEntityDescriptor = session.getDescriptorForAlias("JPA_SUB_CACHEABLE_NONE");
        CacheableModelJunitTest.assertFalse((String)"SubCacheableNoneEntity (DISABLE_SELECTIVE) from annotations has caching turned off", (boolean)this.usesNoCache(noneSubEntityDescriptor));
        ClassDescriptor xmlFalseEntityDescriptor = session.getDescriptorForAlias("XML_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"CacheableFalseEntity (DISABLE_SELECTIVE) from XML has caching turned on", (boolean)this.usesNoCache(xmlFalseEntityDescriptor));
        ClassDescriptor xmlTrueEntityDescriptor = session.getDescriptorForAlias("XML_CACHEABLE_TRUE");
        CacheableModelJunitTest.assertFalse((String)"CacheableTrueEntity (DISABLE_SELECTIVE) from XML has caching turned off", (boolean)this.usesNoCache(xmlTrueEntityDescriptor));
        ClassDescriptor xmlFalseSubEntityDescriptor = session.getDescriptorForAlias("XML_SUB_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"SubCacheableFalseEntity (DISABLE_SELECTIVE) from XML has caching turned on", (boolean)this.usesNoCache(xmlFalseSubEntityDescriptor));
        ClassDescriptor xmlNoneSubEntityDescriptor = session.getDescriptorForAlias("XML_SUB_CACHEABLE_NONE");
        CacheableModelJunitTest.assertFalse((String)"SubCacheableNoneEntity (DISABLE_SELECTIVE) from XML has caching turned off", (boolean)this.usesNoCache(xmlNoneSubEntityDescriptor));
    }

    public void testCachingOnUNSPECIFIED() {
        ServerSession session = this.getPUServerSession("UNSPECIFIED");
        ClassDescriptor falseEntityDescriptor = session.getDescriptorForAlias("JPA_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"CacheableFalseEntity (UNSPECIFIED) from annotations has caching turned on", (boolean)this.usesNoCache(falseEntityDescriptor));
        ClassDescriptor trueEntityDescriptor = session.getDescriptorForAlias("JPA_CACHEABLE_TRUE");
        CacheableModelJunitTest.assertFalse((String)"CacheableTrueEntity (UNSPECIFIED) from annotations has caching turned off", (boolean)this.usesNoCache(trueEntityDescriptor));
        ClassDescriptor childFalseEntityDescriptor = session.getDescriptorForAlias("JPA_CHILD_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"ChildCacheableFalseEntity (UNSPECIFIED) from annotations has caching turned on", (boolean)this.usesNoCache(childFalseEntityDescriptor));
        ClassDescriptor falseSubEntityDescriptor = session.getDescriptorForAlias("JPA_SUB_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"SubCacheableFalseEntity (UNSPECIFIED) from annotations has caching turned on", (boolean)this.usesNoCache(falseSubEntityDescriptor));
        ClassDescriptor noneSubEntityDescriptor = session.getDescriptorForAlias("JPA_SUB_CACHEABLE_NONE");
        CacheableModelJunitTest.assertFalse((String)"SubCacheableNoneEntity (UNSPECIFIED) from annotations has caching turned off", (boolean)this.usesNoCache(noneSubEntityDescriptor));
        ClassDescriptor xmlFalseEntityDescriptor = session.getDescriptorForAlias("XML_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"CacheableFalseEntity (UNSPECIFIED) from XML has caching turned on", (boolean)this.usesNoCache(xmlFalseEntityDescriptor));
        ClassDescriptor xmlTrueEntityDescriptor = session.getDescriptorForAlias("XML_CACHEABLE_TRUE");
        CacheableModelJunitTest.assertFalse((String)"CacheableTrueEntity (UNSPECIFIED) from XML has caching turned off", (boolean)this.usesNoCache(xmlTrueEntityDescriptor));
        ClassDescriptor xmlFalseSubEntityDescriptor = session.getDescriptorForAlias("XML_SUB_CACHEABLE_FALSE");
        CacheableModelJunitTest.assertTrue((String)"SubCacheableFalseEntity (UNSPECIFIED) from XML has caching turned on", (boolean)this.usesNoCache(xmlFalseSubEntityDescriptor));
        ClassDescriptor xmlNoneSubEntityDescriptor = session.getDescriptorForAlias("XML_SUB_CACHEABLE_NONE");
        CacheableModelJunitTest.assertFalse((String)"SubCacheableNoneEntity (UNSPECIFIED) from XML has caching turned off", (boolean)this.usesNoCache(xmlNoneSubEntityDescriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateEntities() {
        EntityManager em = null;
        try {
            em = !CacheableModelJunitTest.isOnServer() ? CacheableModelJunitTest.createEntityManager((String)"DISABLE_SELECTIVE") : CacheableModelJunitTest.createEntityManager((String)"MulitPU-4");
            this.beginTransaction(em);
            CacheableTrueEntity cacheableTrueEntity = new CacheableTrueEntity();
            cacheableTrueEntity.setName("testCreateEntities");
            em.persist((Object)cacheableTrueEntity);
            m_cacheableTrueEntity1Id = cacheableTrueEntity.getId();
            CacheableForceProtectedEntity cacheableForceProtectedEntity = new CacheableForceProtectedEntity();
            cacheableForceProtectedEntity.setName("testCreateEntities");
            em.persist((Object)cacheableForceProtectedEntity);
            m_cacheableForceProtectedEntity1Id = cacheableForceProtectedEntity.getId();
            CacheableFalseEntity cacheableFalseEntity = new CacheableFalseEntity();
            em.persist((Object)cacheableFalseEntity);
            cacheableForceProtectedEntity.setCacheableFalse(cacheableFalseEntity);
            CacheableProtectedEntity cacheableProtectedEntity = new CacheableProtectedEntity();
            em.persist((Object)cacheableProtectedEntity);
            m_cacheableProtectedEntityId = cacheableProtectedEntity.getId();
            cacheableFalseEntity.setProtectedEntity(cacheableProtectedEntity);
            CacheableTrueEntity cacheableTrueEntity2 = new CacheableTrueEntity();
            cacheableTrueEntity2.setName("testCreateEntities");
            em.persist((Object)cacheableTrueEntity2);
            m_cacheableTrueEntity2Id = cacheableTrueEntity2.getId();
            ChildCacheableFalseEntity childCacheableFalseEntity = new ChildCacheableFalseEntity();
            childCacheableFalseEntity.setName("testCreateEntities");
            em.persist((Object)childCacheableFalseEntity);
            m_childCacheableFalseEntityId = childCacheableFalseEntity.getId();
            ForceProtectedEntityWithComposite fpewc = new ForceProtectedEntityWithComposite();
            fpewc.setName("testCreateEntities");
            ProtectedEmbeddable pe = new ProtectedEmbeddable();
            fpewc.setProtectedEmbeddable(pe);
            CacheableFalseEntity cfe = new CacheableFalseEntity();
            pe.setCacheableFalseEntity(cfe);
            SharedEmbeddable se = new SharedEmbeddable();
            fpewc.setSharedEmbeddable(se);
            em.persist((Object)fpewc);
            m_forcedProtectedEntityCompositId = fpewc.getId();
            em.persist((Object)cfe);
            CacheableFalseDetail cacheableFalseDetailEntity = new CacheableFalseDetail();
            em.persist((Object)cacheableFalseDetailEntity);
            CacheableRelationshipsEntity prse = new CacheableRelationshipsEntity();
            prse.setName("Test OneToMany");
            prse.addCacheableFalse(cacheableFalseEntity);
            prse.addCacheableProtected(cacheableProtectedEntity);
            prse.setCacheableFPE(cacheableForceProtectedEntity);
            prse.addCacheableFalseDetail(cacheableFalseDetailEntity);
            prse.addProtectedEmbeddable(pe);
            em.persist((Object)prse);
            m_cacheableRelationshipsEntityId = prse.getId();
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testDetailsOrder_Isolated() {
        this.testDetailsOrder(false, false);
    }

    public void testDetailsOrder_Isolated_BeginEarlyTransaction() {
        this.testDetailsOrder(false, true);
    }

    public void testDetailsOrder_Shared() {
        this.testDetailsOrder(true, false);
    }

    public void testDetailsOrder_Shared_BeginEarlyTransaction() {
        this.testDetailsOrder(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testDetailsOrder(boolean useSharedCache, boolean beginEarlyTransaction) {
        int entityId;
        CacheableFalseDetail detail;
        int i;
        CacheableFalseEntity entity;
        String puName;
        String string = puName = useSharedCache ? "ALL" : "NONE";
        if (CacheableModelJunitTest.isOnServer()) {
            puName = useSharedCache ? "MulitPU-1" : "MulitPU-2";
        }
        int nDetails = 2;
        EntityManager em = CacheableModelJunitTest.createEntityManager((String)puName);
        try {
            this.beginTransaction(em);
            entity = new CacheableFalseEntity();
            for (i = 0; i < nDetails; ++i) {
                detail = new CacheableFalseDetail();
                detail.setDescription(Integer.toString(i));
                entity.getDetails().add(detail);
            }
            em.persist((Object)entity);
            this.commitTransaction(em);
            entityId = entity.getId();
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        try {
            int iExpected;
            CacheableModelJunitTest.clearCache((String)puName);
            em = CacheableModelJunitTest.createEntityManager((String)puName);
            try {
                this.beginTransaction(em);
                if (beginEarlyTransaction) {
                    em.setProperty("eclipselink.transaction.join-existing", (Object)"true");
                }
                CacheableModelJunitTest.assertTrue((String)"Read back wrong number of details", (nDetails == (entity = (CacheableFalseEntity)em.find(CacheableFalseEntity.class, (Object)entityId)).getDetails().size() ? 1 : 0) != 0);
                for (i = 0; i < nDetails; ++i) {
                    detail = (CacheableFalseDetail)entity.getDetails().get(i);
                    iExpected = Integer.parseInt(detail.getDescription());
                    CacheableModelJunitTest.assertTrue((String)("Wrong index " + i + "; was expected " + iExpected), (i == iExpected ? 1 : 0) != 0);
                }
                ArrayList copyDetails = new ArrayList(entity.getDetails());
                entity.getDetails().clear();
                for (int i2 = nDetails - 1; i2 >= 0; --i2) {
                    entity.getDetails().add(copyDetails.get(i2));
                }
                this.commitTransaction(em);
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
            CacheableModelJunitTest.clearCache((String)puName);
            em = CacheableModelJunitTest.createEntityManager((String)puName);
            try {
                this.beginTransaction(em);
                if (beginEarlyTransaction) {
                    em.setProperty("eclipselink.transaction.join-existing", (Object)"true");
                }
                CacheableModelJunitTest.assertTrue((String)"After reverse read back wrong number of details", (nDetails == (entity = (CacheableFalseEntity)em.find(CacheableFalseEntity.class, (Object)entityId)).getDetails().size() ? 1 : 0) != 0);
                for (int i3 = 0; i3 < nDetails; ++i3) {
                    CacheableFalseDetail detail2 = (CacheableFalseDetail)entity.getDetails().get(i3);
                    iExpected = nDetails - Integer.parseInt(detail2.getDescription()) - 1;
                    CacheableModelJunitTest.assertTrue((String)("After reverse wrong index " + i3 + "; was expected " + iExpected), (i3 == iExpected ? 1 : 0) != 0);
                }
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
        }
        finally {
            em = CacheableModelJunitTest.createEntityManager((String)puName);
            try {
                this.beginTransaction(em);
                entity = (CacheableFalseEntity)em.find(CacheableFalseEntity.class, (Object)entityId);
                em.remove((Object)entity);
                this.commitTransaction(em);
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoadMixedCacheTree() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        try {
            CacheableForceProtectedEntity cte = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)m_cacheableForceProtectedEntity1Id);
            CacheableModelJunitTest.assertNotNull((String)"Did not load the CacheableTrue Entity", (Object)cte);
            CacheableFalseEntity cfe = cte.getCacheableFalse();
            CacheableModelJunitTest.assertNotNull((String)"Did not load the CacheableFalse related Entity", (Object)cfe);
            CacheableProtectedEntity cpe = cfe.getProtectedEntity();
            CacheableModelJunitTest.assertNotNull((String)"Did not load the Cacheable Protected related Entity", (Object)cpe);
            CacheableRelationshipsEntity cre = (CacheableRelationshipsEntity)em.find(CacheableRelationshipsEntity.class, (Object)m_cacheableRelationshipsEntityId);
            CacheableModelJunitTest.assertNotNull((String)"Did not load the CacheableRelationshipsEntity", (Object)cre);
            List cacheableFalses = cre.getCacheableFalses();
            CacheableModelJunitTest.assertNotNull((String)"Did not load collections of CacheableRelationshipsEntity related(OneToMany) CacheableFalseEntity", (Object)cacheableFalses);
            List cacheableProtects = cre.getCacheableProtecteds();
            CacheableModelJunitTest.assertNotNull((String)"Did not load collections of CacheableRelationshipsEntity related(OneToMany) CacheableProtectedEntity", (Object)cacheableProtects);
            CacheableForceProtectedEntity cfpe = cre.getCacheableFPE();
            CacheableModelJunitTest.assertNotNull((String)"Did not load the CacheableRelationshipsEntity related(ManyToOne) CacheableForceProtectedEntity", (Object)cfpe);
            List cacheableFalseDetails = cre.getCacheableFalseDetails();
            CacheableModelJunitTest.assertNotNull((String)"Did not load collections of CacheableRelationshipsEntity related(ManyToMany) CacheableFalseDetail", (Object)cacheableFalseDetails);
            List protectedEmbed = cre.getProtectedEmbeddables();
            CacheableModelJunitTest.assertNotNull((String)"Did not load collections of CacheableRelationshipsEntity related(ElementCollection) ProtectedEmbeddable", (Object)protectedEmbed);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsolatedIsolation() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        try {
            CacheableForceProtectedEntity cte = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)m_cacheableForceProtectedEntity1Id);
            CacheableFalseEntity cfe = cte.getCacheableFalse();
            CacheableModelJunitTest.assertNull((String)"An isolated Entity was found in the shared cache", (Object)((ServerSession)em.unwrap(ServerSession.class)).getIdentityMapAccessor().getFromIdentityMap((Object)cfe));
            CacheableRelationshipsEntity cre = (CacheableRelationshipsEntity)em.find(CacheableRelationshipsEntity.class, (Object)m_cacheableRelationshipsEntityId);
            for (CacheableFalseEntity cfe1 : cre.getCacheableFalses()) {
                CacheableModelJunitTest.assertNull((String)"An isolated Entity in many side of OneToMany relationship was found in the shared cache", (Object)((ServerSession)em.unwrap(ServerSession.class)).getIdentityMapAccessor().getFromIdentityMap((Object)cfe1));
            }
            for (CacheableFalseDetail cfde1 : cre.getCacheableFalseDetails()) {
                CacheableModelJunitTest.assertNull((String)"An isolated Entity in many side of ManyToMany relationship was found in the shared cache", (Object)((ServerSession)em.unwrap(ServerSession.class)).getIdentityMapAccessor().getFromIdentityMap((Object)cfde1));
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProtectedIsolation() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        try {
            CacheableForceProtectedEntity cte = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)m_cacheableForceProtectedEntity1Id);
            CacheableFalseEntity cfe = cte.getCacheableFalse();
            CacheableProtectedEntity cpe = cfe.getProtectedEntity();
            ServerSession session = (ServerSession)em.unwrap(ServerSession.class);
            CacheableModelJunitTest.assertNull((String)"An protected relationshipwas found in the shared cache", (Object)((CacheableForceProtectedEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cte)).getCacheableFalse());
            CacheableRelationshipsEntity cre = (CacheableRelationshipsEntity)em.find(CacheableRelationshipsEntity.class, (Object)m_cacheableRelationshipsEntityId);
            for (CacheableProtectedEntity cpe1 : ((CacheableRelationshipsEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cre)).getCacheableProtecteds()) {
                CacheableModelJunitTest.assertNotNull((String)"An protected relationship in OneToMany was not found in the shared cache", (Object)cpe1);
            }
            CacheableModelJunitTest.assertNotNull((String)"An protected relationship in ManyToOne was found in the shared cache", (Object)((CacheableRelationshipsEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cre)).getCacheableFPE());
            for (ProtectedEmbeddable cpe2 : ((CacheableRelationshipsEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cre)).getProtectedEmbeddables()) {
                CacheableModelJunitTest.assertNull((String)"An protected relationship in ElementCollection was found in the shared cache", (Object)cpe2);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEM(em);
        }
    }

    public void testForceProtectedFromEmbeddable() {
        EntityManager em = this.createDSEntityManager();
        ClassDescriptor forcedProtectedDescriptor = ((ServerSession)em.unwrap(ServerSession.class)).getDescriptor(ForceProtectedEntityWithComposite.class);
        ClassDescriptor protectedEmbeddableDesc = forcedProtectedDescriptor.getMappingForAttributeName("protectedEmbeddable").getReferenceDescriptor();
        ClassDescriptor sharedEmbeddableDesc = forcedProtectedDescriptor.getMappingForAttributeName("sharedEmbeddable").getReferenceDescriptor();
        CacheableModelJunitTest.assertFalse((String)"Isolation of Entity not altered when embeddable has noncacheable relationship", (boolean)forcedProtectedDescriptor.isSharedIsolation());
        CacheableModelJunitTest.assertFalse((String)"Isolation of Embeddable not altered when embeddable has noncacheable relationship", (boolean)protectedEmbeddableDesc.isSharedIsolation());
        CacheableModelJunitTest.assertFalse((String)"Isolation of Embeddable not altered when Parent Entity is Protected", (boolean)sharedEmbeddableDesc.isSharedIsolation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmbeddableProtectedCaching() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        try {
            ForceProtectedEntityWithComposite cte = (ForceProtectedEntityWithComposite)em.find(ForceProtectedEntityWithComposite.class, (Object)m_forcedProtectedEntityCompositId);
            CacheableRelationshipsEntity cre = (CacheableRelationshipsEntity)em.find(CacheableRelationshipsEntity.class, (Object)m_cacheableRelationshipsEntityId);
            System.out.println("====the size of the collection is 1--" + cre.getProtectedEmbeddables().size());
            ProtectedEmbeddable pe = cte.getProtectedEmbeddable();
            ServerSession session = (ServerSession)em.unwrap(ServerSession.class);
            this.commitTransaction(em);
            this.closeEM(em);
            ForceProtectedEntityWithComposite cachedCPE = (ForceProtectedEntityWithComposite)session.getIdentityMapAccessor().getFromIdentityMap((Object)cte);
            CacheableRelationshipsEntity cachedCRE = (CacheableRelationshipsEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cre);
            CacheableModelJunitTest.assertNotNull((String)"ForceProtectedEntityWithComposite was not found in the cache", (Object)cachedCPE);
            CacheableModelJunitTest.assertNotNull((String)"CacheableRelationshipsEntity was not found in the cache", (Object)cachedCRE);
            cachedCPE.getProtectedEmbeddable().setName("NewName" + System.currentTimeMillis());
            System.out.println("====the size of the collection is 2--" + cachedCRE.getProtectedEmbeddables().size());
            em = this.createDSEntityManager();
            this.beginTransaction(em);
            ForceProtectedEntityWithComposite managedCPE = (ForceProtectedEntityWithComposite)em.find(ForceProtectedEntityWithComposite.class, (Object)cte.getId());
            CacheableRelationshipsEntity managedCRE = (CacheableRelationshipsEntity)em.find(CacheableRelationshipsEntity.class, (Object)cre.getId());
            CacheableModelJunitTest.assertEquals((String)"Cache was not used for Protected Isolation", (String)cachedCPE.getProtectedEmbeddable().getName(), (String)managedCPE.getProtectedEmbeddable().getName());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEM(em);
        }
    }

    public void testEmbeddableProtectedReadOnly() {
        EntityManager em = this.createDSEntityManager();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.read-only", "true");
        ForceProtectedEntityWithComposite cte = null;
        try {
            cte = (ForceProtectedEntityWithComposite)em.find(ForceProtectedEntityWithComposite.class, (Object)m_forcedProtectedEntityCompositId, properties);
        }
        catch (Exception e) {
            CacheableModelJunitTest.fail((String)("Exception while trying to do a read-only find to an protected entity with an embeddable: " + e.getMessage()));
        }
        CacheableModelJunitTest.assertNotNull((String)"Protected entity did not have aggregate when read back.", (Object)cte.getProtectedEmbeddable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProtectedCaching() {
        if (!CacheableModelJunitTest.isOnServer()) {
            EntityManager em = this.createDSEntityManager();
            this.beginTransaction(em);
            try {
                CacheableForceProtectedEntity cte = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)m_cacheableForceProtectedEntity1Id);
                CacheableFalseEntity cfe = cte.getCacheableFalse();
                CacheableProtectedEntity cpe = cfe.getProtectedEntity();
                CacheableRelationshipsEntity cre = (CacheableRelationshipsEntity)em.find(CacheableRelationshipsEntity.class, (Object)m_cacheableRelationshipsEntityId);
                List cacheableProtects = cre.getCacheableProtecteds();
                CacheableForceProtectedEntity cfpe = cre.getCacheableFPE();
                ServerSession session = (ServerSession)em.unwrap(ServerSession.class);
                this.closeEM(em);
                CacheableProtectedEntity cachedCPE = (CacheableProtectedEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cpe);
                CacheableModelJunitTest.assertNotNull((String)"CacheableProtectedEntity was not found in the cache", (Object)cachedCPE);
                CacheableForceProtectedEntity cachedCFPE = (CacheableForceProtectedEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cfpe);
                CacheableModelJunitTest.assertNotNull((String)"CacheableForceProtectedEntity from ManyToOne relationship was not found in the cache", (Object)cachedCFPE);
                for (CacheableProtectedEntity cpe1 : cacheableProtects) {
                    CacheableProtectedEntity cachedCPE1 = (CacheableProtectedEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cpe1);
                    CacheableModelJunitTest.assertNotNull((String)"CacheableProtectedEntity from OneToMany relationship was not found in the cache", (Object)cachedCPE1);
                }
                cachedCPE.setName("NewName" + System.currentTimeMillis());
                cachedCFPE.setName("NewName" + System.currentTimeMillis());
                em = this.createDSEntityManager();
                this.beginTransaction(em);
                CacheableProtectedEntity managedCPE = (CacheableProtectedEntity)em.find(CacheableProtectedEntity.class, (Object)cpe.getId());
                CacheableForceProtectedEntity managedCFPE = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)cfpe.getId());
                CacheableModelJunitTest.assertEquals((String)"Cache was not used for Protected Isolation", (String)cachedCPE.getName(), (String)managedCPE.getName());
                CacheableModelJunitTest.assertEquals((String)"Cache was not used for Protected Isolation", (String)cachedCFPE.getName(), (String)managedCFPE.getName());
            }
            finally {
                this.rollbackTransaction(em);
                this.closeEM(em);
            }
        }
    }

    public void testProtectedRelationshipsMetadata() {
        EntityManager em = this.createDSEntityManager();
        ServerSession session = (ServerSession)em.unwrap(ServerSession.class);
        ClassDescriptor descriptor = session.getDescriptor(ProtectedRelationshipsEntity.class);
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            if (mapping.isDirectToFieldMapping()) continue;
            CacheableModelJunitTest.assertTrue((String)"Relationship NONCacheable metadata was not processed correctly", (!mapping.isCacheable() ? 1 : 0) != 0);
        }
        descriptor = session.getDescriptorForAlias("XML_ROTECTED_RELATIONSHIPS");
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            if (mapping.isDirectToFieldMapping()) continue;
            CacheableModelJunitTest.assertTrue((String)"Relationship NONCacheable metadata was not processed correctly", (!mapping.isCacheable() ? 1 : 0) != 0);
        }
        this.closeEM(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlyTree() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("Select c from JPA_CACHEABLE_FORCE_PROTECTED c");
            q.setHint("eclipselink.read-only", (Object)"true");
            CacheableForceProtectedEntity cte = (CacheableForceProtectedEntity)q.getResultList().get(0);
            CacheableModelJunitTest.assertNotNull((String)"Did not load the CacheableTrue Entity", (Object)cte);
            CacheableFalseEntity cfe = cte.getCacheableFalse();
            CacheableModelJunitTest.assertNotNull((String)"Did not load the CacheableFalse related Entity", (Object)cfe);
            CacheableProtectedEntity cpe = cfe.getProtectedEntity();
            CacheableModelJunitTest.assertNotNull((String)"Did not load the Cacheable Protected related Entity", (Object)cpe);
            Query q1 = em.createQuery("Select c from JPA_CACHEABLE_RELATIONSHIPS c");
            q1.setHint("eclipselink.read-only", (Object)"true");
            CacheableRelationshipsEntity cre = (CacheableRelationshipsEntity)q1.getResultList().get(0);
            for (CacheableFalseEntity cfe1 : cre.getCacheableFalses()) {
                CacheableModelJunitTest.assertNotNull((String)"Did not load the CacheableFalse related Entity in OneToMany relationship", (Object)cfe1);
            }
            for (CacheableProtectedEntity cpe1 : cre.getCacheableProtecteds()) {
                CacheableModelJunitTest.assertNotNull((String)"Did not load the CacheableProtected related Entity in OneToMany relationship", (Object)cpe1);
            }
            CacheableForceProtectedEntity cfpe = cre.getCacheableFPE();
            CacheableModelJunitTest.assertNotNull((String)"Did not load the Cacheable Force Protected related Entity in ManyToOne relationship", (Object)cfpe);
            for (CacheableFalseDetail cfde : cre.getCacheableFalseDetails()) {
                CacheableModelJunitTest.assertNotNull((String)"Did not load the CacheableFalse Details related Entity in ManyToMany relationship", (Object)cfde);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateForceProtectedOneToOne() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        int cfeID = 0;
        try {
            CacheableForceProtectedEntity cte = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)m_cacheableForceProtectedEntity1Id);
            CacheableFalseEntity oldcfe = cte.getCacheableFalse();
            ServerSession session = (ServerSession)em.unwrap(ServerSession.class);
            CacheableFalseEntity cfe = new CacheableFalseEntity();
            em.persist((Object)cfe);
            cfeID = cfe.getId();
            cte.setCacheableFalse(cfe);
            this.commitTransaction(em);
            CacheableForceProtectedEntity cachedCPE = (CacheableForceProtectedEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cte);
            CacheableModelJunitTest.assertNull((String)"A protected OneToOne relationship was merged into the shared cache", (Object)cachedCPE.getCacheableFalse());
            ObjectReferenceMapping orm = (ObjectReferenceMapping)session.getDescriptor(CacheableForceProtectedEntity.class).getMappingForAttributeName("cacheableFalse");
            Object cacheableFalsefk = session.getIdentityMapAccessorInstance().getCacheKeyForObject((Object)cte).getProtectedForeignKeys().get(orm.getSelectFields().get(0));
            CacheableModelJunitTest.assertEquals((String)"FK update not cached", (Object)cfe.getId(), (Object)cacheableFalsefk);
            this.beginTransaction(em);
            cte.setCacheableFalse(oldcfe);
            cfe = (CacheableFalseEntity)em.find(CacheableFalseEntity.class, (Object)cfeID);
            em.remove((Object)cfe);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateForceProtectedBasic() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        try {
            CacheableForceProtectedEntity cte = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)m_cacheableForceProtectedEntity1Id);
            String newName = "SomeNewName" + System.currentTimeMillis();
            cte.setName(newName);
            this.commitTransaction(em);
            ServerSession session = (ServerSession)em.unwrap(ServerSession.class);
            CacheableForceProtectedEntity cachedCPE = (CacheableForceProtectedEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cte);
            CacheableModelJunitTest.assertEquals((String)("A Basic mapping in a Protected class was not merged into the shared cache.  Expected: " + newName + " found: " + cachedCPE.getName()), (String)cachedCPE.getName(), (String)newName);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateProtectedBasic() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        try {
            CacheableProtectedEntity cte = (CacheableProtectedEntity)em.find(CacheableProtectedEntity.class, (Object)m_cacheableProtectedEntityId);
            ServerSession session = (ServerSession)em.unwrap(ServerSession.class);
            String newName = "SomeNewName" + System.currentTimeMillis();
            cte.setName(newName);
            this.commitTransaction(em);
            CacheableProtectedEntity cachedCPE = (CacheableProtectedEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cte);
            CacheableModelJunitTest.assertEquals((String)"A Basic mapping in a Protected class was not merged into the shared cache", (String)newName, (String)cachedCPE.getName());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateProtectedOneToMany() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        int cfeID = 0;
        try {
            CacheableForceProtectedEntity cte = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)m_cacheableForceProtectedEntity1Id);
            ServerSession session = (ServerSession)em.unwrap(ServerSession.class);
            CacheableProtectedEntity cfe = new CacheableProtectedEntity();
            em.persist((Object)cfe);
            cfeID = cfe.getId();
            cfe.setForcedProtected(cte);
            cte.getCacheableProtecteds().add(cfe);
            this.commitTransaction(em);
            CacheableForceProtectedEntity cachedCPE = (CacheableForceProtectedEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cte);
            CacheableModelJunitTest.assertFalse((String)"A protected OneToMany relationship was not merged into the shared cache", (cachedCPE.getCacheableProtecteds() == null || cachedCPE.getCacheableProtecteds().isEmpty() ? 1 : 0) != 0);
            this.beginTransaction(em);
            cte.getCacheableProtecteds().clear();
            cfe.setForcedProtected(null);
            cfe = (CacheableProtectedEntity)em.find(CacheableProtectedEntity.class, (Object)cfeID);
            em.remove((Object)cfe);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateProtectedManyToOne() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        int creID = 0;
        try {
            CacheableForceProtectedEntity cfpe = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)m_cacheableForceProtectedEntity1Id);
            ServerSession session = (ServerSession)em.unwrap(ServerSession.class);
            CacheableRelationshipsEntity cre = new CacheableRelationshipsEntity();
            em.persist((Object)cre);
            creID = cre.getId();
            cre.setCacheableFPE(cfpe);
            this.commitTransaction(em);
            CacheableRelationshipsEntity cachedCRE = (CacheableRelationshipsEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cre);
            CacheableModelJunitTest.assertFalse((String)"A protected ManyToOne relationship was not merged into the shared cache", (cachedCRE.getCacheableFPE() == null ? 1 : 0) != 0);
            this.beginTransaction(em);
            cre = (CacheableRelationshipsEntity)em.find(CacheableRelationshipsEntity.class, (Object)creID);
            em.remove((Object)cre);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateProtectedManyToMany() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        int cfdID1 = 0;
        int cfdID2 = 0;
        try {
            CacheableRelationshipsEntity cre = (CacheableRelationshipsEntity)em.find(CacheableRelationshipsEntity.class, (Object)m_cacheableRelationshipsEntityId);
            ServerSession session = (ServerSession)em.unwrap(ServerSession.class);
            CacheableFalseDetail cfd1 = new CacheableFalseDetail();
            CacheableFalseDetail cfd2 = new CacheableFalseDetail();
            em.persist((Object)cfd1);
            em.persist((Object)cfd2);
            cfdID1 = cfd1.getId();
            cfdID2 = cfd2.getId();
            cre.addCacheableFalseDetail(cfd1);
            cre.addCacheableFalseDetail(cfd2);
            this.commitTransaction(em);
            CacheableRelationshipsEntity cachedCRE = (CacheableRelationshipsEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cre);
            CacheableModelJunitTest.assertTrue((String)"A protected ManyToMany relationship was merged into the shared cache", (cachedCRE.getCacheableFalseDetails() == null || cachedCRE.getCacheableFalseDetails().isEmpty() ? 1 : 0) != 0);
            this.beginTransaction(em);
            cre.getCacheableFalseDetails().clear();
            cre = (CacheableRelationshipsEntity)em.find(CacheableRelationshipsEntity.class, (Object)m_cacheableRelationshipsEntityId);
            cfd1 = (CacheableFalseDetail)em.find(CacheableFalseDetail.class, (Object)cfdID1);
            cfd2 = (CacheableFalseDetail)em.find(CacheableFalseDetail.class, (Object)cfdID2);
            cre.removeCacheableFalseDetail(cfd1);
            cre.removeCacheableFalseDetail(cfd2);
            em.remove((Object)cfd1);
            em.remove((Object)cfd2);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateProtectedElementCollection() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        try {
            CacheableRelationshipsEntity cre = (CacheableRelationshipsEntity)em.find(CacheableRelationshipsEntity.class, (Object)m_cacheableRelationshipsEntityId);
            ServerSession session = (ServerSession)em.unwrap(ServerSession.class);
            ProtectedEmbeddable cem1 = new ProtectedEmbeddable();
            ProtectedEmbeddable cem2 = new ProtectedEmbeddable();
            cre.addProtectedEmbeddable(cem1);
            cre.addProtectedEmbeddable(cem2);
            this.commitTransaction(em);
            CacheableRelationshipsEntity cachedCRE = (CacheableRelationshipsEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cre);
            CacheableModelJunitTest.assertTrue((String)"A protected ElementCollection relationship was merged into the shared cache", (cachedCRE.getProtectedEmbeddables() == null || cachedCRE.getProtectedEmbeddables().isEmpty() ? 1 : 0) != 0);
            this.beginTransaction(em);
            cre.getProtectedEmbeddables().clear();
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsolationBeforeEarlyTxBegin() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        int cfeID = 0;
        try {
            CacheableForceProtectedEntity cte = (CacheableForceProtectedEntity)em.find(CacheableForceProtectedEntity.class, (Object)m_cacheableForceProtectedEntity1Id);
            ServerSession session = (ServerSession)em.unwrap(ServerSession.class);
            CacheableProtectedEntity cfe = new CacheableProtectedEntity();
            em.persist((Object)cfe);
            cfeID = cfe.getId();
            cfe.setForcedProtected(cte);
            cte.getCacheableProtecteds().add(cfe);
            em.flush();
            CacheableRelationshipsEntity cre = (CacheableRelationshipsEntity)em.find(CacheableRelationshipsEntity.class, (Object)m_cacheableRelationshipsEntityId);
            CacheableRelationshipsEntity cachedCRE = (CacheableRelationshipsEntity)session.getIdentityMapAccessor().getFromIdentityMap((Object)cre);
            CacheableModelJunitTest.assertTrue((String)"A protected OneToMany relationship was merged into the shared cache", (cachedCRE.getCacheableFalses() == null || cachedCRE.getCacheableFalses().isEmpty() ? 1 : 0) != 0);
            this.commitTransaction(em);
            this.beginTransaction(em);
            cte.getCacheableProtecteds().clear();
            cfe.setForcedProtected(null);
            cfe = (CacheableProtectedEntity)em.find(CacheableProtectedEntity.class, (Object)cfeID);
            em.remove((Object)cfe);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCacheableTrueEntityNameAndBypassStore(String name) {
        EntityManager em = this.createDSEntityManager();
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("UPDATE JPA_CACHEABLE_TRUE e SET e.name = :name WHERE e.id = :id ").setParameter("name", (Object)name).setParameter("id", (Object)m_cacheableTrueEntity1Id);
            query.setHint("javax.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
            query.executeUpdate();
            this.commitTransaction(em);
        }
        catch (Exception e) {
            CacheableModelJunitTest.fail((String)("Error updating the entity through JPQL: " + e));
        }
        finally {
            this.closeEM(em);
        }
    }

    protected void updateCacheableTrueEntityNameInSharedCache(String name) {
        this.updateCacheableTrueEntityNameInSharedCache(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCacheableTrueEntityNameInSharedCache(String name, EntityManager em) {
        EntityManager emToUse = em == null ? this.createDSEntityManager() : em;
        try {
            this.beginTransaction(emToUse);
            emToUse.createQuery("UPDATE JPA_CACHEABLE_TRUE e SET e.name = :name WHERE e.id = :id ").setParameter("name", (Object)name).setParameter("id", (Object)m_cacheableTrueEntity1Id).executeUpdate();
            this.commitTransaction(emToUse);
        }
        catch (Exception e) {
            CacheableModelJunitTest.fail((String)("Error updating the entity through JPQL: " + e));
        }
        finally {
            if (em == null) {
                this.closeEM(emToUse);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeNonCachedWithRelationship() {
        EntityManager em = this.createDSEntityManager();
        this.beginTransaction(em);
        CacheableFalseEntity entity = new CacheableFalseEntity();
        em.persist((Object)entity);
        this.commitTransaction(em);
        em.clear();
        CacheableFalseDetailWithBackPointer detail = null;
        try {
            detail = new CacheableFalseDetailWithBackPointer();
            detail.setEntity(entity);
            ArrayList<CacheableFalseDetailWithBackPointer> details = new ArrayList<CacheableFalseDetailWithBackPointer>();
            details.add(detail);
            entity.setDetailsBackPointer(details);
            detail.setDescription("test");
            this.beginTransaction(em);
            detail = (CacheableFalseDetailWithBackPointer)em.merge((Object)detail);
            this.commitTransaction(em);
            this.beginTransaction(em);
            detail = (CacheableFalseDetailWithBackPointer)em.find(detail.getClass(), (Object)detail.getId());
            em.refresh((Object)detail);
            this.commitTransaction(em);
            CacheableModelJunitTest.assertTrue((String)"detail does not have it's entity.", (detail.getEntity() != null ? 1 : 0) != 0);
            CacheableModelJunitTest.assertTrue((String)"detail's entity does not have the backpointer.", (detail.getEntity().getDetailsBackPointer().size() == 1 ? 1 : 0) != 0);
        }
        finally {
            this.beginTransaction(em);
            detail = (CacheableFalseDetailWithBackPointer)em.merge((Object)detail);
            em.remove((Object)detail.getEntity());
            em.remove((Object)detail);
            this.commitTransaction(em);
            this.closeEM(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndirectCollectionRefreshBehavior() {
        QuerySQLTracker counter = new QuerySQLTracker((Session)CacheableModelJunitTest.getServerSession());
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            CacheableFalseEntity entity = new CacheableFalseEntity();
            CacheableFalseDetailWithBackPointer detail = new CacheableFalseDetailWithBackPointer();
            ArrayList<CacheableFalseDetailWithBackPointer> details = new ArrayList<CacheableFalseDetailWithBackPointer>();
            details.add(detail);
            entity.setDetailsBackPointer(details);
            detail.setEntity(entity);
            em.persist((Object)entity);
            em.flush();
            em.clear();
            counter.getSqlStatements().clear();
            Query query = em.createQuery("SELECT e from JPA_CACHEABLE_FALSE e where e.id = :id").setParameter("id", (Object)entity.getId());
            query.setHint("eclipselink.refresh", (Object)"True");
            entity = (CacheableFalseEntity)query.getResultList().get(0);
            IndirectList list = (IndirectList)entity.getDetailsBackPointer();
            CacheableModelJunitTest.assertFalse((boolean)list.isInstantiated());
            CacheableModelJunitTest.assertTrue((counter.getSqlStatements().size() == 2 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            counter.remove();
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerivedIDProtectedRead() {
        EntityManager em = this.createEntityManager();
        CacheableFalseEntity cf = null;
        CacheableTrueDerivedIDEntity ctdid = null;
        try {
            this.beginTransaction(em);
            cf = new CacheableFalseEntity();
            em.persist((Object)cf);
            em.flush();
            ctdid = new CacheableTrueDerivedIDEntity("desc1", cf);
            em.persist((Object)ctdid);
            this.commitTransaction(em);
            em.clear();
            ctdid = (CacheableTrueDerivedIDEntity)em.find(CacheableTrueDerivedIDEntity.class, (Object)new CacheableTrueDerivedIDPK(ctdid.getPk().getDescription(), cf.getId()));
            CacheableModelJunitTest.assertNotNull((String)"The protected cached relationship was not properly retrieved", (Object)ctdid.getCacheableFalse());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.beginTransaction(em);
            cf = (CacheableFalseEntity)em.find(CacheableFalseEntity.class, (Object)cf.getId());
            ctdid = (CacheableTrueDerivedIDEntity)em.find(ctdid.getClass(), (Object)ctdid.getPk());
            em.remove((Object)cf);
            em.remove((Object)ctdid);
            this.commitTransaction(em);
        }
    }

    protected boolean usesNoCache(ClassDescriptor descriptor) {
        return descriptor.isIsolated();
    }
}

