/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledBorder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public final class TransformerEditingPanel
extends AbstractPanel {
    private TransformerSpec transformerSpec;

    public TransformerEditingPanel(TransformerSpec transformerSpec, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.transformerSpec = transformerSpec;
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        JRadioButton methodButton = this.buildMethodButton();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)methodButton, constraints);
        JPanel methodChooserPanel = this.buildMethodChooserPanel();
        methodChooserPanel.setBorder(new AccessibleTitledBorder(methodButton.getText()));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, SwingTools.checkBoxIconWidth(), 0, 0);
        this.add((Component)methodChooserPanel, constraints);
        JRadioButton classButton = this.buildClassButton();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)classButton, constraints);
        JPanel classChooser = this.buildClassChooserPanel();
        classChooser.setBorder(new AccessibleTitledBorder(classButton.getText()));
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, SwingTools.checkBoxIconWidth(), 0, 0);
        this.add((Component)classChooser, constraints);
    }

    private JRadioButton buildMethodButton() {
        JRadioButton button = new JRadioButton();
        button.setModel(this.buildMethodButtonModel());
        button.setText(this.resourceRepository().getString("TRANSFORMER_PANEL_METHOD_BUTTON"));
        button.setMnemonic(this.resourceRepository().getMnemonic("TRANSFORMER_PANEL_METHOD_BUTTON"));
        return button;
    }

    private ButtonModel buildMethodButtonModel() {
        return new RadioButtonModelAdapter(this.transformerSpec.transformerTypeHolder(), "transformationMethod");
    }

    private JPanel buildMethodChooserPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        JLabel methodLabel = this.buildMethodChooserLabel();
        panel.add((Component)methodLabel, "Before");
        this.addAlignLeft(methodLabel);
        ListChooser methodChooser = this.buildMethodChooser();
        methodLabel.setLabelFor(methodChooser);
        panel.add((Component)methodChooser, "Center");
        Spacer spacer = new Spacer();
        panel.add((Component)spacer, "After");
        this.addAlignRight(spacer);
        return panel;
    }

    private JLabel buildMethodChooserLabel() {
        JLabel label = this.buildLabel("TRANSFORMER_PANEL_METHOD_CHOOSER");
        this.transformerSpec.transformerTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(label, "transformationMethod"));
        label.setEnabled(this.transformerSpec.transformerTypeHolder().getValue() == "transformationMethod");
        return label;
    }

    private ListChooser buildMethodChooser() {
        DefaultListChooser chooser = new DefaultListChooser(this.buildMethodChooserModel(), this.getWorkbenchContextHolder(), this.buildMethodChooserDialogBuilder());
        chooser.setRenderer(this.buildMethodRenderer());
        this.transformerSpec.transformerTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(chooser, "transformationMethod"));
        chooser.setEnabled(this.transformerSpec.transformerTypeHolder().getValue() == "transformationMethod");
        return chooser;
    }

    private DefaultListChooserDialog.Builder buildMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setStringConverter(this.buildMWMethodStringConverter());
        return builder;
    }

    private StringConverter buildMWMethodStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWMethod)o).shortSignatureWithReturnType();
            }
        };
    }

    private ComboBoxModel buildMethodChooserModel() {
        return new ComboBoxModelAdapter(this.buildMethodChoicesValue(), this.transformerSpec.transformationMethodHolder());
    }

    private ListValueModel buildMethodChoicesValue() {
        return new SortedListValueModelAdapter(new ReadOnlyCollectionValueModel(CollectionTools.collection((Iterator)this.transformerSpec.candidateTransformationMethods())));
    }

    private ListCellRenderer buildMethodRenderer() {
        return new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository()){

            @Override
            protected Icon buildNonNullValueIcon(Object value) {
                return null;
            }
        });
    }

    private JRadioButton buildClassButton() {
        JRadioButton button = new JRadioButton();
        button.setModel(this.buildClassButtonModel());
        button.setText(this.resourceRepository().getString("TRANSFORMER_PANEL_CLASS_BUTTON"));
        button.setMnemonic(this.resourceRepository().getMnemonic("TRANSFORMER_PANEL_CLASS_BUTTON"));
        return button;
    }

    private ButtonModel buildClassButtonModel() {
        return new RadioButtonModelAdapter(this.transformerSpec.transformerTypeHolder(), "transformerClass");
    }

    private JPanel buildClassChooserPanel() {
        AccessibleTitledPanel panel = new AccessibleTitledPanel(new BorderLayout(5, 0));
        JLabel label = this.buildClassChooserLabel();
        panel.add((Component)label, "Before");
        this.addAlignLeft(label);
        ClassChooserPanel chooser = this.buildClassChooserPanel2(label);
        panel.add((Component)chooser, "Center");
        this.addPaneForAlignment(chooser);
        return panel;
    }

    private JLabel buildClassChooserLabel() {
        JLabel label = new JLabel(this.resourceRepository().getString("TRANSFORMER_PANEL_CLASS_CHOOSER"));
        label.setDisplayedMnemonic(this.resourceRepository().getMnemonic("TRANSFORMER_PANEL_CLASS_CHOOSER"));
        this.transformerSpec.transformerTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(label, "transformerClass"));
        label.setEnabled(this.transformerSpec.transformerTypeHolder().getValue() == "transformerClass");
        return label;
    }

    private ClassChooserPanel buildClassChooserPanel2(JLabel label) {
        ClassChooserPanel chooserPanel = ClassChooserTools.buildPanel(this.transformerSpec.transformerClassHolder(), this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableNonVoidFilter(), label, this.getWorkbenchContextHolder());
        this.transformerSpec.transformerTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(chooserPanel, "transformerClass"));
        chooserPanel.setEnabled(this.transformerSpec.transformerTypeHolder().getValue() == "transformerClass");
        return chooserPanel;
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            @Override
            public MWClassRepository getClassRepository() {
                return TransformerEditingPanel.this.transformerSpec.classRepository();
            }
        };
    }

    private PropertyChangeListener buildComponentEnablingListener(final Component component, final String enabledValue) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                component.setEnabled(evt.getNewValue() == enabledValue);
            }
        };
    }

    public static interface TransformerSpec {
        public static final String TRANSFORMATION_METHOD = "transformationMethod";
        public static final String TRANSFORMER_CLASS = "transformerClass";
        public static final String NULL_TRANSFORMER = "nullTransformer";

        public PropertyValueModel transformerTypeHolder();

        public String transformerType();

        public PropertyValueModel transformationMethodHolder();

        public MWMethod transformationMethod();

        public Iterator candidateTransformationMethods();

        public boolean transformationMethodIsValid();

        public PropertyValueModel transformerClassHolder();

        public MWClass transformerClass();

        public MWClassRepository classRepository();
    }
}

