/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCompoundExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpression;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.BasicExpressionPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.CompoundExpressionTreeNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionTree;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionTreeNode;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;

final class ExpressionTreePanel
extends AbstractPanel {
    private MWCompoundExpression expression;
    private PropertyValueModel selectedExpressionHolder;
    private PropertyValueModel selectedCompoundExpressionHolder;
    private ExpressionTree expressionTree;
    private DefaultTreeModel expressionTreeModel;
    private TreeSelectionModel expressionTreeSelectionModel;
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String NAND = "NAND";
    public static final String NOR = "NOR";
    private JButton addButton;
    private JButton addNestedButton;
    private JButton removeButton;
    private JComboBox logicalOperatorComboBox;
    private BasicExpressionPanel basicExpressionPanel;
    private String baseTopicId;

    ExpressionTreePanel(WorkbenchContextHolder contextHolder, String baseTopicId) {
        super(contextHolder);
        this.baseTopicId = baseTopicId;
        this.initialize();
    }

    private void addBasicExpresion() {
        MWCompoundExpression compoundExpression;
        ExpressionTreeNode node = this.getSelectedCompoundExpressionNode();
        if (node == null) {
            compoundExpression = this.expression;
            node = (ExpressionTreeNode)this.expressionTreeModel.getRoot();
        } else {
            compoundExpression = (MWCompoundExpression)node.getUserObject();
        }
        MWBasicExpression basicExpression = compoundExpression.addBasicExpression();
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            ExpressionTreeNode treeNode = (ExpressionTreeNode)children.nextElement();
            if (treeNode.getUserObject() != basicExpression) continue;
            this.expressionTreeSelectionModel.setSelectionPath(new TreePath(treeNode.getPath()));
        }
    }

    private void addNestedExpresion() {
        ExpressionTreeNode node = this.getSelectedCompoundExpressionNode();
        MWCompoundExpression compoundExpression = this.getSelectedCompoundExpression();
        if (compoundExpression == null) {
            compoundExpression = this.expression;
            node = (ExpressionTreeNode)this.expressionTreeModel.getRoot();
        }
        MWCompoundExpression addedExpression = compoundExpression.addSubCompoundExpression();
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            ExpressionTreeNode treeNode = (ExpressionTreeNode)children.nextElement();
            if (treeNode.getUserObject() != addedExpression) continue;
            this.expressionTreeSelectionModel.setSelectionPath(new TreePath(((ExpressionTreeNode)treeNode.getChildAt(0)).getPath()));
        }
    }

    private ActionListener buildAddBasicExpresionAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ExpressionTreePanel.this.addBasicExpresion();
            }
        };
    }

    private ActionListener buildAddNestedExpressionAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ExpressionTreePanel.this.addNestedExpresion();
            }
        };
    }

    private ActionListener buildRemoveExpressionAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ExpressionTreePanel.this.removeSelectedExpressions();
            }
        };
    }

    private Iterator allowableOperatorTypes() {
        ArrayList<String> operatorTypes = new ArrayList<String>();
        operatorTypes.add(AND);
        operatorTypes.add(OR);
        operatorTypes.add(NAND);
        operatorTypes.add(NOR);
        return operatorTypes.iterator();
    }

    private MWCompoundExpression getSelectedCompoundExpression() {
        MWExpression selectedExpression = this.getSelectedExpression();
        if (selectedExpression == null) {
            return null;
        }
        if (MWCompoundExpression.class.isAssignableFrom(selectedExpression.getClass())) {
            return (MWCompoundExpression)selectedExpression;
        }
        return ((MWBasicExpression)selectedExpression).getParentCompoundExpression();
    }

    private ExpressionTreeNode getSelectedCompoundExpressionNode() {
        TreePath selectionPath = this.expressionTreeSelectionModel.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        while (selectionPath.getPathCount() > 0) {
            ExpressionTreeNode lastNode = (ExpressionTreeNode)selectionPath.getLastPathComponent();
            if (MWCompoundExpression.class.isAssignableFrom(lastNode.getUserObject().getClass())) {
                return lastNode;
            }
            selectionPath = selectionPath.getParentPath();
        }
        return null;
    }

    private ExpressionTreeNode getSelectedExpressionNode() {
        if (this.expressionTreeSelectionModel.getSelectionPath() == null || this.expressionTreeSelectionModel.getSelectionCount() > 1) {
            return null;
        }
        return (ExpressionTreeNode)this.expressionTreeSelectionModel.getSelectionPath().getLastPathComponent();
    }

    private MWExpression getSelectedExpression() {
        ExpressionTreeNode selectedNode = this.getSelectedExpressionNode();
        if (selectedNode == null) {
            return null;
        }
        return (MWExpression)selectedNode.getUserObject();
    }

    private PropertyValueModel buildSelectedCompoundExpressionHolder(PropertyValueModel selectedExpressionHolder) {
        return new FilteringPropertyValueModel(selectedExpressionHolder){

            @Override
            protected boolean accept(Object value) {
                return value instanceof MWCompoundExpression;
            }
        };
    }

    private void initialize() {
        this.selectedExpressionHolder = new SimplePropertyValueModel();
        this.selectedCompoundExpressionHolder = this.buildSelectedCompoundExpressionHolder(this.selectedExpressionHolder);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.expressionTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("RootNode"), true);
        this.expressionTree = new ExpressionTree(this.expressionTreeModel);
        this.addHelpTopicId(this.expressionTree, this.baseTopicId);
        this.expressionTreeSelectionModel = this.expressionTree.getSelectionModel();
        this.expressionTreeSelectionModel.setSelectionMode(1);
        JScrollPane expressionTreePane = new JScrollPane(this.expressionTree);
        expressionTreePane.setPreferredSize(new Dimension(10, 10));
        this.expressionTree.addTreeSelectionListener(new ExpressionTreeSelectionListener());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)expressionTreePane, constraints);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.addButton = new JButton(this.resourceRepository().getString("ADD_EXPRESSION_BUTTON"));
        this.addButton.setMnemonic(this.resourceRepository().getMnemonic("ADD_EXPRESSION_BUTTON"));
        this.addButton.addActionListener(this.buildAddBasicExpresionAction());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        buttonPanel.add((Component)this.addButton, constraints);
        this.addNestedButton = new JButton(this.resourceRepository().getString("ADD_NESTED_EXPRESSION_BUTTON"));
        this.addNestedButton.addActionListener(this.buildAddNestedExpressionAction());
        this.addNestedButton.setMnemonic(this.resourceRepository().getMnemonic("ADD_NESTED_EXPRESSION_BUTTON"));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 5, 5);
        buttonPanel.add((Component)this.addNestedButton, constraints);
        this.removeButton = new JButton(this.resourceRepository().getString("REMOVE_EXPRESSION_BUTTON"));
        this.removeButton.setMnemonic(this.resourceRepository().getMnemonic("REMOVE_EXPRESSION_BUTTON"));
        this.removeButton.addActionListener(this.buildRemoveExpressionAction());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 5, 5);
        buttonPanel.add((Component)this.removeButton, constraints);
        JLabel operatorLabel = new JLabel(this.resourceRepository().getString("OPERATOR_TYPE_COMBO_BOX_LABEL"));
        operatorLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("OPERATOR_TYPE_COMBO_BOX_LABEL"));
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 5, 5);
        buttonPanel.add((Component)operatorLabel, constraints);
        this.logicalOperatorComboBox = new JComboBox();
        this.logicalOperatorComboBox.setModel(this.buildLogicalOperatorComboBoxModel());
        operatorLabel.setLabelFor(this.logicalOperatorComboBox);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 5, 5);
        buttonPanel.add((Component)this.logicalOperatorComboBox, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 12;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)buttonPanel, constraints);
        this.basicExpressionPanel = new BasicExpressionPanel(this.selectedExpressionHolder, this.getWorkbenchContextHolder());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 15;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.basicExpressionPanel, constraints);
        this.updateButtons();
    }

    private ComboBoxModel buildLogicalOperatorComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildOperatorTypeCollectionHolder(), this.buildOperatorAdapter());
    }

    private CollectionValueModel buildOperatorTypeCollectionHolder() {
        return new AbstractReadOnlyCollectionValueModel(){

            @Override
            public Object getValue() {
                return ExpressionTreePanel.this.allowableOperatorTypes();
            }
        };
    }

    private PropertyValueModel buildOperatorAdapter() {
        return new PropertyAspectAdapter(this.selectedCompoundExpressionHolder, "operatorType"){

            @Override
            protected Object getValueFromSubject() {
                if (((MWCompoundExpression)this.subject).getOperatorType() == ExpressionTreePanel.AND) {
                    return ExpressionTreePanel.AND;
                }
                if (((MWCompoundExpression)this.subject).getOperatorType() == ExpressionTreePanel.OR) {
                    return ExpressionTreePanel.OR;
                }
                if (((MWCompoundExpression)this.subject).getOperatorType() == ExpressionTreePanel.NAND) {
                    return ExpressionTreePanel.NAND;
                }
                return ExpressionTreePanel.NOR;
            }

            @Override
            protected void setValueOnSubject(Object value) {
                if (value == ExpressionTreePanel.AND) {
                    ExpressionTreePanel.this.getSelectedCompoundExpression().setOperatorType(ExpressionTreePanel.AND);
                } else if (value == ExpressionTreePanel.OR) {
                    ExpressionTreePanel.this.getSelectedCompoundExpression().setOperatorType(ExpressionTreePanel.OR);
                } else if (value == ExpressionTreePanel.NAND) {
                    ExpressionTreePanel.this.getSelectedCompoundExpression().setOperatorType(ExpressionTreePanel.NAND);
                } else if (value == ExpressionTreePanel.NOR) {
                    ExpressionTreePanel.this.getSelectedCompoundExpression().setOperatorType(ExpressionTreePanel.NOR);
                }
            }
        };
    }

    protected void disengageListeners() {
        CompoundExpressionTreeNode rootNode = (CompoundExpressionTreeNode)this.expressionTreeModel.getRoot();
        rootNode.disengageListeners();
        this.expression = null;
    }

    private void removeSelectedExpressions() {
        TreePath[] selectionPaths = this.expressionTreeSelectionModel.getSelectionPaths();
        for (int i = 0; i < selectionPaths.length; ++i) {
            TreePath path = selectionPaths[i];
            ExpressionTreeNode chosenNode = (ExpressionTreeNode)path.getLastPathComponent();
            MWExpression chosenExpression = (MWExpression)chosenNode.getUserObject();
            MWCompoundExpression parentExpression = chosenExpression.getParentCompoundExpression();
            if (parentExpression != null) {
                parentExpression.removeExpression(chosenExpression);
                continue;
            }
            ((MWCompoundExpression)chosenExpression).clearExpressions();
        }
    }

    void setExpression(MWCompoundExpression expression, int selectionRow) {
        this.expression = expression;
        CompoundExpressionTreeNode node = new CompoundExpressionTreeNode(expression);
        this.expressionTreeModel.setRoot(node);
        node.setModel(this.expressionTreeModel);
        ((ExpressionTreeNode)node).initializeChildren();
        for (int i = 0; i < selectionRow; ++i) {
            this.expressionTree.expandRow(i);
        }
        this.expressionTree.setSelectionRow(selectionRow);
        this.expressionTree.scrollRowToVisible(selectionRow);
    }

    private void updateButtons() {
        this.addButton.setEnabled(this.expressionTreeSelectionModel.getSelectionCount() <= 1);
        this.addNestedButton.setEnabled(this.expressionTreeSelectionModel.getSelectionCount() <= 1);
        this.removeButton.setEnabled(this.expressionTreeSelectionModel.getSelectionCount() >= 1);
        this.logicalOperatorComboBox.setEnabled(this.expressionTreeSelectionModel.getSelectionCount() >= 1 && this.getSelectedExpression() != null && MWCompoundExpression.class.isAssignableFrom(this.getSelectedExpression().getClass()));
    }

    protected class ExpressionTreeSelectionListener
    implements TreeSelectionListener {
        protected ExpressionTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (ExpressionTreePanel.this.expressionTreeSelectionModel.getSelectionPath() == null || ExpressionTreePanel.this.expressionTreeSelectionModel.getSelectionCount() > 1) {
                ExpressionTreePanel.this.selectedExpressionHolder.setValue(null);
            } else {
                ExpressionTreeNode selectedNode = (ExpressionTreeNode)ExpressionTreePanel.this.expressionTreeSelectionModel.getSelectionPath().getLastPathComponent();
                ExpressionTreePanel.this.selectedExpressionHolder.setValue(selectedNode.getUserObject());
            }
            ExpressionTreePanel.this.updateButtons();
        }
    }
}

