/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ReadConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.Transformer;

abstract class AbstractReadPoolLoginPropertiesPage
extends ScrollablePropertiesPage {
    private JComponent loginPane;

    AbstractReadPoolLoginPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    private PropertyValueModel buildEnableStateHolder() {
        PropertyAspectAdapter sessionHolder = new PropertyAspectAdapter(this.getSelectionHolder(), ""){

            @Override
            protected Object getValueFromSubject() {
                ConnectionPoolAdapter pool = (ConnectionPoolAdapter)this.subject;
                return pool.getParent().getParent();
            }
        };
        PropertyAspectAdapter loginHolder = new PropertyAspectAdapter(sessionHolder, "login"){

            @Override
            protected Object getValueFromSubject() {
                ServerSessionAdapter session = (ServerSessionAdapter)this.subject;
                return session.getLogin();
            }
        };
        PropertyAspectAdapter booleanHolder = new PropertyAspectAdapter(loginHolder, "externalConnectionPooling"){

            @Override
            protected Object getValueFromSubject() {
                LoginAdapter login = (LoginAdapter)this.subject;
                DatabaseSessionAdapter session = (DatabaseSessionAdapter)login.getParent();
                return session.usesExternalConnectionPooling();
            }
        };
        return new TransformationPropertyValueModel(booleanHolder){

            @Override
            protected Object transform(Object value) {
                return Boolean.FALSE.equals(value);
            }
        };
    }

    private ButtonModel buildExclusiveConnectionsCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildExclusiveConnectionsHolder());
    }

    private PropertyValueModel buildExclusiveConnectionsHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "exclusive"){

            @Override
            protected Object getValueFromSubject() {
                ReadConnectionPoolAdapter pool = (ReadConnectionPoolAdapter)this.subject;
                return pool.isExclusive();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ReadConnectionPoolAdapter pool = (ReadConnectionPoolAdapter)this.subject;
                pool.setExclusive((Boolean)value);
            }
        };
    }

    protected final PropertyValueModel buildLoginHolder() {
        String[] propertyNames = new String[]{"loginConfig", "useNonTransactionalReadLogin"};
        return new PropertyAspectAdapter(this.getSelectionHolder(), propertyNames){

            @Override
            protected Object getValueFromSubject() {
                ReadConnectionPoolAdapter pool = (ReadConnectionPoolAdapter)this.subject;
                return pool.usesNonTransactionalReadLogin() ? pool.getLogin() : null;
            }
        };
    }

    protected abstract JComponent buildLoginPane();

    private Transformer buildLoginPaneTransformer() {
        return new Transformer(){

            public Object transform(Object value) {
                if (value != null && ((Boolean)value).booleanValue()) {
                    return AbstractReadPoolLoginPropertiesPage.this.loginPane;
                }
                return null;
            }
        };
    }

    @Override
    protected final Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        int offset = SwingTools.checkBoxIconWidth();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JCheckBox exclusiveCheckBox = this.buildCheckBox("CONNECTION_READ_EXCLUSIVE_CONNECTIONS_CHECK_BOX", this.buildExclusiveConnectionsCheckBoxAdapter());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)exclusiveCheckBox, constraints);
        this.helpManager().addTopicID(exclusiveCheckBox, "connectionPool.exclusiveTransactions");
        JCheckBox nonTransactionalReadLoginCheckBox = this.buildCheckBox("CONNECTION_READ_USE_NON_TRANSACTIONAL_READ_LOGIN_CHECK_BOX", this.buildUseNonTransactionalReadLoginCheckBoxAdapter());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 5, 0);
        panel.add((Component)nonTransactionalReadLoginCheckBox, constraints);
        this.helpManager().addTopicID(nonTransactionalReadLoginCheckBox, "connectionPool.nonTransactional");
        this.loginPane = this.buildLoginPane();
        SwitcherPanel switcherPane = new SwitcherPanel(this.buildUseNonTransactionalReadLoginHolder(), this.buildLoginPaneTransformer());
        this.loginPane.setName("CONNECTION_READ_LOGIN_PANE");
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, offset, 0, 0);
        panel.add((Component)switcherPane, constraints);
        this.helpManager().addTopicID(this.loginPane, "session.login.database.connection");
        this.installExclusiveConnectionsEnabler(exclusiveCheckBox);
        return panel;
    }

    private ButtonModel buildUseNonTransactionalReadLoginCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildUseNonTransactionalReadLoginHolder());
    }

    private PropertyValueModel buildUseNonTransactionalReadLoginHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "useNonTransactionalReadLogin"){

            @Override
            protected Object getValueFromSubject() {
                ReadConnectionPoolAdapter pool = (ReadConnectionPoolAdapter)this.subject;
                return pool.usesNonTransactionalReadLogin();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ReadConnectionPoolAdapter pool = (ReadConnectionPoolAdapter)this.subject;
                pool.setUseNonTransactionalReadLogin(Boolean.TRUE.equals(value));
            }
        };
    }

    private ComponentEnabler installExclusiveConnectionsEnabler(JComponent component) {
        return new ComponentEnabler((ValueModel)this.buildEnableStateHolder(), component);
    }
}

