/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import org.eclipse.persistence.jpa.jpql.AbstractContentAssistVisitor;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.CastExpression;
import org.eclipse.persistence.jpa.jpql.parser.DatabaseType;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExtractExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RegexpExpression;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.TableExpression;
import org.eclipse.persistence.jpa.jpql.parser.TableVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.UnionClause;

public class EclipseLinkContentAssistVisitor
extends AbstractContentAssistVisitor
implements EclipseLinkExpressionVisitor {
    public EclipseLinkContentAssistVisitor(JPQLQueryContext queryContext) {
        super(queryContext);
    }

    protected AcceptableTypeVisitor buildAcceptableTypeVisitor() {
        return new AcceptableTypeVisitor();
    }

    protected AppendableExpressionVisitor buildAppendableExpressionVisitor() {
        return new AppendableExpressionVisitor();
    }

    protected EndingQueryPositionBuilder buildEndingQueryPositionBuilder() {
        return new EndingQueryPositionBuilder();
    }

    protected AbstractContentAssistVisitor.GroupByClauseCollectionHelper buildGroupByClauseCollectionHelper() {
        return new AbstractContentAssistVisitor.GroupByClauseCollectionHelper();
    }

    protected OrderByClauseStatementHelper buildOrderByClauseStatementHelper() {
        return new OrderByClauseStatementHelper();
    }

    protected TableExpressionVisitor buildTableExpressionVisitor() {
        return new TableExpressionVisitor();
    }

    protected TrailingCompletenessVisitor buildTrailingCompletenessVisitor() {
        return new TrailingCompletenessVisitor();
    }

    protected UnionClauseStatementHelper buildUnionClauseStatementHelper() {
        return new UnionClauseStatementHelper();
    }

    protected TableExpressionVisitor getTableExpressionVisitor() {
        TableExpressionVisitor visitor = this.getHelper(TableExpressionVisitor.class);
        if (visitor == null) {
            visitor = this.buildTableExpressionVisitor();
            this.registerHelper(TableExpressionVisitor.class, visitor);
        }
        return visitor;
    }

    protected UnionClauseStatementHelper getUnionClauseStatementHelper() {
        UnionClauseStatementHelper helper = this.getHelper(UnionClauseStatementHelper.class);
        if (helper == null) {
            helper = this.buildUnionClauseStatementHelper();
            this.registerHelper(UnionClauseStatementHelper.class, helper);
        }
        return helper;
    }

    protected void initialize() {
        super.initialize();
        this.compoundTypeFilters.put("REGEXP", AbstractContentAssistVisitor.CompoundTypeFilter.VALID_INSTANCE);
    }

    protected boolean isJoinFetchIdentifiable() {
        return this.queryContext.getGrammar().getProviderVersion().equals("2.4");
    }

    protected boolean isTableExpression(Expression expression) {
        TableExpressionVisitor visitor = this.getTableExpressionVisitor();
        try {
            visitor.expression = expression;
            expression.accept(visitor);
            boolean bl = visitor.valid;
            return bl;
        }
        finally {
            visitor.valid = false;
            visitor.expression = null;
        }
    }

    public void visit(CastExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.addIdentifier(identifier);
            this.addIdentificationVariables();
            this.addFunctionIdentifiers(expression.getParent().findQueryBNF(expression));
        } else if (expression.hasLeftParenthesis()) {
            Expression scalarExpression;
            int length = identifier.length() + 1;
            if (position == length) {
                this.addIdentificationVariables();
                this.addFunctionIdentifiers(expression.encapsulatedExpressionBNF());
            } else if (expression.hasExpression() && this.isComplete(scalarExpression = expression.getExpression())) {
                length += scalarExpression.getLength();
                if (expression.hasSpaceAfterExpression()) {
                    if (position == ++length) {
                        this.addAggregateIdentifiers(expression.encapsulatedExpressionBNF());
                        this.proposals.addIdentifier("AS");
                    } else if (this.isPositionWithin(position, length, "AS")) {
                        this.proposals.addIdentifier("AS");
                    }
                }
            }
        }
    }

    public void visit(DatabaseType expression) {
        super.visit(expression);
    }

    public void visit(ExtractExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier(identifier);
            this.addFunctionIdentifiers(expression);
        } else if (expression.hasLeftParenthesis()) {
            int length = identifier.length() + 1;
            if (expression.hasDatePart()) {
                String datePart = expression.getDatePart();
                this.isPositionWithin(position, length, datePart);
                length += datePart.length();
                if (expression.hasSpaceAfterDatePart() && position == ++length) {
                    this.addIdentifier("FROM");
                    if (!expression.hasExpression() || !expression.hasFrom()) {
                        this.addIdentificationVariables();
                        this.addFunctionIdentifiers(expression.encapsulatedExpressionBNF());
                    }
                }
            }
            if (expression.hasFrom()) {
                if (this.isPositionWithin(position, length, "FROM")) {
                    this.proposals.addIdentifier("FROM");
                    if (!expression.hasExpression()) {
                        this.addIdentificationVariables();
                        this.addFunctionIdentifiers(expression.encapsulatedExpressionBNF());
                    }
                }
                length += 4;
                if (expression.hasSpaceAfterFrom()) {
                    ++length;
                }
                if (position == length) {
                    this.addIdentificationVariables();
                    this.addFunctionIdentifiers(expression.encapsulatedExpressionBNF());
                }
            }
        }
    }

    public void visit(OrderByItem expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        if (expression.hasExpression()) {
            int length = expression.getExpression().getLength();
            if (expression.hasSpaceAfterExpression()) {
                if (position == ++length) {
                    if (expression.getOrdering() == OrderByItem.Ordering.DEFAULT) {
                        this.proposals.addIdentifier("NULLS FIRST");
                        this.proposals.addIdentifier("NULLS LAST");
                    }
                } else if (position > (length += expression.getActualOrdering().length()) && expression.hasSpaceAfterOrdering()) {
                    if (position == ++length) {
                        this.proposals.addIdentifier("NULLS FIRST");
                        this.proposals.addIdentifier("NULLS LAST");
                    } else {
                        String nullOrdering = expression.getActualNullOrdering();
                        if (this.isPositionWithin(position, length, nullOrdering)) {
                            this.proposals.addIdentifier("NULLS FIRST");
                            this.proposals.addIdentifier("NULLS LAST");
                        }
                    }
                }
            }
        }
    }

    public void visit(RegexpExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        int length = 0;
        if (expression.hasStringExpression()) {
            length += expression.getStringExpression().getLength();
            if (expression.hasSpaceAfterStringExpression()) {
                ++length;
            }
        }
        if (this.isPositionWithin(position, length, "REGEXP")) {
            this.proposals.addIdentifier("REGEXP");
        } else {
            length += 6;
            if (expression.hasSpaceAfterIdentifier()) {
                ++length;
                this.addIdentificationVariables();
                this.addFunctionIdentifiers("pattern_value");
            }
        }
    }

    public void visit(TableExpression expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression);
        if (this.isPositionWithin(position, "TABLE")) {
            this.proposals.addIdentifier("TABLE");
        }
    }

    public void visit(TableVariableDeclaration expression) {
        super.visit(expression);
        TableExpression tableExpression = expression.getTableExpression();
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        int length = tableExpression.getLength();
        if (expression.hasSpaceAfterTableExpression() && this.isPositionWithin(position, ++length, "AS")) {
            this.addIdentifier("AS");
        }
    }

    public void visit(UnionClause expression) {
        super.visit(expression);
        int position = this.queryPosition.getPosition(expression) - (Integer)this.corrections.peek();
        String identifier = expression.getIdentifier();
        if (this.isPositionWithin(position, identifier)) {
            this.proposals.addIdentifier("EXCEPT");
            this.proposals.addIdentifier("INTERSECT");
            this.proposals.addIdentifier("UNION");
        } else if (expression.hasSpaceAfterIdentifier()) {
            int length = identifier.length() + 1;
            if (position == length) {
                this.proposals.addIdentifier("ALL");
                if (!expression.hasAll()) {
                    this.addIdentifier("SELECT");
                }
            } else if (this.isPositionWithin(position, length, "ALL")) {
                this.addIdentifier("ALL");
            } else if (position == length && !expression.hasAll()) {
                this.proposals.addIdentifier("SELECT");
            } else {
                if (expression.hasAll()) {
                    length += 3;
                }
                if (expression.hasSpaceAfterAll() && position == ++length) {
                    this.proposals.addIdentifier("SELECT");
                }
            }
        }
    }

    protected class AcceptableTypeVisitor
    extends AbstractContentAssistVisitor.AcceptableTypeVisitor {
        protected AcceptableTypeVisitor() {
        }
    }

    protected class AppendableExpressionVisitor
    extends AbstractContentAssistVisitor.AppendableExpressionVisitor
    implements EclipseLinkExpressionVisitor {
        protected AppendableExpressionVisitor() {
        }

        public void visit(CastExpression expression) {
            if (expression.hasExpression()) {
                expression.getExpression().accept(this);
            }
        }

        public void visit(DatabaseType expression) {
        }

        public void visit(ExtractExpression expression) {
            if (expression.hasExpression()) {
                expression.getExpression().accept(this);
            }
        }

        public void visit(RegexpExpression expression) {
        }

        public void visit(TableExpression expression) {
        }

        public void visit(TableVariableDeclaration expression) {
        }

        public void visit(UnionClause expression) {
            if (expression.hasQuery()) {
                expression.getQuery().accept(this);
            }
        }
    }

    protected class EndingQueryPositionBuilder
    extends AbstractContentAssistVisitor.EndingQueryPositionBuilder
    implements EclipseLinkExpressionVisitor {
        protected EndingQueryPositionBuilder() {
        }

        public void visit(CastExpression expression) {
            if (this.badExpression) {
                return;
            }
            if (expression.hasScalarExpression() && !expression.hasAs() && !expression.hasDatabaseType() && !expression.hasRightParenthesis()) {
                expression.getExpression().accept(this);
            }
            if (this.queryPosition.getExpression() == null) {
                this.queryPosition.setExpression(expression);
            }
            this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
        }

        public void visit(DatabaseType expression) {
            this.visitAbstractDoubleEncapsulatedExpression(expression);
        }

        public void visit(ExtractExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(RegexpExpression expression) {
            if (this.badExpression) {
                return;
            }
            if (expression.hasPatternValue()) {
                expression.getPatternValue().accept(this);
            }
            if (this.queryPosition.getExpression() == null) {
                this.queryPosition.setExpression(expression);
            }
            this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
        }

        public void visit(TableExpression expression) {
            this.visitAbstractSingleEncapsulatedExpression(expression);
        }

        public void visit(TableVariableDeclaration expression) {
            if (this.badExpression) {
                return;
            }
            if (expression.hasIdentificationVariable()) {
                expression.getIdentificationVariable().accept(this);
            } else if (!expression.hasAs()) {
                expression.getTableExpression().accept(this);
            }
            if (this.queryPosition.getExpression() == null) {
                this.queryPosition.setExpression(expression);
            }
            this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
        }

        public void visit(UnionClause expression) {
            if (this.badExpression) {
                return;
            }
            if (expression.hasQuery()) {
                expression.getQuery().accept(this);
            }
            if (this.queryPosition.getExpression() == null) {
                this.queryPosition.setExpression(expression);
            }
            this.queryPosition.addPosition(expression, expression.getLength() - this.correction);
        }
    }

    protected class OrderByClauseStatementHelper
    extends AbstractContentAssistVisitor.OrderByClauseStatementHelper {
        protected OrderByClauseStatementHelper() {
        }

        public UnionClauseStatementHelper getNextHelper() {
            return EclipseLinkContentAssistVisitor.this.getUnionClauseStatementHelper();
        }

        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return expression.hasSpaceBeforeUnion();
        }
    }

    protected class TableExpressionVisitor
    extends AbstractEclipseLinkExpressionVisitor {
        protected Expression expression;
        protected boolean valid;

        protected TableExpressionVisitor() {
        }

        public void visit(TableExpression expression) {
            this.valid = this.expression == expression;
        }
    }

    protected class TrailingCompletenessVisitor
    extends AbstractContentAssistVisitor.TrailingCompletenessVisitor
    implements EclipseLinkExpressionVisitor {
        protected TrailingCompletenessVisitor() {
        }

        public void visit(CastExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(DatabaseType expression) {
        }

        public void visit(ExtractExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(RegexpExpression expression) {
            this.complete = expression.hasPatternValue();
        }

        public void visit(TableExpression expression) {
            this.complete = expression.hasRightParenthesis();
        }

        public void visit(TableVariableDeclaration expression) {
            this.complete = expression.hasIdentificationVariable();
        }

        public void visit(UnionClause expression) {
            this.complete = expression.hasQuery();
            if (this.complete) {
                expression.getQuery().accept(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UnionClauseStatementHelper
    implements AbstractContentAssistVisitor.StatementHelper<SelectStatement> {
        protected UnionClauseStatementHelper() {
        }

        @Override
        public void addClauseProposals() {
            EclipseLinkContentAssistVisitor.this.addIdentifier("EXCEPT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("INTERSECT");
            EclipseLinkContentAssistVisitor.this.addIdentifier("UNION");
        }

        @Override
        public void addInternalClauseProposals(SelectStatement expression) {
        }

        @Override
        public Expression getClause(SelectStatement expression) {
            return expression.getUnionClauses();
        }

        @Override
        public AbstractContentAssistVisitor.StatementHelper<? extends SelectStatement> getNextHelper() {
            return null;
        }

        @Override
        public boolean hasClause(SelectStatement expression) {
            return expression.hasUnionClauses();
        }

        @Override
        public boolean hasSpaceAfterClause(SelectStatement expression) {
            return false;
        }

        @Override
        public boolean isClauseComplete(SelectStatement expression) {
            UnionClause unionClause = (UnionClause)expression.getUnionClauses();
            Expression subquery = unionClause.getQuery();
            boolean complete = EclipseLinkContentAssistVisitor.this.isValid(subquery, "subquery");
            if (complete) {
                complete = EclipseLinkContentAssistVisitor.this.isComplete(subquery);
            }
            return complete;
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    }
}

