/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.metadata;

import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseTypeWithEnclosedType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitable;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitor;

public class PLSQLCursorType
extends CompositeDatabaseTypeWithEnclosedType
implements CompositeDatabaseType,
DatabaseTypeVisitable {
    static final String REF_CURSOR = "REF CURSOR";
    protected String cursorName;

    public PLSQLCursorType(String cursorName) {
        super(null);
        this.cursorName = cursorName;
    }

    @Override
    public String getTypeName() {
        if (this.enclosedType == null) {
            return "REF CURSOR(" + this.cursorName + ")";
        }
        return this.enclosedType.getTypeName();
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public boolean isWeaklyTyped() {
        return this.enclosedType == null;
    }

    @Override
    public boolean isResolved() {
        if (this.enclosedType == null) {
            return false;
        }
        return this.enclosedType.isResolved();
    }

    @Override
    public boolean isPLSQLCursorType() {
        return true;
    }

    @Override
    public void accept(DatabaseTypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String shortName() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.cursorName);
        sb.append(" IS ");
        sb.append(REF_CURSOR);
        if (this.enclosedType != null) {
            sb.append(" RETURN ");
            sb.append(this.enclosedType.getTypeName());
            if (!this.enclosedType.isResolved()) {
                sb.append("[u]");
            }
        }
        return sb.toString();
    }
}

